/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.ai.animation;

import net.ilexiconn.jurassicraft.common.data.enums.JurassiCraftAnimationIDs;
import net.ilexiconn.jurassicraft.common.entity.ai.AIAnimation;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityHypsilophodon;
import net.minecraft.entity.Entity;

public class AnimationAIHypsilophodonPlaying
extends AIAnimation {
    private EntityHypsilophodon hypsilophodon;
    private double destX;
    private double destZ;
    private double friendSpeedX;
    private double friendSpeedZ;
    private double friendPrevPosX;
    private double friendPrevPosZ;

    public AnimationAIHypsilophodonPlaying(EntityHypsilophodon hypsilophodon) {
        super(hypsilophodon);
        this.hypsilophodon = hypsilophodon;
    }

    @Override
    public int getAnimationId() {
        return JurassiCraftAnimationIDs.PLAYING.animID();
    }

    @Override
    public boolean isAutomatic() {
        return true;
    }

    @Override
    public int getDuration() {
        return 70;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
    }

    public void func_75246_d() {
        if (this.hypsilophodon.getCreatureToAttack() != null && this.hypsilophodon.getCreatureToAttack() instanceof EntityHypsilophodon) {
            EntityHypsilophodon friend = (EntityHypsilophodon)this.hypsilophodon.getCreatureToAttack();
            if (this.hypsilophodon.getAnimationTick() < 5) {
                this.hypsilophodon.func_70671_ap().func_75651_a((Entity)friend, 30.0f, 30.0f);
            }
            if (this.hypsilophodon.getAnimationTick() == 6) {
                this.friendPrevPosX = friend.field_70165_t;
                this.friendPrevPosZ = friend.field_70161_v;
            }
            if (this.hypsilophodon.getAnimationTick() == 7) {
                this.friendSpeedX = friend.field_70165_t - this.friendPrevPosX;
                this.friendSpeedZ = friend.field_70161_v - this.friendPrevPosZ;
                this.destX = friend.field_70165_t + this.friendSpeedX * 12.0;
                this.destZ = friend.field_70161_v + this.friendSpeedZ * 12.0;
                double d = Math.sqrt((this.destX - this.hypsilophodon.field_70165_t) * (this.destX - this.hypsilophodon.field_70165_t) + (this.destZ - this.hypsilophodon.field_70161_v) * (this.destZ - this.hypsilophodon.field_70161_v));
                double a = Math.atan2(this.destZ - this.hypsilophodon.field_70161_v, this.destX - this.hypsilophodon.field_70165_t);
                this.hypsilophodon.field_70159_w = d / 6.0 * Math.cos(a);
                this.hypsilophodon.field_70179_y = d / 6.0 * Math.sin(a);
                this.hypsilophodon.field_70181_x = 0.3;
            }
        }
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.hypsilophodon.setCreatureToAttack(null);
    }
}

