/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.ai;

import java.util.Random;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftFlyingCreature;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class JurassiCraftAIGliding
extends EntityAIBase {
    private final long OWNER_FIND_INTERVAL = 5000L;
    private final long SITTINGSPOT_REACHTIME = 3000L;
    private final double OWNER_DISTANCE_TO_TAKEOFF = 100.0;
    private final EntityJurassiCraftFlyingCreature creature;
    boolean lastChangeDirection;
    int flightTicks = 0;
    double takeOffSpeed = 0.0;
    int targetHeight = 0;
    private ChunkCoordinates currentFlightTarget;
    private Random rand;
    private long nextOwnerCheckTime;
    private long sittingSpotAbortTime;
    private boolean takingOff = false;
    private int nextWingBeat = 10;
    private int wingBeatTick = 0;

    public JurassiCraftAIGliding(EntityJurassiCraftFlyingCreature entity) {
        this.creature = entity;
        this.rand = entity.func_70681_au();
        this.nextOwnerCheckTime = System.currentTimeMillis();
        this.sittingSpotAbortTime = -1L;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.creature.field_70122_E || this.creature.flyingParameters == null) {
            return false;
        }
        return this.checkTakeOffConditions();
    }

    public boolean func_75253_b() {
        return !this.creature.field_70122_E;
    }

    public void func_75249_e() {
        this.takeOff();
    }

    public void func_75251_c() {
        super.func_75251_c();
    }

    public void func_75246_d() {
        ++this.flightTicks;
        if (this.flightTicks > 30 && this.takingOff || this.takingOff && this.creature.field_70163_u >= (double)this.targetHeight) {
            this.takingOff = false;
            this.flightTicks = 0;
        }
        if (this.takingOff) {
            this.creature.func_70612_e(this.creature.flyingParameters.flySpeedModifier / 500.0f, 0.0f);
            this.creature.field_70181_x = this.takeOffSpeed;
        }
        this.checkForLandingSpot();
        MovingObjectPosition mop = this.creature.field_70170_p.func_72933_a(Vec3.func_72443_a((double)this.creature.field_70165_t, (double)this.creature.field_70121_D.field_72338_b, (double)this.creature.field_70161_v), Vec3.func_72443_a((double)(this.creature.field_70165_t + this.creature.field_70159_w * 100.0), (double)this.creature.field_70121_D.field_72338_b, (double)(this.creature.field_70161_v + this.creature.field_70179_y * 100.0)));
        if (mop == null) {
            mop = this.creature.field_70170_p.func_72933_a(Vec3.func_72443_a((double)this.creature.field_70165_t, (double)this.creature.field_70121_D.field_72337_e, (double)this.creature.field_70161_v), Vec3.func_72443_a((double)(this.creature.field_70165_t + this.creature.field_70159_w * 100.0), (double)this.creature.field_70121_D.field_72337_e, (double)(this.creature.field_70161_v + this.creature.field_70179_y * 100.0)));
        }
        if (this.hasLandingSpot()) {
            if (mop == null) {
                double d0 = (double)this.currentFlightTarget.field_71574_a + 0.5 - this.creature.field_70165_t;
                double d1 = (double)this.currentFlightTarget.field_71572_b + 0.1 - this.creature.field_70163_u;
                double d2 = (double)this.currentFlightTarget.field_71573_c + 0.5 - this.creature.field_70161_v;
                this.creature.field_70159_w += (Math.signum(d0) * 1.0 - this.creature.field_70159_w) * (double)0.1f;
                this.creature.field_70181_x += (Math.signum(d1) * (double)0.7f - this.creature.field_70181_x) * (double)0.1f;
                this.creature.field_70179_y += (Math.signum(d2) * 1.0 - this.creature.field_70179_y) * (double)0.1f;
                float f = (float)(Math.atan2(this.creature.field_70179_y, this.creature.field_70159_w) * 180.0 / Math.PI) - 90.0f;
                float f1 = MathHelper.func_76142_g((float)(f - this.creature.field_70177_z));
                this.creature.func_70657_f(0.5f);
                this.creature.field_70177_z += f1;
            }
        } else {
            this.maintainFlight(mop != null);
        }
        super.func_75246_d();
    }

    private void checkForLandingSpot() {
        if (!(this.currentFlightTarget == null || this.creature.field_70170_p.func_147437_c(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b, this.currentFlightTarget.field_71573_c) && this.currentFlightTarget.field_71572_b >= 1)) {
            this.currentFlightTarget = null;
        }
        if (this.currentFlightTarget == null || this.rand.nextInt(30) == 0) {
            this.currentFlightTarget = new ChunkCoordinates((int)(this.creature.field_70165_t + this.creature.field_70159_w * 200.0 + (double)this.rand.nextInt(10) - 5.0), 0, (int)(this.creature.field_70161_v + this.creature.field_70179_y * 200.0 + (double)this.rand.nextInt(10) - 5.0));
            this.currentFlightTarget.field_71572_b = this.creature.field_70170_p.func_72825_h(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71573_c) + 1;
            Material m = this.creature.field_70170_p.func_147439_a(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b - 1, this.currentFlightTarget.field_71573_c).func_149688_o();
            if (this.creature.flyingParameters != null && !this.creature.flyingParameters.willLandInMaterial(m) || !this.creature.field_70170_p.func_147437_c(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b, this.currentFlightTarget.field_71573_c)) {
                this.currentFlightTarget = null;
            }
        }
    }

    private boolean hasLandingSpot() {
        return this.currentFlightTarget != null;
    }

    private void maintainFlight(boolean hasObstacle) {
        ++this.wingBeatTick;
        if (hasObstacle || this.wingBeatTick >= this.nextWingBeat) {
            this.pickDirection(hasObstacle);
            this.nextWingBeat = this.creature.flyingParameters.flapRate + (int)(Math.random() * 0.4 * (double)this.creature.flyingParameters.flapRate - 0.2 * (double)this.creature.flyingParameters.flapRate);
            this.creature.func_70612_e(0.0f, 4.0f + this.creature.flyingParameters.flySpeedModifier / 100.0f * this.creature.flyingParameters.flySpeedModifier);
            this.creature.field_70181_x = (double)(this.creature.flyingParameters.flapRate + 1) * 0.01;
            this.wingBeatTick = 0;
        }
    }

    public void pickDirection(boolean useLastChangeDirection) {
        double rotAmt;
        if (useLastChangeDirection) {
            rotAmt = this.creature.func_70681_au().nextInt(5) + 5;
            if (this.lastChangeDirection) {
                rotAmt *= -1.0;
            }
            String extra = this.creature.func_70638_az() != null ? " has target" : " no target";
        } else {
            rotAmt = this.creature.func_70681_au().nextInt(10) - 5;
            this.lastChangeDirection = rotAmt > 0.0;
        }
        this.creature.field_70177_z = (float)((double)this.creature.field_70177_z + rotAmt);
    }

    private void lookForOwnerEntity() {
        if (System.currentTimeMillis() > this.nextOwnerCheckTime) {
            this.nextOwnerCheckTime = System.currentTimeMillis() + 5000L;
        }
    }

    private boolean checkTakeOffConditions() {
        EntityPlayer nearest = this.creature.field_70170_p.func_72890_a((Entity)this.creature, 6.0);
        if (nearest != null) {
            return true;
        }
        return Math.random() < 0.015;
    }

    private void land() {
        this.sittingSpotAbortTime = -1L;
        this.creature.func_70107_b((double)this.currentFlightTarget.field_71574_a + 0.5, (double)this.currentFlightTarget.field_71572_b + 0.5, (double)this.currentFlightTarget.field_71573_c + 0.5);
    }

    private void takeOff() {
        this.creature.setFlying(true);
        this.takingOff = true;
        this.flightTicks = 0;
        this.targetHeight = (int)this.creature.field_70163_u + (int)(Math.random() * (double)(this.creature.flyingParameters.flyHeightMax - this.creature.flyingParameters.flyHeightMin)) + this.creature.flyingParameters.flyHeightMin;
        this.creature.func_70107_b(this.creature.field_70165_t, this.creature.field_70163_u - 1.0, this.creature.field_70161_v);
        this.creature.field_70170_p.func_72889_a(null, 1015, (int)this.creature.field_70165_t, (int)this.creature.field_70163_u, (int)this.creature.field_70161_v, 0);
        this.takeOffSpeed = 0.22 + (double)(this.creature.flyingParameters.flySpeedModifier / 300.0f);
        this.creature.func_70091_d(this.creature.func_70681_au().nextDouble() - 0.5, this.takeOffSpeed, this.creature.func_70681_au().nextDouble() - 0.5);
    }
}

