/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.ai.animation;

import net.ilexiconn.jurassicraft.common.data.enums.JurassiCraftAnimationIDs;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftCreature;
import net.ilexiconn.jurassicraft.common.entity.ai.AIAnimation;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityGallimimus;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityTyrannosaurus;
import net.ilexiconn.jurassicraft.common.handler.AnimationHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;

public class AnimationAIBite
extends AIAnimation {
    private EntityJurassiCraftCreature entityBiting;
    private EntityLivingBase entityTarget;
    private int duration;
    private boolean eat;

    public AnimationAIBite(EntityJurassiCraftCreature dino, int duration) {
        super(dino);
        this.entityBiting = dino;
        this.entityTarget = null;
        this.duration = duration;
        this.eat = false;
    }

    @Override
    public int getAnimationId() {
        return JurassiCraftAnimationIDs.BITE.animID();
    }

    @Override
    public boolean isAutomatic() {
        return true;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.entityTarget = this.entityBiting.func_70638_az();
    }

    public void func_75246_d() {
        if (this.entityTarget != null) {
            if (this.entityBiting.getAnimationTick() < this.duration / 2 - 2) {
                this.entityBiting.func_70671_ap().func_75651_a((Entity)this.entityTarget, 30.0f, 30.0f);
            }
            if (this.entityBiting.getAnimationTick() == this.duration / 2 - 2) {
                float damage = (float)this.entityBiting.getCreatureAttack();
                if (this.entityTarget.func_110143_aJ() - damage <= 0.0f && this.entityBiting instanceof EntityTyrannosaurus && this.entityTarget instanceof EntityGallimimus) {
                    this.eat = true;
                } else {
                    this.eat = false;
                    this.entityTarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.entityBiting), damage);
                }
            }
        }
    }

    @Override
    public void func_75251_c() {
        if (this.eat && this.entityTarget instanceof EntityGallimimus && this.entityTarget.field_70154_o == null) {
            super.func_75251_c();
            this.entityTarget.func_70078_a((Entity)this.entityBiting);
            this.entityBiting.func_70624_b(null);
            this.entityBiting.func_70661_as().func_75499_g();
            this.entityBiting.setAnimationTick(0);
            AnimationHandler.sendAnimationPacket(this.entityBiting, JurassiCraftAnimationIDs.EATING.animID());
            EntityGallimimus gallimimus = (EntityGallimimus)this.entityTarget;
            gallimimus.func_70624_b(null);
            gallimimus.func_70661_as().func_75499_g();
            AnimationHandler.sendAnimationPacket(gallimimus, JurassiCraftAnimationIDs.BEING_EATEN.animID());
            this.entityTarget = null;
            return;
        }
        this.entityTarget = null;
        super.func_75251_c();
    }
}

