/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;

@SideOnly(value=Side.CLIENT)
public class RenderInfo {
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;
    public Block baseBlock = Blocks.field_150346_d;
    public IIcon texture = null;
    public IIcon[] textureArray = null;
    public boolean[] renderSide = new boolean[6];
    public float light = -1.0f;
    public int brightness = -1;

    public RenderInfo() {
        this.setRenderAllSides();
    }

    public RenderInfo(Block template, IIcon[] texture) {
        this();
        this.baseBlock = template;
        this.textureArray = texture;
    }

    public RenderInfo(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this();
        this.setBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public final void setBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public final void setRenderAllSides() {
        Arrays.fill(this.renderSide, true);
    }

    public IIcon getBlockTextureFromSide(int i) {
        if (this.texture != null) {
            return this.texture;
        }
        int index = i;
        if (this.textureArray == null || this.textureArray.length == 0) {
            return this.baseBlock.func_149733_h(index);
        }
        if (index >= this.textureArray.length) {
            index = 0;
        }
        return this.textureArray[index];
    }
}

