/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import shadersmod.common.SMCLog;
import shadersmod.transform.Names;

public class SMCCTTileEntityBeaconRenderer
implements IClassTransformer {
    private static final int vertexSize = 14;

    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVrenderBeacon
    extends MethodVisitor {
        int countStartQuad = 0;
        int countDraw = 0;
        int countJump = 0;

        public MVrenderBeacon(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitCode() {
            super.visitCode();
            Label label1 = new Label();
            this.mv.visitFieldInsn(178, "shadersmod/client/Shaders", "isShadowPass", "Z");
            this.mv.visitJumpInsn(153, label1);
            this.mv.visitInsn(177);
            this.mv.visitLabel(label1);
            this.mv.visitFrame(3, 0, null, 0, null);
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            switch (this.countJump++) {
                case 0: {
                    this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "beaconBeamBegin", "()V");
                }
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            if (Names.worldRenderer_startQuads.equals(owner, name, desc)) {
                switch (this.countStartQuad++) {
                    case 0: {
                        break;
                    }
                }
            } else if (Names.tessellator_draw.equals(owner, name, desc)) {
                switch (this.countDraw++) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "beaconBeamDraw2", "()V");
                    }
                }
            }
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (Names.tileEntityBeaconRenderer_renderBeacon.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVrenderBeacon(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

