/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import shadersmod.common.SMCLog;
import shadersmod.transform.Names;

public class SMCCTConnectedTextures
implements IClassTransformer {
    private static final int vertexSize = 14;

    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 0);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVfixVertex
    extends MethodVisitor {
        int count = 0;

        public MVfixVertex(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (opcode == 16 && operand == 7) {
                this.mv.visitIntInsn(opcode, 14);
                ++this.count;
                if (this.count > 1) {
                    SMCLog.warning("Unexpected number of 7.");
                }
                return;
            }
            this.mv.visitIntInsn(opcode, operand);
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (Names.ofConnectedTextures_fixVertex.equalsNameDesc(name, desc)) {
                return new MVfixVertex(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

