/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.transform;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import shadersmod.transform.Names;

public class AccessorGenerator {
    private static int getVarLoadOpcode(String desc) {
        switch (desc.charAt(0)) {
            case 'B': {
                return 21;
            }
            case 'C': {
                return 21;
            }
            case 'D': {
                return 24;
            }
            case 'F': {
                return 23;
            }
            case 'I': {
                return 21;
            }
            case 'J': {
                return 22;
            }
            case 'L': {
                return 25;
            }
            case 'S': {
                return 21;
            }
            case 'Z': {
                return 21;
            }
            case '[': {
                return 25;
            }
        }
        return 0;
    }

    private static int getReturnOpcode(String desc) {
        switch (desc.charAt(0)) {
            case 'B': {
                return 172;
            }
            case 'C': {
                return 172;
            }
            case 'D': {
                return 175;
            }
            case 'F': {
                return 174;
            }
            case 'I': {
                return 172;
            }
            case 'J': {
                return 173;
            }
            case 'L': {
                return 176;
            }
            case 'S': {
                return 172;
            }
            case 'Z': {
                return 172;
            }
            case '[': {
                return 176;
            }
        }
        return 177;
    }

    public static void generateFieldAccessor(ClassVisitor cv, String accessorName, Names.Fiel fiel) {
        MethodVisitor mv = cv.visitMethod(9, "put_" + accessorName, "(L" + fiel.clasName + ";" + fiel.desc + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(AccessorGenerator.getVarLoadOpcode(fiel.desc), 1);
        mv.visitFieldInsn(181, fiel.clasName, fiel.name, fiel.desc);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cv.visitMethod(9, "get_" + accessorName, "(L" + fiel.clasName + ";)" + fiel.desc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, fiel.clasName, fiel.name, fiel.desc);
        mv.visitInsn(AccessorGenerator.getReturnOpcode(fiel.desc));
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public static void generatePrivateMethodAccessor(ClassVisitor cv, String accessorName, Names.Meth meth) {
        String methDesc = meth.desc;
        int indexCloseParenthesis = methDesc.indexOf(41);
        String returnType = methDesc.substring(indexCloseParenthesis + 1);
        String allParams = methDesc.substring(1, indexCloseParenthesis);
        MethodVisitor mv = cv.visitMethod(9, "invoke_" + accessorName, "(L" + meth.clasName + ";" + allParams + ")" + returnType, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        int paramCount = 1;
        int i = 1;
        while (methDesc.charAt(i) != ')') {
            int startIndex = i;
            while (methDesc.charAt(i) == '[') {
                ++i;
            }
            if (methDesc.charAt(i) == 'L') {
                ++i;
                while (methDesc.charAt(i) != ';') {
                    ++i;
                }
            }
            String desc = methDesc.substring(startIndex, ++i);
            mv.visitVarInsn(AccessorGenerator.getVarLoadOpcode(desc), paramCount);
            char c = desc.charAt(0);
            paramCount += c == 'D' || c == 'J' ? 2 : 1;
        }
        mv.visitMethodInsn(183, meth.clasName, meth.name, meth.desc);
        mv.visitInsn(AccessorGenerator.getReturnOpcode(returnType));
        mv.visitMaxs(paramCount, paramCount);
        mv.visitEnd();
    }
}

