/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.installer;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import shadersmod.installer.Json;
import shadersmod.installer.JsonParser;

public class Installer {
    MessageDigest mdSha;
    StringBuilder logMessage = new StringBuilder();
    static final String mcVer = "1.8";
    static final String modVer = "2.4.11";
    static final String friendlyModName = "ShadersMod";
    static final String libraryModDir = "shadersmodcore";
    static final String libraryModName = "ShadersModCore";
    static final String libraryModVer = "2.4.11mc1.8";
    static final String libraryModDesc = "shadersmodcore:ShadersModCore:2.4.11mc1.8";
    static final String versionIn = "1.8";
    static final String versionMod = "1.8-ShadersMod2.4.11";
    static final String profileMod = "1.8-ShadersMod";

    public static void main(String[] args) {
        Installer inst = new Installer();
        inst.run();
    }

    public void run() {
        Object baseVer;
        try {
            this.mdSha = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("No SHA algorithm");
            this.mdSha = null;
        }
        File mcDir = this.getMcDir();
        Object[] vers = new File(mcDir, "versions").list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name.equals("1.8") || name.startsWith("1.8-OptiFine_HD_U_") && name.indexOf(Installer.friendlyModName) == -1) && new File(dir, name).isDirectory();
            }
        });
        String message = String.format("Minecraft directory %s\n\nSelect base version.", mcDir.getAbsolutePath());
        String title = "ShadersMod 2.4.11 Installer for Minecraft 1.8";
        int option = JOptionPane.showConfirmDialog(null, "Make sure you have closed Minecraft and Minecraft Launcher", title, 2, -1);
        if (option == 0 && (baseVer = JOptionPane.showInputDialog(null, message, title, -1, null, vers, "1.8")) instanceof String) {
            this.startInstall(mcDir, (String)baseVer);
        }
    }

    public File getMcDir() {
        String osName = System.getProperty("os.name").toLowerCase();
        String userHome = System.getProperty("user.home", ".");
        if (osName.contains("win")) {
            String baseDir = System.getenv("APPDATA");
            if (baseDir == null) {
                baseDir = userHome;
            }
            return new File(baseDir, ".minecraft/");
        }
        if (osName.contains("mac")) {
            return new File(userHome, "Library/Application Support/minecraft");
        }
        if (osName.contains("linux") || osName.contains("unix")) {
            return new File(userHome, ".minecraft/");
        }
        return new File(userHome, "minecraft/");
    }

    public void startInstall(File mcDir, String baseVer) {
        String versionMod;
        boolean result = false;
        if (this.installLibraries(mcDir) && this.installVersion(mcDir, baseVer, versionMod = baseVer + "-ShadersMod" + modVer) && this.installProfile(mcDir, profileMod, versionMod)) {
            result = true;
        }
        this.logMessage.append(result ? "complete" : "fail");
        JOptionPane.showMessageDialog(null, this.logMessage, "Result", -1);
    }

    public void startInstall(File mcDir) {
        boolean result = false;
        if (this.installLibraries(mcDir) && this.installVersion(mcDir, "1.8", versionMod) && this.installProfile(mcDir, profileMod, versionMod)) {
            result = true;
        }
        this.logMessage.append(result ? "complete" : "fail");
        JOptionPane.showMessageDialog(null, this.logMessage, "Result", -1);
    }

    void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    int readLoop(InputStream inp, byte[] buffer, int size) throws IOException {
        int pos;
        int n;
        for (pos = 0; pos < size && (n = inp.read(buffer, pos, size - pos)) > 0; pos += n) {
        }
        return pos;
    }

    byte[] readToByteArray(InputStream inp) throws IOException {
        int i;
        int bufSize = 0x100000;
        ArrayList<byte[]> buffers = new ArrayList<byte[]>();
        int bufIndex = 0;
        int pos = 0;
        int nread = 0;
        do {
            byte[] buf = new byte[0x100000];
            buffers.add(buf);
            pos = 0;
            do {
                nread = 0;
            } while ((nread = inp.read(buf, pos, 0x100000 - pos)) > 0 && (pos += nread) < 0x100000);
            if (nread <= 0) break;
            ++bufIndex;
        } while (nread > 0);
        byte[] abyte = new byte[bufIndex * 0x100000 + pos];
        for (i = 0; i < bufIndex; ++i) {
            System.arraycopy(buffers.get(i), 0, abyte, i * 0x100000, 0x100000);
        }
        System.arraycopy(buffers.get(i), 0, abyte, i * 0x100000, pos);
        return abyte;
    }

    byte[] getResourceByteArray(String name) {
        return this.readByteArray(this.getClass().getResourceAsStream(name));
    }

    byte[] readByteArray(InputStream inp) {
        byte[] abyte = null;
        if (inp != null) {
            int i;
            int bufSize = 0x100000;
            ArrayList<byte[]> buffers = new ArrayList<byte[]>();
            int bufIndex = 0;
            int pos = 0;
            int nread = 0;
            try {
                do {
                    bufIndex = buffers.size();
                    byte[] buf = new byte[0x100000];
                    buffers.add(buf);
                    pos = 0;
                    do {
                        nread = 0;
                    } while ((nread = inp.read(buf, pos, 0x100000 - pos)) > 0 && (pos += nread) < 0x100000);
                } while (nread > 0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.close(inp);
            abyte = new byte[bufIndex * 0x100000 + pos];
            for (i = 0; i < bufIndex; ++i) {
                System.arraycopy(buffers.get(i), 0, abyte, i * 0x100000, 0x100000);
            }
            System.arraycopy(buffers.get(i), 0, abyte, i * 0x100000, pos);
        }
        return abyte;
    }

    public boolean writeFileWithSha(File dst, byte[] abyte) {
        boolean result = false;
        FileOutputStream out = null;
        FileWriter wr = null;
        try {
            out = new FileOutputStream(dst);
            ((OutputStream)out).write(abyte);
            ((OutputStream)out).close();
            out = null;
            result = true;
            wr = new FileWriter(dst.getPath() + ".sha");
            wr.write(this.toShaString(abyte));
            ((Writer)wr).close();
            wr = null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.close(out);
        this.close(wr);
        return result;
    }

    public boolean writeFile(File dst, byte[] abyte) {
        boolean result = false;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dst);
            ((OutputStream)out).write(abyte);
            ((OutputStream)out).close();
            out = null;
            result = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.close(out);
        return result;
    }

    public void copyFile(File src, File dst) {
        FileInputStream inp = null;
        FileOutputStream out = null;
        byte[] abyte = null;
        try {
            int size = (int)src.length();
            abyte = new byte[size];
            inp = new FileInputStream(src);
            this.readLoop(inp, abyte, size);
            ((InputStream)inp).close();
            inp = null;
            out = new FileOutputStream(dst);
            ((OutputStream)out).write(abyte);
            ((OutputStream)out).close();
            out = null;
            dst.setLastModified(src.lastModified());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.close(inp);
        this.close(out);
    }

    public boolean copyFileWithSha(File src, File dst) {
        boolean result = false;
        FileInputStream inp = null;
        FileOutputStream out = null;
        FileWriter wr = null;
        byte[] abyte = null;
        try {
            int size = (int)src.length();
            abyte = new byte[size];
            inp = new FileInputStream(src);
            this.readLoop(inp, abyte, size);
            ((InputStream)inp).close();
            inp = null;
            out = new FileOutputStream(dst);
            ((OutputStream)out).write(abyte);
            ((OutputStream)out).close();
            out = null;
            dst.setLastModified(src.lastModified());
            result = true;
            wr = new FileWriter(dst.getPath() + ".sha");
            wr.write(this.toShaString(abyte));
            ((Writer)wr).close();
            wr = null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.close(inp);
        this.close(out);
        this.close(wr);
        return result;
    }

    public String toShaString(byte[] abyte) {
        this.mdSha.reset();
        byte[] sha = this.mdSha.digest(abyte);
        StringBuilder sb = new StringBuilder();
        for (byte b : sha) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private InputStream getJarAsStream() {
        String classUrlStr;
        int endIndex;
        URL classUrl = this.getClass().getClassLoader().getResource(this.getClass().getName().replace('.', '/') + ".class");
        if (classUrl != null && (endIndex = (classUrlStr = classUrl.toString()).indexOf("!/")) != -1 && classUrlStr.startsWith("jar:")) {
            try {
                URL jarUrl = new URL(classUrlStr.substring(4, endIndex));
                InputStream inputStream = jarUrl.openStream();
                return inputStream;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean installSelfLibrary(File mcDir, String subDir, String name, String version) {
        boolean result = false;
        File outDir = new File(mcDir, "libraries/" + subDir + "/" + name + "/" + version);
        File outJar = new File(outDir, name + "-" + version + ".jar");
        outDir.mkdirs();
        byte[] abyte = null;
        InputStream inputStream = this.getJarAsStream();
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream("/" + name + "-" + version + ".jar");
        }
        if (inputStream != null) {
            // empty if block
        }
        if ((abyte = this.readByteArray(inputStream)) != null && this.writeFileWithSha(outJar, abyte)) {
            result = true;
        }
        return result;
    }

    public boolean installLibrary(File mcDir, String subDir, String name, String version) {
        boolean result = false;
        File outDir = new File(mcDir, "libraries/" + subDir + "/" + name + "/" + version);
        File outJar = new File(outDir, name + "-" + version + ".jar");
        outDir.mkdirs();
        byte[] abyte = this.readByteArray(this.getClass().getResourceAsStream("/" + name + "-" + version + ".jar"));
        if (abyte != null && this.writeFileWithSha(outJar, abyte)) {
            result = true;
        }
        return result;
    }

    public boolean installLibraries(File mcDir) {
        return this.installSelfLibrary(mcDir, libraryModDir, libraryModName, libraryModVer);
    }

    public void showTextResource(String resName, String title) {
        InputStream in = this.getClass().getResourceAsStream(resName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder text = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                text.append(line).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JOptionPane.showMessageDialog(null, text, title, -1);
    }

    Json.JsObject libraryAsJso(String library) {
        Json.JsObject jso = new Json.JsObject();
        jso.put("name", new Json.JsString(library));
        return jso;
    }

    public boolean writeVersionJson(File inpJson, File outJson, String outVersion) {
        boolean result = false;
        BufferedReader inr = null;
        try {
            inr = new BufferedReader(new FileReader(inpJson));
            JsonParser jp = new JsonParser(inr);
            Json.JsObject jso = jp.getObject();
            inr.close();
            inr = null;
            jso.put("id", new Json.JsString(outVersion));
            jso.put("mainClass", new Json.JsString("net.minecraft.launchwrapper.Launch"));
            Json.JsString jssArg = (Json.JsString)jso.get("minecraftArguments");
            jssArg.str = jssArg.str + " --tweakClass shadersmod.launch.SMCTweaker";
            Json.JsArray jsaLibs = (Json.JsArray)jso.get("libraries");
            ArrayList<Json.JsValue> ao1 = jsaLibs.elements;
            ArrayList<Json.JsObject> ao2 = new ArrayList<Json.JsObject>();
            jsaLibs.elements = ao2;
            ao2.add(this.libraryAsJso(libraryModDesc));
            ao2.add(this.libraryAsJso("net.minecraft:launchwrapper:1.11"));
            ao2.add(this.libraryAsJso("org.ow2.asm:asm-all:5.0.3"));
            int max = ao1.size();
            for (int i = 0; i < max; ++i) {
                Json.JsObject jsoLib = (Json.JsObject)ao1.get(i);
                Json.JsString jssLibName = (Json.JsString)jsoLib.get("name");
                String libName = jssLibName.str;
                if (libName == null || libName.startsWith("shadersmodcore:ShadersModCore:") || libName.startsWith("net.minecraft:launchwrapper:") || libName.startsWith("org.ow2.asm:asm-all:")) continue;
                ao2.add(jsoLib);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            jso.print(pw, 0);
            pw.close();
            pw = null;
            byte[] abyte = baos.toByteArray();
            if (this.writeFileWithSha(outJson, abyte)) {
                // empty if block
            }
            result = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.close(inr);
        return result;
    }

    public boolean installVersion(File mcDir, String inpVersion, String outVersion) {
        File inpDir = new File(mcDir, "versions/" + inpVersion + "/");
        File inpJar = new File(inpDir, inpVersion + ".jar");
        File inpJson = new File(inpDir, inpVersion + ".json");
        File outDir = new File(mcDir, "versions/" + outVersion + "/");
        File outJar = new File(outDir, outVersion + ".jar");
        File outJson = new File(outDir, outVersion + ".json");
        if (inpJar.exists() && inpJson.exists()) {
            outDir.mkdirs();
            if (this.copyFileWithSha(inpJar, outJar) && this.writeVersionJson(inpJson, outJson, outVersion)) {
                String str = String.format("Version %s => %s\n", inpVersion, outVersion);
                this.logMessage.append(str);
                return true;
            }
            return false;
        }
        String str = String.format("Cannot find version %s .. skip\n", inpVersion);
        this.logMessage.append(str);
        return false;
    }

    public boolean installProfile(File mcDir, String profile, String version) {
        File inpJson;
        boolean result = false;
        File outJson = inpJson = new File(mcDir, "launcher_profiles.json");
        if (inpJson.exists()) {
            BufferedReader inr = null;
            try {
                inr = new BufferedReader(new FileReader(inpJson));
                JsonParser jp = new JsonParser(inr);
                Json.JsObject jsoRoot = jp.getObject();
                inr.close();
                inr = null;
                Json.JsObject jsoProfiles = (Json.JsObject)jsoRoot.get("profiles");
                Json.JsObject jsoModProfile = (Json.JsObject)jsoProfiles.get(profile);
                if (jsoModProfile == null) {
                    jsoModProfile = new Json.JsObject();
                    jsoModProfile.put("name", new Json.JsString(profile));
                    jsoModProfile.put("lastVersionId", new Json.JsString(version));
                    jsoModProfile.put("useHopperCrashService", new Json.JsBoolean("false"));
                    jsoModProfile.put("launcherVisibilityOnGameClose", new Json.JsString("keep the launcher open"));
                    jsoProfiles.put(profile, jsoModProfile);
                } else {
                    jsoModProfile.put("name", new Json.JsString(profile));
                    jsoModProfile.put("lastVersionId", new Json.JsString(version));
                }
                jsoRoot.put("selectedProfile", new Json.JsString(profile));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(baos);
                jsoRoot.print(pw, 0);
                pw.close();
                pw = null;
                byte[] abyte = baos.toByteArray();
                if (this.writeFile(outJson, abyte)) {
                    // empty if block
                }
                result = true;
                this.logMessage.append(String.format("Add profile %s for version %s\n", profile, version));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.close(inr);
        }
        return result;
    }
}

