#define Clouds

#ifdef Clouds
vec3 drawCloud(vec3 fposition,vec3 color, vec3 light) {
float totalcloud = 0;
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float cosS = dot(sunVec,sVector);
float pi = 3.1415927;
vec2 wind = vec2(frametime,0.0)/15000;

vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wVector = normalize(tpos);

vec3 cloud_color = light;

if (cosT > 0.0){
	for (int i = 0; i < 4; i++) {
		vec3 intersection = wVector*((48-i+dither4x4(texcoord.xy))/wVector.y);
		vec2 coord = (intersection.xz + cameraPosition.xz*0.5)*0.00002;
		
		float noise = texture2D(noisetex,coord*pow(2,pow(5.0,1.0/64.0))+wind*pow(2.0,0.0)).x*8;
			  noise+= texture2D(noisetex,coord*pow(2,pow(5.0,4.0/64.0))+wind*pow(2.0,0.25)).x*7;
			  noise+= texture2D(noisetex,coord*pow(2,pow(5.0,9.0/64.0))+wind*pow(2.0,0.5)).x*6;
			  noise+= texture2D(noisetex,coord*pow(2,pow(5.0,16.0/64.0))+wind*pow(2.0,0.75)).x*5;
			  noise+= texture2D(noisetex,coord*pow(2,pow(5.0,25.0/64.0))+wind*pow(2.0,1.0)).x*4;
			  noise+= texture2D(noisetex,coord*pow(2,pow(5.0,36.0/64.0))+wind*pow(2.0,1.25)).x*3;
			  noise+= texture2D(noisetex,coord*pow(2,pow(5.0,49.0/64.0))+wind*pow(2.0,1.5)).x*2;
			  noise+= texture2D(noisetex,coord*pow(2,pow(5.0,64.0/64.0))+wind*pow(2.0,1.75)).x;
			  noise = (pow(noise/36.0,0.225) - (1.0-(1.05-0.1*sin(i/4*pi))/7.0)*pow(1-wetness*0.7,0.5))*(mix(6.0,2.0,wetness));

		float cloud2 = max(noise,0.0)*0.1;
		totalcloud = mix(totalcloud,1-i/(5),cloud2);
		cloud_color = mix(cloud_color,vec3(0),(cloud2*10)*pow(float(i/4),2.2));
	}
	totalcloud /= 4;
	totalcloud = pow(totalcloud*10.0,2.0)*0.4;
	totalcloud*= pow(clamp(cosT,0.0,1.0/(2.0-wetness))*(2.0-1.5*pow(wetness,0.5)),2.0-wetness*0.7);

	float rainl = pow(abs(cosS),8.0)*2.0*wetness;
	cloud_color = mix(cloud_color,cloud_color*2.0,rainl)*(2.0+2.0*sunVisibility);
}

vec3 c = mix(color,cloud_color,totalcloud*0.7);

return c;
}
#else
vec3 drawCloud(vec3 fposition,vec3 color, vec3 light) {
return color;
}
#endif