//#define AOHQ
//#define AOTranslucent

float dbao(sampler2D depth, float dither){
	float ao = 0.0;
	
	#ifdef AOHQ
	const int aoloop = 4;
	const int aoside = 6;
	float size = 0.1;
	#else
	const int aoloop = 3;
	const int aoside = 4;
	float size = 0.17;
	#endif
	float d = ld(texture2D(depth,texcoord.xy).r);
	const float piangle = 22.0/(7.0*180.0);
	float rot = 90.0+360.0/aoside*(dither+0.5);
	float scale = size*dither;
	float sd = 0.0;
	float angle = 0.0;
	float dist = 0.0;
	float w = 0.0;
	
	#ifdef AOHQ
	float distscale = max(2.0*far*d,1.0);
	#else
	float distscale = 16.0;
	#endif
	
	for (int i = 0; i < aoloop; i++) {
		for (int j = 0; j < aoside; j++) {
			sd = ld(texture2D(depth,texcoord.xy+vec2(cos(rot*piangle),sin(rot*piangle))*scale/distscale*vec2(1.0/aspectRatio,1.0)).r);
			angle += clamp(1.0-2.0/size*far*(d-sd),0.0,2.0);
			dist += clamp(0.25/size*far*(d-sd),0.0,1.0);
			rot += 360.0/aoside;
		}
		rot += 180.0/aoside;
		scale = (size+2.0*size*dither);
		size *= 3.0;
		ao += clamp((angle+dist)/aoside,0.0,1.0);
		angle = 0.0;
		dist = 0.0;
		w += (1.0);
	}
	
	ao /= w;
	
	return ao*ao;
}