#version 120
#extension GL_ARB_shader_texture_lod : enable

#define Desaturation
//#define DisableTexture
#define ExtraReflection

#define WaterNormals
//#define WaterDistantWave
#define WaterParallax

//#define RPSupport
#define RPSFormat 0 //[0 1 2]
//#define WorldTimeAnimation

#define MAX_COLOR_RANGE 32.0

#define NORMAL_MAP_MAX_ANGLE 1.0
#define POM_MAP_RES 128.0 //[16.0 32.0 64.0 128.0 256.0 512.0 1024.0 2048.0]
#define POM_DEPTH 0.2 //[0.1 0.2 0.3 0.4 0.5]

const vec3 intervalMult = vec3(1.0, 1.0, 1.0/POM_DEPTH)/POM_MAP_RES * 1.0; 

const float MAX_OCCLUSION_DISTANCE = 96.0;
const float MIX_OCCLUSION_DISTANCE = 64.0;
const int   MAX_OCCLUSION_POINTS   = int(POM_MAP_RES);

const float bump_distance = 64.0;				//Bump render distance: tiny = 32, short = 64, normal = 128, far = 256
const float pom_distance = 32.0;				//POM render distance: tiny = 32, short = 64, normal = 128, far = 256
const float fademult = 0.1;

const float PI = 3.1415927;

varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord;

varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;
varying vec3 wpos;
varying vec3 viewVector;
varying float dist;

varying float mat;

uniform sampler2D texture;
uniform sampler2D noisetex;
uniform vec3 cameraPosition;
uniform int worldTime;
uniform int isEyeInWater;
uniform float far;
uniform float rainStrength;
uniform float frameTimeCounter;

uniform float nightVision;
uniform float viewWidth;
uniform float viewHeight;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelView;

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0;
#else
float frametime = frameTimeCounter;
#endif

#ifdef RPSupport
uniform sampler2D specular;
uniform sampler2D normals;
varying vec4 vtexcoordam; // .st for add, .pq for mul
varying vec4 vtexcoord;

vec2 dcdx = dFdx(vtexcoord.st*vtexcoordam.pq);
vec2 dcdy = dFdy(vtexcoord.st*vtexcoordam.pq);

vec4 readTexture(in vec2 coord)
{
	return texture2DGradARB(texture,fract(coord)*vtexcoordam.pq+vtexcoordam.st,dcdx,dcdy);
}

vec4 readNormal(in vec2 coord)
{
	return texture2DGradARB(normals,fract(coord)*vtexcoordam.pq+vtexcoordam.st,dcdx,dcdy);
}

const float mincoord = 1.0/4096.0;
const float maxcoord = 1.0-mincoord;
#endif

vec2 dx = dFdx(texcoord.xy);
vec2 dy = dFdy(texcoord.xy);

float wave(float n) {
return sin(2 * PI * (n));
}

float waterH(vec3 pos, vec3 fpos) {
float noise = 0;

#ifdef WaterNormals
noise+= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5-pos.y*0.2)/1024.0* 1.1).r*1.0;
noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.2)/1024.0* 1.5).r*0.8;
noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.2)/1024.0* 2.5).r*0.6;
noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.2)/1024.0* 5.0).r*0.4;
noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.2)/1024.0* 8.0).r*0.2;

#ifdef WaterDistantWave
float noiseb = 0;
noiseb+= texture2D(noisetex,(pos.xz+vec2(frametime)-pos.y*0.1)/1024.0* 0.22).r*4.0;
noiseb+= texture2D(noisetex,(pos.xz-vec2(frametime)-pos.y*0.1)/1024.0* 0.3).r*3.2;
noiseb-= texture2D(noisetex,(pos.xz+vec2(frametime)+pos.y*0.1)/1024.0* 0.5).r*2.4;
noiseb+= texture2D(noisetex,(pos.xz-vec2(frametime)-pos.y*0.1)/1024.0* 1.0).r*1.6;
noiseb-= texture2D(noisetex,(pos.xz+vec2(frametime)+pos.y*0.1)/1024.0* 2.0).r*0.8;
noise = mix(noise,noiseb,clamp(dist/64.0-0.125,0.0,1.0));
#endif

noise /= pow(max(dist,4.0),0.25);
noise *= clamp((-dot(normalize(normal),normalize(fpos)))*4.0,0.0,1.0);
#endif

return noise;
}

vec3 getParallaxWaves(vec3 posxz, vec3 viewVector,vec3 fragpos) {
	vec3 parallaxPos = posxz;
	float waveH = (waterH(posxz,fragpos.xyz)-0.5)*0.2;
	
	for(int i = 0; i < 4; i++){
		parallaxPos.xz += waveH*(viewVector.xy)/dist;
		waveH = (waterH(parallaxPos,fragpos.xyz)-0.5)*0.2;
	}
	return parallaxPos;
}

#include "lib/torchColor.glsl"
#include "lib/waterColor.glsl"
#include "lib/dimensionColor.glsl"

void main() {	
	vec2 adjustedTexCoord = texcoord.xy;
	#ifdef WaterV
	vec4 tex = texture2D(texture, texcoord.xy)*color;
	#else
	vec4 tex = vec4(length(texture2D(texture, texcoord.xy).rgb)*water_c,water_a);
	#endif
	
	if (mat > 0.12){
		tex = texture2D(texture, texcoord.xy)*color;
		
		#ifdef RPSupport
		vec2 adjustedTexCoord = vtexcoord.st*vtexcoordam.pq+vtexcoordam.st;
		if (dist < MAX_OCCLUSION_DISTANCE) {
				if ( viewVector.z < 0.0 && readNormal(vtexcoord.st).a < 0.99 && readNormal(vtexcoord.st).a > 0.01){
					vec3 interval = viewVector.xyz * intervalMult / dist;
					vec3 coord = vec3(vtexcoord.st, 1.0);
						for (int loopCount = 0; (loopCount < MAX_OCCLUSION_POINTS) && (readNormal(coord.st).a < coord.p); ++loopCount) {
							coord = coord+interval;
						}
					if (coord.t < mincoord) {
						if (readTexture(vec2(coord.s,mincoord)).a == 0.0) {
							coord.t = mincoord;
							discard;
						}
					}
				adjustedTexCoord = mix(fract(coord.st)*vtexcoordam.pq+vtexcoordam.st , adjustedTexCoord , clamp((dist-MIX_OCCLUSION_DISTANCE)/(MAX_OCCLUSION_DISTANCE-MIX_OCCLUSION_DISTANCE),0.0,1.0));
			}
		}
		tex = texture2DGradARB(texture, adjustedTexCoord, dcdx, dcdy)*color;
		tex.rgb *= texture2DGradARB(normals, adjustedTexCoord, dcdx, dcdy).a;
		#endif
	}
	
	tex.a = pow(tex.a,1.0/2.2);
		
	vec4 spec = vec4(0.0);
	
	vec4 fragpos = gbufferProjectionInverse*(vec4(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z,1.0)*2.0-1.0);
	fragpos /= fragpos.w;
	
	vec3 posxz = wpos.xyz;
	#ifdef WaterParallax
	posxz = getParallaxWaves(posxz,viewVector,fragpos.xyz);
	#endif
	
	float deltaPos = 0.1*(1.0+0.015*dist);
	float h0 = waterH(posxz,fragpos.xyz);
	float h1 = waterH(posxz + vec3(deltaPos,0.0,0.0),fragpos.xyz);
	float h2 = waterH(posxz + vec3(-deltaPos,0.0,0.0),fragpos.xyz);
	float h3 = waterH(posxz + vec3(0.0,0.0,deltaPos),fragpos.xyz);
	float h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos),fragpos.xyz);
	
	float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	float yDelta = ((h3-h0)+(h0-h4))/deltaPos;
	
	vec3 newnormal = vec3(xDelta,yDelta,1.0-xDelta*xDelta-yDelta*yDelta);
	
	vec4 frag2;
		frag2 = vec4((normal) * 0.5f + 0.5f, 1.0f);		
		
	if (mat > 0.08 && mat < 0.12) {
		vec3 bump = newnormal;
		
		float bumpmult = 0.03;	
		
		bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
							tangent.y, binormal.y, normal.y,
							tangent.z, binormal.z, normal.z);
		
		frag2 = vec4(normalize(bump * tbnMatrix) * 0.5 + 0.5, 1.0);
	}
	
	if (mat > 0.12){
		#ifdef RPSupport
		vec3 bump = texture2DGradARB(normals, adjustedTexCoord, dcdx, dcdy).rgb*2.0-1.0;
		float bumpmult = NORMAL_MAP_MAX_ANGLE*(1.0-rainStrength*lmcoord.t*0.9);
		bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
		mat3 tbnMatrix = mat3(  tangent.x, binormal.x, normal.x,
								tangent.y, binormal.y, normal.y,
								tangent.z, binormal.z, normal.z);

		frag2 = vec4(normalize(bump * tbnMatrix) * 0.5 + 0.5, 1.0);
		spec = texture2DGradARB(specular, adjustedTexCoord, dcdx, dcdy);
		#endif
	}
	
	float NdotU = pow(dot(frag2.xyz*2.0-1.0,normalize(gbufferModelView[1].xyz))*0.25+0.75,2.2);
	float specemissive = 0.0;
	
	float torchmap = pow(lmcoord.s,2.2)*0.2 + pow(max(lmcoord.s-0.1,0.0)*1.11,16.0)*4.0;
	vec3 torchlight = pow(torch_c,vec3(1.2-0.2*sqrt(sqrt(lmcoord.s))))*torchmap*8.0*mix(1.0,sqrt(1.0/length(tex.rgb)),float(mat < 0.12));
	
	#ifdef RPSupport
	#if RPSFormat == 2
	specemissive = spec.b;
	torchlight += pow(tex.rgb,vec3(2.2))*8.0*specemissive;
	#endif
	#endif
	
	vec3 scenelight = vec3(0.05);
	vec3 finallight = (scenelight+torchlight+nightVision)*NdotU;
	
	tex.rgb = pow(tex.rgb,vec3(2.2));
	
	#ifdef DisableTexture
		tex.rgb = vec3(1.0,1.0,1.0)*mix(0.4,0.01,float(mat < 0.12));
	#endif
	
	tex.rgb = tex.rgb/sqrt(1.0+tex.rgb*tex.rgb);
	tex.rgb *= finallight;
	
	#ifdef Desaturation
	float ddesat = clamp(lmcoord.s+sqrt(sqrt(specemissive)),0.5,1.0);
	tex.rgb = mix(dot(tex.rgb,vec3(0.299, 0.587, 0.114))*end_c,tex.rgb,ddesat);
	#endif
	
	tex.rgb = pow(tex.rgb/MAX_COLOR_RANGE,vec3(1.0/2.2));
	
	float solid = float(tex.a > 0.999);
	
/* DRAWBUFFERS:13456 */
	
	gl_FragData[0] = vec4(tex.rgb,tex.a);
	gl_FragData[1] = frag2;	
	gl_FragData[2] = vec4(0.0, 0.6, 0.0, solid);
	gl_FragData[3] = vec4(lmcoord.t, mat+solid, lmcoord.s, 1.0);
	gl_FragData[4] = spec;
}