#version 120

#define AO
#define Desaturation
//#define DisableTexture
#define EmissiveRecolor
#define Fog
//#define RPSupport
#define RPSFormat 0 //[0 1 2]
#define WaterFog
#define WaterRefraction
//#define WorldTimeAnimation

#define MAX_COLOR_RANGE 32.0
const bool colortex0MipmapEnabled = true;

varying vec3 lightVector;
varying vec3 upVec;
varying vec3 sunVec;
varying vec3 moonVec;
varying float sunVisibility;
varying float moonVisibility;
varying float handRecolor;

varying vec4 texcoord;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
#ifdef RPSupport
uniform sampler2D colortex6;
#endif
uniform sampler2D colortex7;
uniform sampler2D depthtex0;
uniform sampler2D noisetex;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform float rainStrength;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;
uniform vec3 sunPosition;
uniform float viewWidth;
uniform float viewHeight;
uniform float far;
uniform float near;
uniform float aspectRatio;
uniform float nightVision;

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0;
#else
float frametime = frameTimeCounter;
#endif

float nolight = 1.0-(clamp((time-12000.0)/500.0,0.0,1.0)-clamp((time-13500.0)/500.0,0.0,1.0) + clamp((time-22500.0)/500.0,0.0,1.0)-clamp((time-23500.0)/500.0,0.0,1.0));

vec3 calcLightColor(vec3 morning, vec3 day, vec3 night, vec3 rain){
	vec3 c = mix(night,mix(morning,day,pow(tB,0.75)),sunVisibility);
	return mix(c,pow(length(c),0.2)*rain,rainStrength);
}

float waterH(vec3 pos) {
	float noise = 0;
	noise+= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5-pos.y*0.2)/1024.0* 1.1).r*1.0;
	noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.2)/1024.0* 1.5).r*0.8;
	noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.2)/1024.0* 2.5).r*0.6;
	noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.2)/1024.0* 5.0).r*0.4;
	noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.2)/1024.0* 8.0).r*0.2;

	noise /= pow(max(length(pos),4.0),0.4);
	return noise;
}

vec2 getRefract(vec2 coord, vec3 posxz){
	float deltaPos = 0.1;
	float h0 = waterH(posxz);
	float h1 = waterH(posxz + vec3(deltaPos,0.0,0.0));
	float h2 = waterH(posxz + vec3(-deltaPos,0.0,0.0));
	float h3 = waterH(posxz + vec3(0.0,0.0,deltaPos));
	float h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos));

	float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	float yDelta = ((h3-h0)+(h0-h4))/deltaPos;

	vec2 newcoord = vec2(xDelta,yDelta)*0.01 + coord;
	float water = texture2D(colortex5, newcoord).g;
	water = float(water > 0.08 && water < 0.12);
	float limit = max(1.0-water,float(newcoord.x < 0.0 || newcoord.x > 1.0 || newcoord.y < 0.0 || newcoord.y > 1.0));

	return mix(newcoord,coord,limit);
}

float ld(float depth) {
   return (2.0 * near) / (far + near - depth * (far - near));
}

float dither4x4(vec2 pos)
{
	const int ditherPattern[16] = int[16](
		0, 8, 2, 10,
		12, 4, 14, 6,
		3, 11, 1, 9,
		15, 7, 13, 5);

    vec2 position = floor(mod(vec2(texcoord.s * viewWidth,texcoord.t * viewHeight), 4.0f));

	int dither = ditherPattern[int(position.x) + int(position.y) * 4];

	return float(dither) / 16.0f;
}

#include "lib/fragPos.glsl"
#include "lib/lightColors.glsl"
#include "lib/torchColor.glsl"
#include "lib/waterColor.glsl"
#include "lib/dimensionColor.glsl"
#include "lib/fogCalc.glsl"
#include "lib/ambientOcclusion.glsl"

void main() {
	
	
	vec3 color = pow(texture2D(colortex0, texcoord.st).rgb,vec3(2.2))*MAX_COLOR_RANGE;
	vec3 aux = texture2D(colortex5, texcoord.st).rgb;
	float ao = 1.0;
	float spec = texture2D(colortex0, texcoord.st).a;
	float specemissive = 0.0;
	vec3 gr = vec3(0.0);
	
	float dither = dither4x4(texcoord.xy);
	
	float skymap = pow(aux.r,2.2);
	float matflag = aux.g;
	float torchmap = pow(aux.b,2.2)*0.2 + pow(max(aux.b-0.1,0.0)*1.11,16.0)*4.0;
	float alpha = pow(texture2D(colortex1,texcoord.xy).a,2.2);
	
	float translucent = float(matflag > 0.05);
	float water = float(matflag > 0.08 && matflag < 0.12);
	float hand = float(matflag > 0.38 && matflag < 0.42);	
	
	float pixeldepth = texture2D(depthtex0,texcoord.xy).x;
	
	vec4 fragpos = getFragPos(texcoord.xy,pixeldepth);
	
	if (translucent > 0.9 && alpha > 0.0001) {
		vec3 colorb = pow(max(texture2D(colortex1, texcoord.st).rgb,vec3(1.0/255.0)),vec3(2.2))*MAX_COLOR_RANGE;
		vec3 normal = texture2D(colortex3, texcoord.st).rgb*2.0-1.0;
		
		vec4 worldpos = getWorldPos(fragpos);
		
		#ifdef WaterRefraction
		if (water > 0.9 && isEyeInWater < 0.9){
			vec2 newcoord = getRefract(texcoord.xy,worldpos.xyz+cameraPosition.xyz);
			color = pow(texture2D(colortex0, newcoord).rgb,vec3(2.2))*MAX_COLOR_RANGE;
			colorb = pow(max(texture2D(colortex1, newcoord.st).rgb,vec3(1.0/255.0)),vec3(2.2))*MAX_COLOR_RANGE;
		}
		#endif
		
		#ifndef WaterV
		if(water > 0.9) colorb *= cmult*cmult;
		#endif
		
		color *= mix(vec3(1.0),sqrt(colorb),alpha*alpha);
		
		float absorb = float((water > 0.9 && isEyeInWater < 0.9) || (water < 0.9 && isEyeInWater > 0.9));
		vec3 uw_tint = mix(vec3(1.0),water_c*0.5,absorb*max(1.0-pow(aux.b,2.2),0.0));
		
		#ifdef AO
		#ifndef AOTranslucent
		if(alpha > 0.98){
		#endif
		ao = dbao(depthtex0, dither);
		#ifndef AOTranslucent
		}
		#endif
		#endif
		
		colorb *= ao*uw_tint;
		
		#ifdef WaterV
		if(water > 0.9){
			color*= (1.0+colorb*water_a*4.0);
			alpha*= sqrt(water_a);
		}
		#endif
		
		color = color*(1.0-alpha)+colorb;
		
		#ifdef Fog
		if (isEyeInWater < 0.9) color = calcFog(color, fragpos.xyz);
		#endif

	}
	
/* DRAWBUFFERS:0 */
	
	gl_FragData[0] = vec4(pow(color/MAX_COLOR_RANGE,vec3(1.0/2.2)),spec);

}
