#version 120

#define AO
#define BrightEmissive
//#define BumpyEdge
//#define Celshade
#define Desaturation
//#define DisableTexture
#define Fog
//#define RPSupport
#define RPSFormat 0 //[0 1 2]
//#define WaterCaustic
#define WaterFog
//#define WorldTimeAnimation

#define MAX_COLOR_RANGE 32.0
const float sunPathRotation = -40.0;
const float eyeBrightnessHalflife = 10.0f;
const int noiseTextureResolution  = 1024;

varying vec3 lightVector;
varying vec3 upVec;
varying vec3 sunVec;
varying vec3 moonVec;
varying float sunVisibility;
varying float moonVisibility;

varying vec4 texcoord;

uniform sampler2D colortex0;
uniform sampler2D colortex2;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
#ifdef RPSupport
uniform sampler2D colortex6;
#endif
uniform sampler2D depthtex1;
uniform sampler2D noisetex;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform float rainStrength;
uniform float wetness;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;
uniform float viewWidth;
uniform float viewHeight;
uniform float aspectRatio;
uniform float far;
uniform float near;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;
uniform float blindness;
uniform float nightVision;

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0;
#else
float frametime = frameTimeCounter;
#endif

float nolight = 1.0-(clamp((time-12000.0)/500.0,0.0,1.0)-clamp((time-13500.0)/500.0,0.0,1.0) + clamp((time-22500.0)/500.0,0.0,1.0)-clamp((time-23500.0)/500.0,0.0,1.0));

vec3 calcLightColor(vec3 morning, vec3 day, vec3 night, vec3 rain){
	vec3 c = mix(night,mix(morning,day,pow(tB,0.75)),sunVisibility);
	return mix(c,pow(length(c),0.2)*rain,rainStrength);
}

float getSSS(vec3 normal, vec3 lightVector, vec3 fragpos){
	return max(dot(-normal,lightVector),0.0)*pow(max(dot(normalize(fragpos),normalize(lightVector)),0.0),25.0)*(1.0-rainStrength);
}

float ld(float depth) {
   return (2.0 * near) / (far + near - depth * (far - near));
}

float dither4x4(vec2 pos)
{
	const int ditherPattern[16] = int[16](
		0, 8, 2, 10,
		12, 4, 14, 6,
		3, 11, 1, 9,
		15, 7, 13, 5);

    vec2 position = floor(mod(vec2(texcoord.s * viewWidth,texcoord.t * viewHeight), 4.0f));

	int dither = ditherPattern[int(position.x) + int(position.y) * 4];

	return float(dither) / 16.0f;
}

float Blinn_Phong(vec3 ppos, vec3 lvector, vec3 normal, float gloss, float visibility)  {
	vec3 lightDir = vec3(lvector);
	
	vec3 surfaceNormal = normal;
	float cosAngIncidence = dot(surfaceNormal, lightDir);
	cosAngIncidence = clamp(cosAngIncidence, 0.0, 1.0);	
	
	vec3 viewDirection = normalize(-ppos);
	
	vec3 halfAngle = normalize(lightDir + viewDirection);
	float blinnTerm = dot(surfaceNormal, halfAngle);
	
	float normalDotEye = dot(normal, normalize(ppos));
	float fresnel = clamp(pow(1.0 + normalDotEye, 5.0),0.0,1.0);
	fresnel = fresnel*0.85 + 0.15 * (1.0-fresnel);
	float pi = 3.1415927;
	float n =  pow(2.0,gloss);
	return (pow(blinnTerm, n )*((n+8.0)/(8*pi)))*visibility;
}

float waterH(vec3 pos) {
	float noise = 0;
	noise+= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5-pos.y*0.7)/1024.0* 1.1).r*1.0;
	noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.7)/1024.0* 1.5).r*0.8;
	noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.7)/1024.0* 2.5).r*0.6;
	noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.7)/1024.0* 5.0).r*0.4;
	noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.7)/1024.0* 8.0).r*0.2;

	return noise;
}

float getCaustic(vec3 posxz){
	float deltaPos = 0.1;
	float h0 = waterH(posxz);
	float h1 = waterH(posxz + vec3(deltaPos,0.0,0.0));
	float h2 = waterH(posxz + vec3(-deltaPos,0.0,0.0));
	float h3 = waterH(posxz + vec3(0.0,0.0,deltaPos));
	float h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos));

	float caustic = max((1.0-abs(0.5-h0))*(1.0-(abs(h1-h2)+abs(h3-h4))),0.0);
		  caustic = max(pow(caustic,3.5),0.0)*2.0;
		  
	return caustic;
}

vec3 getSunMoon(vec3 fragpos, vec3 morning, vec3 day, vec3 night){
	float NdotS = dot(normalize(fragpos),normalize(sunVec));
	float issun = float(NdotS > 0.0);
	float sunmoon = pow(abs(NdotS),1200.0-400*issun);
	vec3 lightcol = mix(night*8.0*moonVisibility,mix(morning,day,pow(tB,0.75))*sunVisibility,issun);
	
	return sunmoon*lightcol*16.0;
}

vec3 getStars(vec3 fragpos, vec3 light_n){
	vec3 wpos = vec3(gbufferModelViewInverse * vec4(fragpos,1.0));
	vec3 intersection = wpos/(wpos.y+length(wpos.xz));
	vec2 wind = vec2(frametime,0.0);
	vec2 coord = intersection.xz*0.3+cameraPosition.xz*0.0001+wind*0.00125;
	
	float NdotU = pow(max(dot(normalize(fragpos),normalize(upVec)),0.0),0.25);
	
	float star = texture2D(noisetex,coord.xy).r;
		  star*= texture2D(noisetex,coord.xy+0.1).r;
		  star*= texture2D(noisetex,coord.xy+0.23).r;
		  star*= texture2D(noisetex,coord.xy+0.456).r;
		  star*= texture2D(noisetex,coord.xy+0.7891).r;
		  star = max(star-0.2,0.0)*10.0*NdotU*(1.0-rainStrength)*moonVisibility;
		
	return star*pow(light_n,vec3(0.8));
}

#include "lib/fragPos.glsl"
#include "lib/lightColors.glsl"
#include "lib/torchColor.glsl"
#include "lib/waterColor.glsl"
#include "lib/dimensionColor.glsl"
#include "lib/fogCalc.glsl"
#include "lib/celShading.glsl"
#include "lib/ambientOcclusion.glsl"

void main() {
	
	vec3 color = pow(max(texture2D(colortex0, texcoord.st).rgb,vec3(1.0/255.0)),vec3(2.2));
	vec3 aux = texture2D(colortex4, texcoord.st).rgb;
	float ao = 1.0;
	float spec = 0.0;
	float specemissive = 0.0;
	
	float dither = dither4x4(texcoord.xy);
	
	float skymap = pow(aux.r,2.2);
	float matflag = aux.g;
	float wmatflag = texture2D(colortex5, texcoord.st).g;
	float torchmap = pow(aux.b,2.2)*0.2 + pow(max(aux.b-0.1,0.0)*1.11,16.0)*4.0;
	
	float land = float(matflag > 0.05);
	float lava = float(matflag > 0.18 && matflag < 0.22);
	float metal = 0.0;
	float foliage = float(matflag > 0.38 && matflag < 0.42);
	float emissive = float(matflag > 0.48 && matflag < 0.52);
	float clear = float(matflag > 0.58 && matflag < 0.62);
	float spidereye = float(matflag > 0.68 && matflag < 0.72);
	
	float water = float(wmatflag > 0.08 && wmatflag < 0.12);
	float translucent = float(wmatflag > 0.05);
	float absorb = float((water > 0.9 && isEyeInWater < 0.9) || (water < 0.9 && isEyeInWater > 0.9));
	
	float pixeldepth = texture2D(depthtex1,texcoord.xy).x;
	
	vec4 fragpos = getFragPos(texcoord.xy,pixeldepth);
	
	if (land > 0.9 && clear < 0.9) {
		vec3 normal = texture2D(colortex2, texcoord.st).rgb*2.0-1.0;
		
		#ifdef DisableTexture
		color = vec3(1.0,1.0,1.0)*0.4*(1.0+0.5*(emissive+lava));
		#endif
		
		vec4 worldpos = getWorldPos(fragpos);
		
		vec3 finallight = vec3(0);
		vec3 scenelight = vec3(0);
		vec3 torchlight = max(pow(torch_c,vec3(1.2-0.2*sqrt(sqrt(aux.b)))),vec3(spidereye)*TorchS)*torchmap*8.0;
		
		if(spidereye > 0.9) torchlight /= TorchS*2.0;
		
		#ifdef RPSupport
		#if RPSFormat == 0
		metal = float(matflag > 0.28 && matflag < 0.32);
		#endif
		#if RPSFormat == 1
		metal = texture2D(colortex6,texcoord.xy).g;
		#endif
		#if RPSFormat == 2
		metal = texture2D(colortex6,texcoord.xy).g;
		specemissive = pow(texture2D(colortex6,texcoord.xy).b,0.5);
		torchlight += color*8.0*specemissive;
		emissive *= 0.0;
		#endif
		#endif
		
		#ifdef BrightEmissive
		vec3 emissivelight = color*(emissive+lava*2.0)*8.0;
		#else
		vec3 emissivelight = vec3(0.0);
		#endif
		
		float NdotU = pow(dot(normal,normalize(gbufferModelView[1].xyz))*0.25+0.75,2.2);
		
		vec3 uw_tint = mix(vec3(1.0),water_c*0.5,absorb)*(1.0+water);
		
		#ifdef WaterCaustic
		if (absorb > 0.9){
		vec3 causticcol = calcLightColor(light_m, light_d, pow(light_n,vec3(0.5))*4.0, light_r);
		vec3 causticpos = worldpos.xyz+cameraPosition.xyz;
		vec3 caustic = getCaustic(causticpos)*((0.8-0.6*skymap)*causticcol*shading+4.0*pow(torch_c,vec3(0.5/2.2))*pow(aux.b,2.2));
		color *= 1.0+caustic;
		}
		#endif
		
		if (foliage > 0.9) NdotU *= 1.8;
		if(lava > 0.9) NdotU = 1.0;
		
		#ifdef AO
		ao = dbao(depthtex1, dither);
		#endif
		
		scenelight = vec3(0.05);
		finallight = (scenelight*uw_tint+torchlight+emissivelight+nightVision)*ao*NdotU;
		
		color = color/sqrt(1.0+color*color);
		color *= finallight;
		
		#ifdef Desaturation
		float desat = clamp(aux.b+emissive+lava+specemissive,0.5,1.0);
		color = mix(length(color)*end_c,color,desat);
		#endif
		
		#ifdef Fog
		if (absorb < 0.9) color = calcFog(color, fragpos.xyz);
		#endif
	}
	else{
	color *= 2.0;
	}
	
	#ifdef WaterFog
	if (absorb > 0.9 || (isEyeInWater > 0.9 && (translucent > 0.9 || land < 0.9) && water < 0.9)){
		float NdotU = dot(normalize(fragpos.xyz),normalize(upVec));
		float wnofog = max(mix(clamp(NdotU*32.0+1.5,0.0,1.0), skymap/mix(1.0,max(length(fragpos.xyz),1.0),isEyeInWater), land)-(1.0-eBS),0.0);
		vec3 wfog_c = water_c;
		color = calcWFog(color, wfog_c, cmult, wfogrange, wnofog, fragpos.xyz);
	}
	#endif
	
	if (wmatflag > 0.05){
		#ifdef Celshade
		color *= celshade(depthtex1,length(fragpos.xyz));
		#endif
		
		#ifdef BumpyEdge
		color = bumpyedge(color,depthtex1);
		#endif
		
		#ifdef Fog
		if (isEyeInWater > 1.9) color = calcLFog(color,fragpos.xyz);
		if (blindness > 0.001) color = calcBFog(color,blindness,fragpos.xyz);
		#endif
	}
	
	if (clear > 0.9) color = vec3(0.0);
	
/* DRAWBUFFERS:0 */
	
	gl_FragData[0] = vec4(pow(color/MAX_COLOR_RANGE,vec3(1.0/2.2)),spec);

}
