#define ShadowFilter
#define ShadowCloseDithering
#define ShadowOffset 0.10 //[0.05 0.10 0.15 0.20 0.25 0.30]

float getShadows(sampler2DShadow tex, vec4 worldPos, float NdotL, float foliage){

	float shading = 1.0;

	vec4 shadowpos = getShadowPos(worldPos);
	
	float distb = sqrt(shadowpos.x * shadowpos.x + shadowpos.y * shadowpos.y);
	float distortFactor = 1.0 - SHADOW_MAP_BIAS + distb * SHADOW_MAP_BIAS;
	float distmult = shadowDistance/256.0;
	
	float diffthresh = (pow(distortFactor,2.0)*(4.0/shadowMapResolution)*(tan(acos(abs(NdotL)))) + (ShadowOffset/shadowMapResolution))*distmult;
	shadowpos = distortShadow(shadowpos,distortFactor);
	float step = 0.7/shadowMapResolution;
	
	#ifdef ShadowCloseDithering
	shadowpos.z -= 0.0625*dither4x4(texcoord.xy)/shadowMapResolution;
	#endif
	
	if (foliage > 0.9){
		diffthresh = 0.0002;
		step = 2.0/shadowMapResolution;
		}
	
	if (NdotL > 0.0 || foliage > 0.9){
		#ifdef ShadowFilter
		shading = shadow2D(tex,vec3(shadowpos.st, shadowpos.z-diffthresh)).x;
		shading += shadow2D(tex,vec3(shadowpos.st+vec2(step,0), shadowpos.z-diffthresh)).x;
		shading += shadow2D(tex,vec3(shadowpos.st+vec2(-step,0), shadowpos.z-diffthresh)).x;
		shading += shadow2D(tex,vec3(shadowpos.st+vec2(0,step), shadowpos.z-diffthresh)).x;
		shading += shadow2D(tex,vec3(shadowpos.st+vec2(0,-step), shadowpos.z-diffthresh)).x;
		shading *= 0.2;
		#else
		shading = shadow2D(tex,vec3(shadowpos.st, shadowpos.z-diffthresh)).x;
		#endif
	}else{
		shading = 0.0;
	}
	
	return shading;
}

#ifdef ShadowColor
vec3 getShadowsColor(vec4 worldPos, float NdotL, float foliage){

	vec3 shading = vec3(1.0);

	vec4 shadowpos = getShadowPos(worldPos);
	
	float distb = sqrt(shadowpos.x * shadowpos.x + shadowpos.y * shadowpos.y);
	float distortFactor = (1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
	float distmult = shadowDistance/256.0;
	
	float diffthresh = (pow(distortFactor,2.0)*(4.0/shadowMapResolution)*(tan(acos(abs(NdotL)))) + (ShadowOffset/shadowMapResolution))*distmult;
	shadowpos = distortShadow(shadowpos,distortFactor);
	float step = 0.7/shadowMapResolution;
	
	#ifdef ShadowCloseDithering
	shadowpos.z -= 0.0625*dither4x4(texcoord.xy)/shadowMapResolution;
	#endif
	
	if (foliage > 0.9){
		diffthresh = 0.0002;
		step = 2.0/shadowMapResolution;
		}
	
	if (NdotL > 0.0 || foliage > 0.9){
		#ifdef ShadowFilter
		shading = shadow2D(shadowcolor,vec3(shadowpos.st, shadowpos.z-diffthresh)).rgb;
		shading += shading,shadow2D(shadowcolor,vec3(shadowpos.st+vec2(step,0), shadowpos.z-diffthresh)).rgb;
		shading += shading,shadow2D(shadowcolor,vec3(shadowpos.st+vec2(-step,0), shadowpos.z-diffthresh)).rgb;
		shading += shading,shadow2D(shadowcolor,vec3(shadowpos.st+vec2(0,step), shadowpos.z-diffthresh)).rgb;
		shading += shading,shadow2D(shadowcolor,vec3(shadowpos.st+vec2(0,-step), shadowpos.z-diffthresh)).rgb;
		shading *= 0.1;
		#else
		shading = shadow2D(shadowcolor,vec3(shadowpos.st, shadowpos.z-diffthresh)).rgb;
		#endif
	}
	
	return shading*NdotL;
}
#endif