#version 120

#define WavingCrops
#define WavingFire
#define WavingFlowers
#define WavingGrass
#define WavingLava
#define WavingLeaves
#define WavingLilypad
#define WavingTall
#define WavingVines

//#define RPSupport
//#define WorldTimeAnimation

const float PI = 3.1415927;

varying vec4 color;
varying vec2 lmcoord;
varying vec2 texcoord;
varying float mat;
varying float recolor;

varying vec3 normal;

#ifdef RPSupport
varying vec4 vtexcoordam; // .st for add, .pq for mul
varying vec4 vtexcoord;
varying vec3 wpos;
varying vec3 tangent;
varying vec3 binormal;
varying vec3 viewVector;
varying float dist;
#endif

attribute vec4 mc_Entity;
attribute vec4 mc_midTexCoord;

uniform vec3 cameraPosition;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform int worldTime;
uniform float frameTimeCounter;
uniform float rainStrength;

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0;
#else
float frametime = frameTimeCounter;
#endif

float pi2wt = PI*2*(frametime*24);

vec3 calcWave(in vec3 pos, in float fm, in float mm, in float ma, in float f0, in float f1, in float f2, in float f3, in float f4, in float f5) {
    vec3 ret;
    float magnitude,d0,d1,d2,d3;
    magnitude = sin(pi2wt*fm + pos.x*0.5 + pos.z*0.5 + pos.y*0.5) * mm + ma;
    d0 = sin(pi2wt*f0);
    d1 = sin(pi2wt*f1);
    d2 = sin(pi2wt*f2);
    ret.x = sin(pi2wt*f3 + d0 + d1 - pos.x + pos.z + pos.y) * magnitude;
    ret.z = sin(pi2wt*f4 + d1 + d2 + pos.x - pos.z + pos.y) * magnitude;
	ret.y = sin(pi2wt*f5 + d2 + d0 + pos.z + pos.y - pos.y) * magnitude;
    return ret;
}

vec3 calcMove(in vec3 pos, in float f0, in float f1, in float f2, in float f3, in float f4, in float f5, in vec3 amp1, in vec3 amp2) {
    vec3 move1 = calcWave(pos      , 0.0027, 0.0400, 0.0400, 0.0127, 0.0089, 0.0114, 0.0063, 0.0224, 0.0015) * amp1;
	vec3 move2 = calcWave(pos+move1, 0.0348, 0.0400, 0.0400, f0, f1, f2, f3, f4, f5) * amp2;
    return move1+move2;
}

vec3 calcWaterMove(in vec3 pos)
{
	float fy = fract(pos.y + 0.001);
	if (fy > 0.002)
	{
		float wave = 0.05 * sin(2*PI/4*frametime + 2*PI*2/16*pos.x + 2*PI*5/16*pos.z)
				   + 0.05 * sin(2*PI/3*frametime - 2*PI*3/16*pos.x + 2*PI*4/16*pos.z);
		return vec3(0, clamp(wave, -fy, 1.0-fy), 0);
	}
	else
	{
		return vec3(0);
	}
}


void main() {
	texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).st;
	#ifdef RPSupport
	vec2 midcoord = (gl_TextureMatrix[0] *  mc_midTexCoord).st;
	vec2 texcoordminusmid = texcoord-midcoord;
	vtexcoordam.pq  = abs(texcoordminusmid)*2;
	vtexcoordam.st  = min(texcoord,midcoord-texcoordminusmid);
	vtexcoord.xy    = sign(texcoordminusmid)*0.5+0.5;
	#endif
	mat = 1.0f;
	float istopv = 0.0;
	//texcoord = gl_MultiTexCoord0.xy;
	if (gl_MultiTexCoord0.t < mc_midTexCoord.t) istopv = 1.0;
	/* un-rotate */
	vec4 position = gbufferModelViewInverse * gl_ModelViewMatrix * gl_Vertex;
	vec3 worldpos = position.xyz + cameraPosition;
	/*
	//initialize per-entity waving parameters
	float parm0,parm1,parm2,parm3,parm4,parm5 = 0.0;
	vec3 ampl1,ampl2;
	ampl1 = vec3(0.0);
	ampl2 = vec3(0.0);
	*/
	if (istopv > 0.9) {
	#ifdef WavingGrass
	if ( mc_Entity.x == 31.0 ){
			position.xyz += calcMove(worldpos.xyz, 0.0041, 0.0070, 0.0044, 0.0038, 0.0063, 0.0000, vec3(0.8,0.0,0.8), vec3(0.4,0.0,0.4));
			if (length(position.xyz) < 2.0) position.xz *= 1+max(5.0/pow(max(length(position.xyz*vec3(8.0,2.0,8.0)-vec3(0.0,2.0,0.0)),2.0),1.0)-0.625,0.0);
			}
	#endif
	
	#ifdef WavingFlowers
	if (mc_Entity.x == 37.0 || mc_Entity.x == 38.0 )
			position.xyz += calcMove(worldpos.xyz, 0.0041, 0.005, 0.0044, 0.0038, 0.0240, 0.0000, vec3(0.8,0.0,0.8), vec3(0.4,0.0,0.4));
	#endif
	#ifdef WavingCrops
	if ( mc_Entity.x == 59.0 || mc_Entity.x == 141 || mc_Entity.x == 142 || mc_Entity.x == 207 ){
			position.xyz += calcMove(worldpos.xyz, 0.0041, 0.0070, 0.0044, 0.0038, 0.0240, 0.0000, vec3(0.8,0.0,0.8), vec3(0.4,0.0,0.4));
			if (length(position.xyz) < 2.0) position.xz *= 1+max(5.0/pow(max(length(position.xyz*vec3(8.0,2.0,8.0)-vec3(0.0,2.0,0.0)),2.0),1.0)-0.625,0.0);
			}
	#endif
	#ifdef WavingFire
	if ( mc_Entity.x == 51.0 )
			position.xyz += calcMove(worldpos.xyz, 0.0105, 0.0096, 0.0087, 0.0063, 0.0097, 0.0156, vec3(1.2,0.4,1.2), vec3(0.8,0.8,0.8));
	#endif
	}
	
	#ifdef WavingTall
	if (mc_Entity.x == 175.0 )
			position.xyz += calcMove(worldpos.xyz, 0.0041, 0.005, 0.0044, 0.0038, 0.0240, 0.0000, vec3(0.8,0.1,0.8), vec3(0.4,0.0,0.4));
	#endif
	#ifdef WavingLeaves
	if ( mc_Entity.x == 18.0 || mc_Entity.x == 161.0 )
			position.xyz += calcMove(worldpos.xyz, 0.0040, 0.0064, 0.0043, 0.0035, 0.0037, 0.0041, vec3(0.5,0.5,0.5), vec3(0.25,0.25,0.25));
	#endif
	#ifdef WavingVines
	if ( mc_Entity.x == 106.0 )
			position.xyz += calcMove(worldpos.xyz, 0.0040, 0.0064, 0.0043, 0.0035, 0.0037, 0.0041, vec3(0.05,0.4,0.05), vec3(0.05,0.3,0.05));
	#endif
	#ifdef WavingLava
	if ( mc_Entity.x == 10.0 || mc_Entity.x == 11.0 ) {
			mat = 0.2;
			position.xyz += calcWaterMove(worldpos.xyz) * 0.25;
			}
	#endif
	#ifdef WavingLilypad
	if ( mc_Entity.x == 111.0 ) {
			position.xyz += calcWaterMove(worldpos.xyz);
			mat = 0.4;
			}
	#endif

	recolor = 0.0;
	
	if (mc_Entity.x == 22.0 || mc_Entity.x == 41.0 || mc_Entity.x == 42.0 || mc_Entity.x == 57.0 || mc_Entity.x == 71.0 || mc_Entity.x == 133.0 || mc_Entity.x == 152.0 || mc_Entity.x == 173.0) mat = 0.3;
	if (mc_Entity.x == 18.0 || mc_Entity.x == 106.0 || mc_Entity.x == 31.0 || mc_Entity.x == 37.0 || mc_Entity.x == 38.0 || mc_Entity.x == 59.0 || mc_Entity.x == 30.0 || mc_Entity.x == 83.0 || mc_Entity.x == 175.0 || mc_Entity.x == 115.0 || mc_Entity.x == 32.0 || mc_Entity.x == 161.0 || mc_Entity.x == 141.0 || mc_Entity.x == 142.0 || mc_Entity.x == 207.0 || mc_Entity.x == 111)
	mat = 0.4;
	if (mc_Entity.x == 50.0 || mc_Entity.x == 51.0 || mc_Entity.x == 55.0 || mc_Entity.x == 76.0 || mc_Entity.x == 91.0 || mc_Entity.x == 198.0  ||  mc_Entity.x == 89.0 || mc_Entity.x == 124.0 || mc_Entity.x == 138.0 || mc_Entity.x == 169.0 || mc_Entity.x == 213) mat = 0.5;
	
	if (mc_Entity.x == 89.0 || mc_Entity.x == 124.0 || mc_Entity.x == 138.0 || mc_Entity.x == 169.0 || mc_Entity.x == 213.0) recolor = 1.0;
	
	/* re-rotate */
	
	/* projectify */
	gl_Position = gl_ProjectionMatrix * gbufferModelView * position;
	
	color = gl_Color;
	
	lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;

	normal = normalize(gl_NormalMatrix * gl_Normal);
	
	#ifdef RPSupport
	tangent = vec3(0.0);
	binormal = vec3(0.0);
	if (gl_Normal.x > 0.5) {
		//  1.0,  0.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0, -1.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	}
	
	else if (gl_Normal.x < -0.5) {
		// -1.0,  0.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	}
	
	else if (gl_Normal.y > 0.5) {
		//  0.0,  1.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
	}
	
	else if (gl_Normal.y < -0.5) {
		//  0.0, -1.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
	}
	
	else if (gl_Normal.z > 0.5) {
		//  0.0,  0.0,  1.0
		tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	}
	
	else if (gl_Normal.z < -0.5) {
		//  0.0,  0.0, -1.0
		tangent  = normalize(gl_NormalMatrix * vec3(-1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	}
	mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
						  tangent.y, binormal.y, normal.y,
						  tangent.z, binormal.z, normal.z);


	viewVector = ( gl_ModelViewMatrix * gl_Vertex).xyz;

	viewVector = (tbnMatrix * viewVector);


	dist = 0.0;
	dist = length(gl_ModelViewMatrix * gl_Vertex);
	#endif
}