#version 120

#define Desaturation
//#define DisableTexture

#define BrightEmissive
#define EmissiveRecolor

//#define RPSupport
#define RPSFormat 0 //[0 1 2]

#define MAX_COLOR_RANGE 32.0

varying vec4 color;
varying vec4 texcoord;
varying vec2 lmcoord;
varying vec3 normal;

uniform sampler2D texture;
#ifdef RPSupport
uniform sampler2D specular;
#endif

uniform float nightVision;
uniform mat4 gbufferModelView;

#include "lib/torchColor.glsl"
#include "lib/dimensionColor.glsl"

void main() {
	vec2 adjustedTexCoord = texcoord.st;
	vec3 albedo = texture2D(texture,adjustedTexCoord).rgb*color.rgb;
	vec4 frag2 = vec4(normal*0.5+0.5, 1.0f);
	vec3 spec = vec3(0.0);
	#ifdef RPSupport
	spec = texture2D(specular,adjustedTexCoord).rgb;
	#endif
	
	float NdotU = pow(dot(frag2.xyz*2.0-1.0,normalize(gbufferModelView[1].xyz))*0.25+0.75,2.2);
	float specemissive = 0.0;
	
	float torchmap = pow(lmcoord.s,2.2)*0.2 + pow(max(lmcoord.s-0.1,0.0)*1.11,16.0)*4.0;
	vec3 torchlight = pow(torch_c,vec3(1.2-0.2*sqrt(sqrt(lmcoord.s))))*torchmap*8.0;
	
	#ifdef RPSupport
	#if RPSFormat == 2
	specemissive = spec.b;
	torchlight += pow(albedo.rgb,vec3(2.2))*8.0*specemissive;
	#endif
	#endif
	
	vec3 scenelight = vec3(0.05);
	vec3 finallight = (scenelight+torchlight+nightVision)*NdotU;
	
	albedo.rgb = pow(albedo.rgb,vec3(2.2));
	
	#ifdef DisableTexture
		albedo.rgb = vec3(0.4);
	#endif
	
	albedo.rgb = albedo.rgb/sqrt(1.0+albedo.rgb*albedo.rgb);
	albedo.rgb *= finallight;
	
	#ifdef Desaturation
	float ddesat = clamp(lmcoord.s+sqrt(sqrt(specemissive)),0.2,1.0);
	albedo.rgb = mix(dot(albedo.rgb,vec3(0.299, 0.587, 0.114))*nether_c,albedo.rgb,ddesat);
	#endif
	
	albedo.rgb = pow(albedo.rgb/MAX_COLOR_RANGE,vec3(1.0/2.2));
	
/* DRAWBUFFERS:1356 */

	gl_FragData[0] = vec4(albedo,pow(texture2D(texture,adjustedTexCoord).a,0.1/2.2));
	gl_FragData[1] = frag2;	
	gl_FragData[2] = vec4(lmcoord.t, 0.4, lmcoord.s, 1.0);
	gl_FragData[3] = vec4(spec,1.0);
}