#version 120

//#define BumpyEdge
//#define Celshade
#define ExtraReflection
#define Fog
#define LightShaft
//#define RPSupport
#define RPSFormat 0 //[0 1 2]
#define WaterReflection
#define WaterFog
//#define WorldTimeAnimation

#define MAX_COLOR_RANGE 32.0
const bool colortex1MipmapEnabled = true;

varying vec3 lightVector;
varying vec3 upVec;
varying vec3 sunVec;
varying vec3 moonVec;
varying float sunVisibility;
varying float moonVisibility;

varying vec4 texcoord;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
#ifdef RPSupport
uniform sampler2D colortex6;
#endif
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D noisetex;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform float rainStrength;
uniform float wetness;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;
uniform vec3 sunPosition;
uniform float viewWidth;
uniform float viewHeight;
uniform float far;
uniform float near;
uniform float aspectRatio;
uniform float blindness;
uniform float nightVision;

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0;
#else
float frametime = frameTimeCounter;
#endif

float nolight = 1.0-(clamp((time-12000.0)/500.0,0.0,1.0)-clamp((time-13500.0)/500.0,0.0,1.0) + clamp((time-22500.0)/500.0,0.0,1.0)-clamp((time-23500.0)/500.0,0.0,1.0));

const int maxf = 4;				//number of refinements
const float stp = 1.2;			//size of one step for raytracing algorithm
const float ref = 0.1;			//refinement multiplier
const float inc = 1.8;			//increasement factor at each step

const int gmaxf = 3;				//number of refinements
const float gstp = 1.2;			//size of one step for raytracing algorithm
const float gref = 0.11;			//refinement multiplier
const float ginc = 3.0;			//increasement factor at each step

vec3 calcLightColor(vec3 morning, vec3 day, vec3 night, vec3 rain){
vec3 c = mix(night,mix(morning,day,pow(tB,0.75)),sunVisibility);
return mix(c,length(c)*rain,rainStrength);
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}

float ld(float depth) {
   return (2.0 * near) / (far + near - depth * (far - near));
}

vec4 raytrace(vec3 fragpos, vec3 normal,vec3 fogclr, vec3 sky_int) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = stp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
	float land = 0.0;
	float translucent = 0.0;
	float border = 0.0;
	vec3 pos = vec3(0.0);
    for(int i=0;i<40;i++){
        pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
        if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
		translucent = float(texture2D(colortex5, pos.st).g > 0.18);
		float depth = 0.0;
		if (translucent > 0.9) depth = texture2D(depthtex0, pos.st).r;
		else depth = texture2D(depthtex1, pos.st).r;
        vec3 spos = vec3(pos.st, depth);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = abs(length(fragpos.xyz-spos.xyz));
		if(err < pow(length(vector)*pow(length(tvector),0.11),1.1)*1.1){

                sr++;
                if(sr >= maxf){
                    border = clamp(1.0 - pow(cdist(pos.st), 40.0), 0.0, 1.0);
					land = max(float(texture2D(colortex4, pos.st).g > 0.08),translucent);
					spos.z = mix(fragpos.z,2000.0*(0.4+clamp(sunVisibility+moonVisibility,0,1)*0.6),land);
                    break;
                }
				tvector -=vector;
                vector *=ref;
		}
        vector *= inc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }
	if (land > 0.9){
		color = texture2D(colortex0, pos.st);
		color.rgb = pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE;
	}
	color.a = land*border;
    return color;
}

vec4 raytrace_g(vec3 fragpos, vec3 normal,vec3 fogclr, vec3 sky_int) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = gstp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
	float land = 0.0;
	float translucent = 0.0;
	float border = 0.0;
	vec3 pos = vec3(0.0);
    for(int i=0;i<30;i++){
        pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
        if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
		translucent = float(texture2D(colortex5, pos.st).g > 0.18);
		float depth = 0.0;
		if (translucent > 0.9) depth = texture2D(depthtex0, pos.st).r;
		else depth = texture2D(depthtex1, pos.st).r;
        vec3 spos = vec3(pos.st, depth);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = abs(length(fragpos.xyz-spos.xyz));
		if(err < pow(length(vector)*pow(length(tvector),0.11),1.1)*1.1){

                sr++;
                if(sr >= gmaxf){
                    border = clamp(1.0 - pow(cdist(pos.st), 40.0), 0.0, 1.0);
					land = max(float(texture2D(colortex4, pos.st).g > 0.08),translucent);
					spos.z = mix(fragpos.z,2000.0*(0.4+clamp(sunVisibility+moonVisibility,0,1)*0.6),land);
                    break;
                }
				tvector -=vector;
                vector *=gref;
		}
        vector *= ginc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }
	if (land > 0.9){
		color = texture2D(colortex0, pos.st);
		color.rgb = pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE;
	}
	color.a = land*border;
    return color;
}

float dither4x4(vec2 pos)
{
	const int ditherPattern[16] = int[16](
		0, 8, 2, 10,
		12, 4, 14, 6,
		3, 11, 1, 9,
		15, 7, 13, 5);

    vec2 position = floor(mod(vec2(texcoord.s * viewWidth,texcoord.t * viewHeight), 4.0f));

	int dither = ditherPattern[int(position.x) + int(position.y) * 4];

	return float(dither) / 16.0f;
}

#include "lib/fragPos.glsl"
#include "lib/lightColors.glsl"
#include "lib/waterColor.glsl"
#include "lib/dimensionColor.glsl"
#include "lib/fogCalc.glsl"
#include "lib/celShading.glsl"

void main() {
	
	vec3 color = pow(texture2D(colortex0, texcoord.st).rgb,vec3(2.2))*MAX_COLOR_RANGE;
	vec3 normal = texture2D(colortex2, texcoord.st).rgb*2.0-1.0;
	vec3 waternormal = texture2D(colortex3, texcoord.st).rgb*2.0-1.0;
	vec3 aux = texture2D(colortex4, texcoord.st).rgb;
	vec3 wateraux = texture2D(colortex5, texcoord.st).rgb;
	
	float skymap = aux.r;
	float wskymap = wateraux.r;
	float matflag = aux.g;
	float wmatflag = wateraux.g;
	
	float land = float(matflag > 0.08);
	float translucent = float(wmatflag > 0.08);
	float water = float(wmatflag > 0.08 && wmatflag < 0.12);
	float hand = float(wmatflag > 0.38 && wmatflag < 0.42);
	
	float pixeldepth = texture2D(depthtex1,texcoord.xy).x;
	float wpixeldepth = texture2D(depthtex0,texcoord.xy).x;
	vec4 fragpos = getFragPos(texcoord.xy,pixeldepth);
	vec4 wfragpos = getFragPos(texcoord.xy,wpixeldepth);

	float wNdotE = dot(normalize(waternormal), normalize(wfragpos.xyz));
	float wfresnel = pow(1.0 + wNdotE, 5.0);
	wfresnel = clamp(wfresnel*0.99+0.01,0,1);
	
	vec3 wRefPos = reflect(normalize(wfragpos.xyz), normalize(waternormal));
	wRefPos = wfragpos.xyz + wRefPos * (2000.0-wfragpos.z);
	
	vec4 reflection = vec4(0.0);
	float doreflect = 0.0;
	
	#ifdef WaterReflection
	doreflect = water;
	#endif
	#ifdef ExtraReflection
	doreflect += float(wmatflag > 0.18 && wmatflag < 0.22);
	#endif
	
	if (doreflect+water > 0.9){
		vec3 sky_ref = nether_c*0.005;
		#if defined WaterReflection || defined ExtraReflection
		if (doreflect > 0.9) reflection = raytrace(wfragpos.xyz,waternormal,sky_ref,wRefPos);
		#endif
		
		reflection.rgb = mix(sky_ref,reflection.rgb,reflection.a);
		reflection.a = min(reflection.a,1.0);
		color = mix(color,reflection.rgb,wfresnel*(1.0-0.5*isEyeInWater));
	}
	
	#ifdef RPSupport
	vec3 refPos = reflect(normalize(fragpos.xyz), normalize(normal));
	refPos = wfragpos.xyz + refPos * (2000.0-wfragpos.z);
	
	vec3 sky_ref = nether_c*0.005;
	if (((land > 0.9 && translucent < 0.9) || (translucent > 0.9 && water < 0.9)) && doreflect < 0.9){
		vec3 specmap = pow(texture2D(colortex6,texcoord.st).rgb,vec3(2.2));
		vec3 specnoise = (texture2D(noisetex,fragpos.xz+fragpos.y+cameraPosition.xz+cameraPosition.y).rgb-0.5)*pow(1.0-specmap.r,4.0)*0.25*length(fragpos);
		float specular = mix(specmap.g,1.0,specmap.r);
		
		float NdotE = dot(normalize(normal), normalize(fragpos.xyz));
		float fresnel = pow(1.0 + NdotE, 5.0);
		fresnel = mix(clamp(fresnel*0.99+0.01,0,1),wfresnel,translucent);
		specnoise *= (1.0-sqrt(sqrt(fresnel)));
		if (fresnel*specular > 0.001){
			if (land > 0.9 && translucent < 0.9)reflection = raytrace_g(fragpos.xyz+specnoise,normal,sky_ref*max(skymap*1.25-0.25,0.0),refPos);
			if (translucent > 0.9)reflection = raytrace(wfragpos.xyz+specnoise,waternormal,sky_ref*max(wskymap*1.25-0.25,0.0),wRefPos);
		}
		
		if (land > 0.9 && translucent < 0.9) reflection.rgb = mix(sky_ref*max(skymap*1.25-0.25,0.0),reflection.rgb,reflection.a);
		if (translucent > 0.9) reflection.rgb = mix(sky_ref*max(wskymap*1.25-0.25,0.0),reflection.rgb,reflection.a);
		
		reflection.a = min(reflection.a,1.0);
				
		#if RPSFormat == 0
		float metal = float(matflag > 0.28 && matflag < 0.32 && translucent < 0.9);
		#endif
		#if RPSFormat == 1 || RPSFormat == 2
		float metal = texture2D(colortex6,texcoord.xy).g;
		#endif
		
		fresnel = mix(0.8*metal,1.0,fresnel);
		specular = mix(0.5*metal,1.0,specular);
		reflection.rgb = mix(reflection.rgb,(dot(reflection.rgb,vec3(0.299, 0.587, 0.114))*3.0+reflection.rgb)*color.rgb,metal);
		color = mix(color,reflection.rgb,specular*fresnel*(1.0-0.5*isEyeInWater));
	}
	#endif
	
	#ifdef Celshade
	color *= celshade(depthtex0,mix(1.0,length(fragpos.xyz),land));
	#endif
	
	#ifdef BumpyEdge
	if (land+translucent > 0.0) color = bumpyedge(color,depthtex0);
	#endif
	
	#ifdef WaterFog
	if (isEyeInWater > 0.9){
		float wnofog = max((skymap/max(length(fragpos.xyz),1.0))-(1.0-eBS),0.0);
		vec3 wfog_c = water_c;
		color = calcWFog(color, wfog_c, cmult, wfogrange, wnofog, mix(fragpos.xyz,wfragpos.xyz,translucent));
	}
	#endif
	
	#ifdef Fog
	if (isEyeInWater > 1.9) color = calcLFog(color,mix(fragpos.xyz,wfragpos.xyz,translucent));
	if (blindness > 0.001) color = calcBFog(color,blindness,mix(fragpos.xyz,wfragpos.xyz,translucent));
	#endif
	
/* DRAWBUFFERS:0 */
	gl_FragData[0] = vec4(pow(color/MAX_COLOR_RANGE,vec3(1.0/2.2)),1.0);

}
