#define ShadowFilter
#define ShadowCloseDithering

float getShadows(sampler2DShadow tex, vec4 worldPos, float NdotL, float foliage, float dither){

	float shading = 0.0;
	
	if (NdotL > 0.0 || foliage > 0.9){
		vec4 shadowpos = getShadowPos(worldPos);
		
		float distb = sqrt(shadowpos.x * shadowpos.x + shadowpos.y * shadowpos.y);
		float distortFactor = 1.0 - SHADOW_MAP_BIAS + distb * SHADOW_MAP_BIAS;
		
		float diffthresh = (0.1 + 4.0*distortFactor*distortFactor*(tan(acos(abs(NdotL)))))/shadowMapResolution;
		shadowpos = distortShadow(shadowpos,distortFactor);
		float step = 1.0/shadowMapResolution;
		
		#ifdef ShadowCloseDithering
		shadowpos.z -= 0.0625*dither/shadowMapResolution;
		#endif
		
		if (foliage > 0.9){
			diffthresh = 0.0002;
			step = 0.0009765625;
			}
		
		#ifdef ShadowFilter
		shading = shadow2D(tex,vec3(shadowpos.st, shadowpos.z-diffthresh)).x;
		shading += shadow2D(tex,vec3(shadowpos.st+vec2(step,0), shadowpos.z-diffthresh)).x;
		shading += shadow2D(tex,vec3(shadowpos.st+vec2(-step,0), shadowpos.z-diffthresh)).x;
		shading += shadow2D(tex,vec3(shadowpos.st+vec2(0,step), shadowpos.z-diffthresh)).x;
		shading += shadow2D(tex,vec3(shadowpos.st+vec2(0,-step), shadowpos.z-diffthresh)).x;
		shading *= 0.2;
		#else
		shading = shadow2D(tex,vec3(shadowpos.st, shadowpos.z-diffthresh)).x;
		#endif
	}
	return shading;
}

#ifdef ShadowColor
vec3 getShadowsColor(vec4 worldPos, float NdotL, float foliage, float dither){

	vec3 shading = vec3(1.0);

	if (NdotL > 0.0 || foliage > 0.9){
		vec4 shadowpos = getShadowPos(worldPos);
		
		float distb = sqrt(shadowpos.x * shadowpos.x + shadowpos.y * shadowpos.y);
		float distortFactor = (1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
		
		float diffthresh = (0.1 + 4.0*distortFactor*distortFactor*(tan(acos(abs(NdotL)))))/shadowMapResolution;
		shadowpos = distortShadow(shadowpos,distortFactor);
		float step = 1.0/shadowMapResolution;
		
		#ifdef ShadowCloseDithering
		shadowpos.z -= 0.0625*dither/shadowMapResolution;
		#endif
		
		if (foliage > 0.9){
			diffthresh = 0.0002;
			step = 2.0/shadowMapResolution;
			}
	
	
		#ifdef ShadowFilter
		shading = shadow2D(shadowcolor,vec3(shadowpos.st, shadowpos.z-diffthresh)).rgb;
		shading += shadow2D(shadowcolor,vec3(shadowpos.st+vec2(step,0), shadowpos.z-diffthresh)).rgb;
		shading += shadow2D(shadowcolor,vec3(shadowpos.st+vec2(-step,0), shadowpos.z-diffthresh)).rgb;
		shading += shadow2D(shadowcolor,vec3(shadowpos.st+vec2(0,step), shadowpos.z-diffthresh)).rgb;
		shading += shadow2D(shadowcolor,vec3(shadowpos.st+vec2(0,-step), shadowpos.z-diffthresh)).rgb;
		shading *= 0.2;
		#else
		shading = shadow2D(shadowcolor,vec3(shadowpos.st, shadowpos.z-diffthresh)).rgb;
		#endif
	}
	
	return shading*NdotL;
}
#endif