//#define SkyV

#define SkyCR 96 //[0 16 32 48 64 80 96 112 128 144 160 176 192 208 224 255]
#define SkyCG 160 //[0 16 32 48 64 80 96 112 128 144 160 176 192 208 224 255]
#define SkyCB 255 //[0 16 32 48 64 80 96 112 128 144 160 176 192 208 224 255]
#define SkyCS 1.00 //[0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.10 1.20 1.30 1.40 1.50 1.60 1.70 1.80 1.90 2.00 2.25 2.50 2.75 3.00 3.25 3.50 3.75 4.00]
#define SkyC vec3(SkyCR,SkyCG,SkyCB)/255.0

#ifdef SkyV
uniform vec3 skyColor;
uniform vec3 fogColor;

vec3 sky_c = pow(skyColor,vec3(2.2))*SkyCS;
vec3 fog_c = pow(fogColor,vec3(2.2))*SkyCS;
#else
#define sky_c SkyC*SkyC*SkyCS
#define fog_c sky_c
#endif

vec3 getSkyColor(vec3 fragpos, vec3 light){
vec3 sky_col = sky_c;
vec3 nfragpos = normalize(fragpos);

float NdotUp = dot(nfragpos,upVec);
float NdotS = dot(nfragpos,sunVec);

float top = pow(max(NdotUp,0.1),0.25)*0.475;
float horizon = pow(1.0-abs(NdotUp),2.5)*(0.4*sunVisibility+0.2)*(1-rainStrength*0.75);
float lightmix = (pow(max(NdotS,0.0),1.5)*(1-max(NdotUp,0.0))*pow(1.0-tB,3.0) + horizon*0.1*tB)*sunVisibility*(1.0-rainStrength);

#ifdef SkyV
sky_col = mix(sky_col,fog_c,sqrt(max(0.8-abs(NdotUp),0.0)*1.25));
#endif

float mult = 0.5 - top*(1.0-rainStrength*rainStrength*0.4) + horizon;

sky_col = (mix(sky_col*pow(max(1-lightmix,0.0),2.0),pow(light,vec3(1.5)),lightmix)*sunVisibility + light_n*0.4);
sky_col = mix(sky_col,pow(mult,0.2)*sky_r*(0.05+0.65*sunVisibility),rainStrength)*mult*(3.0-2.0*eBS);

return pow(sky_col,vec3(1.15));
}

vec3 getFogColor(vec3 fragpos, vec3 light){
vec3 fog_col = fog_c;
vec3 nfragpos = normalize(fragpos);

float NdotS = dot(nfragpos,sunVec);

float lightmix = pow(max(NdotS,0.0),1.5)*pow(1.0-tB,3.0)*sunVisibility*(1.0-rainStrength);

fog_col = (mix(fog_col*pow(max(1-lightmix,0.0),2.0),pow(light,vec3(1.5)),lightmix)*sunVisibility + light_n*0.4)*1.2;
fog_col = mix(fog_col,sky_r*(0.035+0.455*sunVisibility),rainStrength)*0.5;

return pow(fog_col,vec3(1.15));
}

vec3 calcFog(vec3 color, vec3 light, vec3 fragpos){
float fog = length(fragpos)/(128.0*(1.0+sunVisibility));
return mix(color,getFogColor(fragpos,light),min(fog,1.0)*eBS*(0.125+0.875*rainStrength));
}

vec3 calcWFog(vec3 color, vec3 wcol, float wstr, float fogrange, float nofog, vec3 fragpos){
float fog = min(length(fragpos)/(fogrange*(1.0+3.0*eBS)),1.0);
return mix(color,pow(wcol*pow(wstr,0.75),vec3(2.2)),min(fog,1.0)*max(1.0-nofog,0.0));
}

vec3 calcBFog(vec3 color, float blindness, vec3 fragpos){
	float b = max(blindness*2.0-1.0,0.0);
	b = b*b;
	float fog = pow(min(length(fragpos)/(5.0/b),1.0),1.0/2.2)*b;
	return mix(color,vec3(0.0),fog);
}

vec3 calcLFog(vec3 color, vec3 fragpos){
	float fog = min(length(fragpos)/(2.0),1.0);
	return mix(color,vec3(1.0,0.3,0.01),fog);
}