#define Clouds
#define CloudQuality 1 //[1 2 3]
#define CloudAmount 10.0 //[14.0 12.0 10.0 8.0 6.0]
#define CloudHeight 16.0 //[8.0 12.0 16.0 20.0 24.0]

#ifdef Clouds
vec3 drawCloud(vec3 fposition, float dither, vec3 color, vec3 light, vec3 ambient) {
float totalcloud = 0;
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float cosS = dot(sunVec,sVector);
float pi = 3.1415927;
vec2 wind = vec2(frametime,0.0)*0.001;
float step = 0.125/CloudQuality;

vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wVector = normalize(tpos);

float cloud = 0.0;
float cloudalpha = 0.0;
vec3 cloud_color = vec3(0.0);
float colmix = 0.0;
float colmult = 0.5*(1.0-moonVisibility*0.7)*(1.0-wetness*(0.8-0.4*sunVisibility));

if (cosT > 0.05){
	for (int i = 0; i < 8*CloudQuality; i++) {
		vec3 intersection = wVector*((CloudHeight+(i+dither)*0.5/CloudQuality)/wVector.y);
		vec2 coord = (intersection.xz + cameraPosition.xz*0.125)*0.002;
		
		float noise = 0.0;
		if (cloud < 0.999){
			noise+= texture2D(noisetex,coord*0.5+wind*0.5).x;
			noise+= texture2D(noisetex,coord*0.25+wind*0.4).x*2;
			noise+= texture2D(noisetex,coord*0.125+wind*0.3).x*3;
			noise+= texture2D(noisetex,coord*0.0625+wind*0.2).x*4;
			noise+= texture2D(noisetex,coord*0.03125+wind*0.1).x*5;
			noise+= texture2D(noisetex,coord*0.016125).x*6;
			noise = max(mix(noise,21.0,0.4*wetness)*min(sqrt(cosT*6.0),1.0)-(CloudAmount+0.5*abs(float(i-4*CloudQuality+dither))/CloudQuality),0.0)*(2.0-wetness);
			noise = noise/sqrt(1.0+noise*noise);
			}
		float hnoise = texture2D(noisetex,coord*0.25+wind*0.4).x + texture2D(noisetex,coord*0.5+wind*0.5).x;
		cloud_color = mix(cloud_color,mix(ambient*(1.0-0.2*wetness)*(1.0-0.5*moonVisibility),light,pow(colmix+step*(2.0*hnoise*(0.7*wetness+0.7)+dither),3.0)),noise*(1.0-cloud*cloud));
		cloud = max(cloud,noise);
		colmix += step;
		cloudalpha += cloud;
	}
	cloudalpha *= step;
	cloud_color *= (1.0+4.0*(1.0-cloudalpha*wetness)*pow(max(cosS,0.0),8.0)*wetness)*(2.0-eBS)*(1.0+nightVision);
	cloud *= clamp(cosT*10.0-0.5,0.0,1.0)*(1.0-0.7*wetness*wetness);
}
return mix(color,cloud_color*colmult,cloud*cloud);
}
#else
vec3 drawCloud(vec3 fposition, float dither, vec3 color, vec3 light, vec3 ambient) {
return color;
}
#endif