#version 120

varying vec4 color;
varying vec4 texcoord;
varying vec2 lmcoord;
varying vec3 normal;

uniform vec3 sunPosition;
uniform vec3 upPosition;
varying vec3 sunVec;
varying vec3 upVec;

void main() {
	
	texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0);
	lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;

	gl_Position = ftransform();
	
	color = gl_Color;
	
	normal = normalize(gl_NormalMatrix * gl_Normal);
	
	sunVec = normalize(sunPosition);
	upVec = normalize(upPosition);
}