#version 120

#define Desaturation
//#define DisableTexture

#define BrightEmissive
#define EmissiveRecolor

#define ShadowFilter
#define ShadowColor

//#define RPSupport
#define RPSFormat 0 //[0 1 2]

#define MAX_COLOR_RANGE 32.0
#define SHADOW_MAP_BIAS 0.90
const int shadowMapResolution = 2048; //[1024 2048 4096 8192]
const float shadowDistance = 256.0;

varying vec4 color;
varying vec4 texcoord;
varying vec2 lmcoord;
varying vec3 normal;

uniform sampler2D texture;
#ifdef RPSupport
uniform sampler2D specular;
#endif

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform float viewWidth;
uniform float viewHeight;
uniform sampler2DShadow shadowtex0;
uniform sampler2DShadow shadowtex1;
uniform sampler2DShadow shadowcolor0;
uniform ivec2 eyeBrightnessSmooth;
uniform int worldTime;
uniform float rainStrength;
uniform int isEyeInWater;
uniform float nightVision;
varying vec3 sunVec;
varying vec3 upVec;

uniform int heldItemId;

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;
float sunVisibility = pow(clamp(dot(sunVec,upVec)+0.1,0.0,0.1)/0.1,2.0);

vec3 calcLightColor(vec3 morning, vec3 day, vec3 night, vec3 rain){
	vec3 c = mix(night,mix(morning,day,pow(tB,0.75)),sunVisibility);
	return mix(c,pow(length(c),0.2)*rain,rainStrength);
}

#include "lib/lightColors.glsl"
#include "lib/torchColor.glsl"

void main() {
	vec2 adjustedTexCoord = texcoord.st;
	vec3 albedo = texture2D(texture,adjustedTexCoord).rgb*color.rgb;
	vec4 frag2 = vec4(normal*0.5+0.5, 1.0f);
	vec3 spec = vec3(0.0);
	#ifdef RPSupport
	spec = texture2D(specular,adjustedTexCoord).rgb;
	#endif
	
	vec4 fragpos = gbufferProjectionInverse*(vec4(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z+0.38,1.0)*2.0-1.0);
	fragpos /= fragpos.w;
	
	if (isEyeInWater > 0.9){
	float fov = atan(1./gbufferProjection[1][1]);
	float fovUnderWater = fov*0.85;
	fragpos.xy *= gbufferProjection[1][1]*tan(fovUnderWater);
	}
	
	vec4 worldpos = gbufferModelViewInverse * fragpos;
	float NdotL = max(dot(frag2.xyz*2.0-1.0,sunVec*(1.0-2.0*float(worldTime > 12700 && worldTime < 23500)))*1.05-0.05,0.0);
	float NdotU = pow(0.75+0.25*dot(frag2.xyz*2.0-1.0,upVec),2.2);
	float shading = 1.0;
	float specemissive = 0.0;
	vec3 shadowcol = vec3(0.0);
	
	if (NdotL > 0.0){
		worldpos = shadowModelView * worldpos;
		worldpos = shadowProjection * worldpos;
		worldpos /= worldpos.w;
		
		float distb = sqrt(worldpos.x * worldpos.x + worldpos.y * worldpos.y);
		float distortFactor = 1.0 - SHADOW_MAP_BIAS + distb * SHADOW_MAP_BIAS;
		
		float diffthresh = (0.1 + 4.0*distortFactor*distortFactor*(tan(acos(abs(NdotL)))))/shadowMapResolution + 0.0001;
		worldpos.xy /= distortFactor;
		worldpos.z *= 0.2;
		worldpos = worldpos*0.5+0.5;
		float step = 1.0/shadowMapResolution;
		
		#ifdef ShadowFilter
		shading = shadow2D(shadowtex0,vec3(worldpos.st, worldpos.z-diffthresh)).x;
		shading += shadow2D(shadowtex0,vec3(worldpos.st+vec2(step,0), worldpos.z-diffthresh)).x;
		shading += shadow2D(shadowtex0,vec3(worldpos.st+vec2(-step,0), worldpos.z-diffthresh)).x;
		shading += shadow2D(shadowtex0,vec3(worldpos.st+vec2(0,step), worldpos.z-diffthresh)).x;
		shading += shadow2D(shadowtex0,vec3(worldpos.st+vec2(0,-step), worldpos.z-diffthresh)).x;
		shading *= 0.2;
		#else
		shading = shadow2D(shadowtex0,vec3(worldpos.st, worldpos.z-diffthresh)).x;
		#endif
		
		if (shading < 0.999){
			#ifdef ShadowColor
				#ifdef ShadowFilter
				shadowcol = shadow2D(shadowcolor0,vec3(worldpos.st, worldpos.z-diffthresh)).rgb*shadow2D(shadowtex1,vec3(worldpos.st, worldpos.z-diffthresh)).x;
				shadowcol += shadow2D(shadowcolor0,vec3(worldpos.st+vec2(step,0), worldpos.z-diffthresh)).rgb*shadow2D(shadowtex1,vec3(worldpos.st+vec2(step,0), worldpos.z-diffthresh)).x;
				shadowcol += shadow2D(shadowcolor0,vec3(worldpos.st+vec2(-step,0), worldpos.z-diffthresh)).rgb*shadow2D(shadowtex1,vec3(worldpos.st+vec2(-step,0), worldpos.z-diffthresh)).x;
				shadowcol += shadow2D(shadowcolor0,vec3(worldpos.st+vec2(0,step), worldpos.z-diffthresh)).rgb*shadow2D(shadowtex1,vec3(worldpos.st+vec2(0,step), worldpos.z-diffthresh)).x;
				shadowcol += shadow2D(shadowcolor0,vec3(worldpos.st+vec2(0,-step), worldpos.z-diffthresh)).rgb*shadow2D(shadowtex1,vec3(worldpos.st+vec2(0,-step), worldpos.z-diffthresh)).x;
				shadowcol *= 0.2;
				#else
				shadowcol = shadow2D(shadowcolor0,vec3(worldpos.st, worldpos.z-diffthresh)).rgb*shadow2D(shadowtex1,vec3(worldpos.st, worldpos.z-diffthresh)).x;
				#endif
			#endif
		}
	}
	
	vec3 light = calcLightColor(light_m, light_d, light_n, light_r);
	vec3 ambient = calcLightColor(sky_m, sky_d, sky_n, sky_r);
	
	float torchmap = pow(lmcoord.s,2.2)*0.2 + pow(max(lmcoord.s-0.1,0.0)*1.11,16.0);
	float skymap = pow(lmcoord.t,2.2);
	vec3 torchlight = pow(torch_c,vec3(1.2-0.2*sqrt(sqrt(lmcoord.s))))*torchmap*8.0;
	
	ambient += vec3(1.15)*length(ambient)*sqrt(skymap)*(0.5+0.5*tB)*(1.0-eBS)*(1.0-rainStrength*0.8)*(0.025+0.975*sunVisibility);
	
	#ifdef RPSupport
	#if RPSFormat == 2
	specemissive = spec.b;
	torchlight += pow(albedo.rgb,vec3(2.2))*8.0*specemissive;
	#endif
	#endif
	
	float minlight = (4.0-3.0*eBS)/255.0;
	float lightmult = ((2.0+4.0*shading)*(1.0-eBS)+eBS)*(1.0-0.8*(1.0-sunVisibility)*rainStrength);
	
	vec3 scenelight = mix(ambient*skymap,light,max(vec3(shading),shadowcol)*NdotL*(1.0-0.9*rainStrength))*lightmult+minlight;
	vec3 finallight = (scenelight+torchlight+nightVision)*NdotU;
	
	if (heldItemId == 89 || heldItemId == 138 || heldItemId == 169){
		#ifdef BrightEmissive
		finallight += vec3(torchlight+nightVision)*NdotU*3.0;
		#endif
		#ifdef EmissiveRecolor
		float ec = clamp(pow(length(albedo.rgb),1.4),0,2.2);
		albedo.rgb = mix(albedo.rgb,clamp(ec*torch_c*0.25+ec*0.35,vec3(0),vec3(4.84)),lmcoord.s);
		#endif
	}

	albedo.rgb = pow(albedo.rgb,vec3(2.2));
	
	#ifdef DisableTexture
	albedo.rgb = vec3(0.4);
	#endif
	
	albedo.rgb = albedo.rgb/sqrt(1.0+albedo.rgb*albedo.rgb);
	albedo.rgb *= finallight;
	
	#ifdef Desaturation
	float ddesat = clamp(max(sqrt(sqrt(shading*NdotL)),skymap)*sunVisibility*(1-rainStrength*0.8)+lmcoord.s+sqrt(sqrt(specemissive)),0.15+0.05*skymap*(1.0-rainStrength),1.0);
	vec3 desat_c = mix(vec3(length(light_n))*sky_r,light_n,skymap*(1.0-rainStrength))*4.0;
	albedo.rgb = mix(dot(albedo.rgb,vec3(0.299, 0.587, 0.114))*desat_c,albedo.rgb,ddesat);
	#endif
	
	albedo.rgb = pow(albedo.rgb/MAX_COLOR_RANGE,vec3(1.0/2.2));
	
/* DRAWBUFFERS:1356 */

	gl_FragData[0] = vec4(albedo,pow(texture2D(texture,adjustedTexCoord).a,1.0/2.2));
	gl_FragData[1] = frag2;	
	gl_FragData[2] = vec4(lmcoord.t, 0.4, lmcoord.s, 1.0);
	gl_FragData[3] = vec4(spec,1.0);
}