#version 120

#define FXAA

#define About 0 //[0]

varying vec4 texcoord;
uniform sampler2D colortex0;

uniform float viewWidth;
uniform float viewHeight;

float luma(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

void main() {
	
	vec3 color = texture2D(colortex0,texcoord.xy).rgb;
	
	#ifdef FXAA
	//FXAA from http://horde3d.org/wiki/index.php5?title=Shading_Technique_-_FXAA
	float FXAA_LUMA_THRESOLD = 1.0/16.0;
	float FXAA_SPAN_MAX = 4.0;
	float FXAA_REDUCE_MUL = 1.0/4.0;
	float FXAA_REDUCE_MIN = 1.0/128.0;
	
	vec2 view = vec2(viewWidth,viewHeight);
	
	vec3 rgbNW = texture2D(colortex0,texcoord.xy+(vec2(-1.0,-1.0)/view)).rgb;
	vec3 rgbNE = texture2D(colortex0,texcoord.xy+(vec2(1.0,-1.0)/view)).rgb;
	vec3 rgbSW = texture2D(colortex0,texcoord.xy+(vec2(-1.0,1.0)/view)).rgb;
	vec3 rgbSE = texture2D(colortex0,texcoord.xy+(vec2(1.0,1.0)/view)).rgb;
	vec3 rgbM  = color;
	
	float lumaNW = luma(rgbNW);
	float lumaNE = luma(rgbNE);
	float lumaSW = luma(rgbSW);
	float lumaSE = luma(rgbSE);
	float lumaM  = luma(rgbM);
	
	float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
	float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));
	
	if (lumaMax - lumaMin > lumaMax * FXAA_LUMA_THRESOLD){
		vec2 dir = vec2(0.0);
		dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
		dir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));
		
		float dirReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) * (0.25 * FXAA_REDUCE_MUL),FXAA_REDUCE_MIN);
		
		float rcpDirMin = 1.0/(min(abs(dir.x), abs(dir.y)) + dirReduce);
		
		dir = clamp(dir*rcpDirMin,vec2(-FXAA_SPAN_MAX),vec2(FXAA_SPAN_MAX))/view;
		
		vec3 rgbA = 0.5 * (texture2D(colortex0, texcoord.xy + dir * (1.0/3.0 - 0.5)).xyz + texture2D(colortex0, texcoord.xy + dir * (2.0/3.0 - 0.5)).xyz);
		vec3 rgbB = rgbA * 0.5 + 0.25 * (texture2D(colortex0, texcoord.xy + dir * (0.0/3.0 - 0.5)).xyz + texture2D(colortex0, texcoord.xy + dir * (3.0/3.0 - 0.5)).xyz);
		float lumaB = luma(rgbB);

		if((lumaB < lumaMin) || (lumaB > lumaMax)){
				color=rgbA;
		}else{
				color=rgbB;
		}
		
	}
	#endif
	
	#ifdef About
	#endif
	
	gl_FragData[0] = vec4(color,1.0);

}
