#version 120

#define Bloom
#define LensFlare
//#define DirtyLens
#define Vignette

//#define DOF
//#define FogBlur
//#define MotionBlur

//#define AverageExposure

//#define ColorGrading								//Darkens color by maximal value and brightens color by minimal value.
//#define ColorGrading_LUT							//Shows lookup table. Color Process must be enabled first.

#define ColR1 1.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColG1 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColB1 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColS1 1.0									//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define ColM1 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColC1 1.0									//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#define ColR2 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColG2 1.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColB2 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColS2 1.0									//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define ColM2 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColC2 1.0									//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#define ColR3 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColG3 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColB3 1.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColS3 1.0									//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define ColM3 0.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColC3 1.0									//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#define ColR4 1.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColG4 1.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColB4 1.00									//[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define ColS4 1.0									//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define ColM4 0.0									//[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

//#define ColorAdjustment
#define Brightness 1.0 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define Saturation 1.0 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define Contrast 1.0 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#define Weather
#define WeatherOpacity 1.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00]

//#define WorldTimeAnimation

/*
FRAGDATA
0 raw solid
1 raw nonsolid
2 solid normals
3 nonsolid normals
4 solid matflag
5 nonsolid matflag
6 specular
7 rain

nonsolid : nonsolid block,water,hand

MATFLAG
.00 sky/sky
.10 none/water
.20 lava/reflectables
.30 metal/none
.40 foliage/hand
.50 emissive/blockindicator
.60 clear/none
.70 spidereye/none
1.0 basic/basic
*/

#define MAX_COLOR_RANGE 32.0

varying vec4 texcoord;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D colortex0;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
#if (defined DOF || defined FogBlur) && defined Weather
uniform sampler2D colortex7;
#endif
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
#ifdef DirtyLens
uniform sampler2D depthtex2;
#endif
uniform sampler2D noisetex;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
#ifdef MotionBlur
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;
#endif
uniform float rainStrength;
uniform ivec2 eyeBrightnessSmooth;
uniform float aspectRatio;
uniform float frameTime;
uniform float frameTimeCounter;
uniform float worldTime;
uniform int isEyeInWater;
uniform float centerDepthSmooth;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform float viewWidth;
uniform float viewHeight;

float eBS = eyeBrightnessSmooth.y/240.0;

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0;
#else
float frametime = frameTimeCounter;
#endif

float luma(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

vec2 getRefract(vec2 coord){
vec2 refract = vec2(cos(texcoord.y*32.0+frametime*4.0),sin(texcoord.x*32.0+frametime*4.0))*0.001;

vec2 newcoord = coord + refract*isEyeInWater;
float limit = float(newcoord.x < 0.0 || newcoord.x > 1.0 || newcoord.y < 0.0 || newcoord.y > 1.0);

return mix(newcoord,coord,limit);
}

vec3 BSLReinhard(vec3 color){
	vec3 x = color*3.2;
	return x/sqrt(1.0+x*x);
}

float getnoise(vec2 pos) {
return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f)+pos*100.0)) * 4378.5453f));
}

float dither4x4(vec2 pos)
{
	const int ditherPattern[16] = int[16](
		0, 8, 2, 10,
		12, 4, 14, 6,
		3, 11, 1, 9,
		15, 7, 13, 5);

    vec2 position = floor(mod(vec2(texcoord.s * viewWidth,texcoord.t * viewHeight), 4.0f));

	int dither = ditherPattern[int(position.x) + int(position.y) * 4];

	return float(dither) / 16.0f;
}

#include "lib/fragPos.glsl"
#include "lib/lightColors.glsl"
#include "lib/lensFlare.glsl"

void main() {
	
	vec2 newcoord = texcoord.xy;
	if (isEyeInWater > 0.9) newcoord = getRefract(texcoord.xy);
	vec3 color = pow(texture2D(colortex0, newcoord.st).rgb,vec3(2.2))*MAX_COLOR_RANGE;
	float matflag = texture2D(colortex4, texcoord.st).g;
	float wmatflag = texture2D(colortex5, texcoord.st).g;
	
	float land = float(matflag > 0.08);
	float hand = float(wmatflag > 0.38 && wmatflag < 0.42);
	float water = float(wmatflag > 0.08 && wmatflag < 0.12);
	
	vec3 blur = vec3(0.0);
	vec3 blur1 = vec3(0.0);
	
	#if defined Bloom || defined DOF || defined FogBlur
	const float bpow = 0.25;
	blur1 = pow(texture2D(colortex3,newcoord/pow(2.0,2.0) + vec2(0.0,0.0)).rgb,vec3(2.2))*pow(7.0,bpow);
	vec3 blur2 = pow(texture2D(colortex3,newcoord/pow(2.0,3.0) + vec2(0.3,0.0)).rgb,vec3(2.2))*pow(6.0,bpow);
	vec3 blur3 = pow(texture2D(colortex3,newcoord/pow(2.0,4.0) + vec2(0.0,0.3)).rgb,vec3(2.2))*pow(5.0,bpow);
	vec3 blur4 = pow(texture2D(colortex3,newcoord/pow(2.0,5.0) + vec2(0.1,0.3)).rgb,vec3(2.2))*pow(4.0,bpow);
	vec3 blur5 = pow(texture2D(colortex3,newcoord/pow(2.0,6.0) + vec2(0.2,0.3)).rgb,vec3(2.2))*pow(3.0,bpow);
	vec3 blur6 = pow(texture2D(colortex3,newcoord/pow(2.0,7.0) + vec2(0.3,0.3)).rgb,vec3(2.2))*pow(2.0,bpow);
	
	blur = (blur1 + blur2 + blur3 + blur4 + blur5 + blur6)*MAX_COLOR_RANGE;
	#endif
	
	//DoF
	float isdof = 0.0;
	#if defined DOF || defined FogBlur
	float pixeldepth = texture2D(depthtex0,newcoord.xy).x;
	vec4 fragpos = getFragPos(newcoord,pixeldepth);
	vec4 worldpos = getWorldPos(fragpos);
	worldpos /= worldpos.w;
	
	float pcoc = 0;
	float fog = max((length(worldpos))/1024.0,0.0);
	
	vec3 blurcol = clamp(mix(blur1*MAX_COLOR_RANGE/1.75,blur/8.606,rainStrength*pow(eBS,2.2))*0.44,vec3(0.0),vec3(2.2));
	float fbmix = 0.0;
	float nbmix = 0.0;
	
	#ifdef FogBlur
	fbmix = clamp(fog*8.0*mix(1.0+rainStrength,4.0,isEyeInWater),0.0,1.0)*(mix(land,1.0,isEyeInWater)*(1-rainStrength)+rainStrength);
	if (fbmix > 0.001) color = mix(color,blurcol,fbmix);
	#endif
	
	float z = texture2D(depthtex1, newcoord.st).r;
	float focus = centerDepthSmooth;
	pcoc = clamp(abs(z-focus)/(6.0*(1.0+0.5*rainStrength*eBS))-0.1/1280,0,0.00625);
	//pcoc -= hand*0.0005;
	
	pcoc = pcoc*(1-hand);
	
	#ifdef DOF
	nbmix = pcoc/(0.00625);
	if (nbmix > 0.001) color = mix(color,blurcol,nbmix);
	#endif
	
	#ifdef Weather
	if (hand < 0.9){
		vec4 rain = texture2D(colortex7,newcoord.xy);
		color += rain.rgb*rain.a*(fbmix*(1.0-nbmix));
	}
	#endif
	
	isdof = min(max(fbmix,nbmix)*2.0,1.0);
	#endif
	
	//Motion Blur
	#ifdef MotionBlur
	float motionblur  = texture2D(depthtex1, newcoord.st).x;
	vec3 mblur = pow(texture2D(colortex0,newcoord.st).rgb,vec3(2.2))*MAX_COLOR_RANGE;
	float mbwg = 1.0;
	float mbm = 0.0;
	vec2 pixel = 2.0/vec2(viewWidth,viewHeight);
	
	vec4 currentPosition = vec4(newcoord.x * 2.0 - 1.0, newcoord.y * 2.0 - 1.0, 2.0 * motionblur - 1.0, 1.0);
	
	vec4 fragposition = gbufferProjectionInverse * currentPosition;
	fragposition = gbufferModelViewInverse * fragposition;
	fragposition /= fragposition.w;
	fragposition.xyz += cameraPosition;
	
	vec4 previousPosition = fragposition;
	previousPosition.xyz -= previousCameraPosition;
	previousPosition = gbufferPreviousModelView * previousPosition;
	previousPosition = gbufferPreviousProjection * previousPosition;
	previousPosition /= previousPosition.w;

	vec2 velocity = (currentPosition - previousPosition).xy;
	velocity = velocity/(1.0+length(velocity))*0.001/frameTime;
	
	vec2 coord = newcoord.st-velocity*4.0;
	for (int i = 0; i < 9; ++i, coord += velocity) {
		if (hand < 0.9){
			vec2 coordb = clamp(coord,pixel,1.0-pixel);
			vec3 temp = pow(texture2D(colortex0, coordb).rgb,vec3(2.2))*MAX_COLOR_RANGE;
			mblur += temp;
			mbwg += 1.0;
		}
	}
	mblur /= mbwg;
	mblur = mix(color,mblur,mbwg/9);

	color = mix(mblur,color,isdof);
	#endif
	
	//Bloom
	#ifdef Bloom
		#ifdef DirtyLens
		float bAR = 1.777777777777778;
		vec3 dirt = texture2D(depthtex2,(texcoord.xy-0.5)/vec2(max(bAR/aspectRatio,1.0),max(aspectRatio/bAR,1.0))+0.5).rgb*32;
		blur = (blur1 + blur2 + blur3*(1+dirt*pow(length(blur3),1.00)) + blur4*(1+2*dirt*pow(length(blur4),1.05)) + blur5*(1+3*dirt*pow(length(blur5),1.10)) + blur6*(1+4*dirt*pow(length(blur6),1.15)))*MAX_COLOR_RANGE;
		#endif
	color = mix(color,blur,0.02);
	#else
	color *= 1.4;
	#endif
	
	//Average Exposure
	#ifdef AverageExposure
	float ae = 8.0*luma(pow(texture2DLod(colortex0, vec2(0.5),8.5).rgb,vec3(2.2))*MAX_COLOR_RANGE);
	color *= 0.5+0.5/sqrt(ae);
	#endif
	
	#ifdef ColorGrading
		#ifdef ColorGrading_LUT
		float pw = 1.0/viewWidth;
		float ph = 1.0/viewHeight;
		if (texcoord.x < 256.0*pw && texcoord.y > 1-16*ph){
			color *= 0;
			color.r = (texcoord.x*viewWidth/16-floor(texcoord.x*viewWidth/16));
			color.g = (1-texcoord.y)*viewHeight/16;
			color.b = floor(texcoord.x*viewWidth/16)/16;
			color = pow(color,vec3(2.2));
		}
		#endif
	
	vec3 cgcol = (pow(color.r,ColC1)*pow(vec3(ColR1,ColG1,ColB1),vec3(2.2))+pow(color.g,ColC2)*pow(vec3(ColR2,ColG2,ColB2),vec3(2.2))+pow(color.b,ColC3)*pow(vec3(ColR3,ColG3,ColB3),vec3(2.2)));
	vec3 cgmin = pow(vec3(ColM1,ColM2,ColM3),vec3(2.2));
	color = (cgcol*(1-cgmin)+cgmin)*vec3(ColS1,ColS2,ColS3);
	
	vec3 cgtint = pow(vec3(ColR4,ColG4,ColB4),vec3(2.2))*luma(color)*ColS4;
	color = mix(color,cgtint,ColM4);
	#endif
	
	//Tonemapping
	color = BSLReinhard(color);
	
	//Vignette
	#ifdef Vignette
	color *= 1.0-length(texcoord.xy-0.5)*(1-luma(color*color));
	#endif
	
	//Lens Flare
	#ifdef LensFlare
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	tpos.xy = tpos.xy/tpos.z;
	vec2 lightPos = tpos.xy*0.5;
	float truepos = sunPosition.z/abs(sunPosition.z);
	float visiblesun = pow(texture2D(colortex0,1.0/vec2(viewWidth,viewHeight)).a,2.0)*0.75;
	
	if (isEyeInWater < 0.9 && visiblesun > 0.001) color = mix(color,vec3(1.0),genLensFlare(lightPos,truepos,visiblesun));
	#endif
	
	//Final Color Adjustment
	#ifdef ColorAdjustment
	color*= Brightness;
	float gray = 0.0;
	if (Saturation > 1.0) gray = length(color/3);
	else gray = luma(color);
	color = color*Saturation-gray*(Saturation-1.0);
	color = clamp(pow(color,vec3(1.0/2.2)),vec3(0.0),vec3(1.0));
	color = pow(clamp((color-0.5)*Contrast+0.5,vec3(0.0),vec3(1.0)),vec3(2.2));
	#endif
	
	color = pow(color,vec3(1.0/2.2)) +  (texture2D(noisetex,texcoord.xy*vec2(aspectRatio,1.0)+frameTimeCounter).rgb*2.0-1.0)/64.0;
	
/* DRAWBUFFERS:0 */
	gl_FragData[0] = vec4(color,1.0);

}
