#version 120

#define AO
#define EmissiveRecolor
#define LightShaft 1 //[0 1 2]
#define Fog
//#define RPSupport
#define RPSFormat 0 //[0 1 2]
#define ShadowColor
#define WaterFog
#define WaterRefraction
//#define WorldTimeAnimation

const int shadowMapResolution = 2048; //[1024 2048 4096 8192]

#define SHADOW_MAP_BIAS 0.90
#define MAX_COLOR_RANGE 32.0
const bool colortex0MipmapEnabled = true;

varying vec3 lightVector;
varying vec3 upVec;
varying vec3 sunVec;
varying vec3 moonVec;
varying float sunVisibility;
varying float moonVisibility;
varying float handRecolor;

varying vec4 texcoord;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
#ifdef RPSupport
uniform sampler2D colortex6;
#endif
uniform sampler2D depthtex0;
#if LightShaft == 2
uniform sampler2D depthtex1;
#endif
uniform sampler2D noisetex;

#if defined RPSupport || LightShaft == 2
uniform sampler2DShadow shadowtex0;
#ifdef ShadowColor
uniform sampler2DShadow shadowtex1;
uniform sampler2DShadow shadowcolor;
#endif
#endif

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform float rainStrength;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;
uniform vec3 sunPosition;
uniform float viewWidth;
uniform float viewHeight;
uniform float far;
uniform float near;
uniform float aspectRatio;

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;

#ifdef WorldTimeAnimation
float frametime = float(worldTime)/20.0;
#else
float frametime = frameTimeCounter;
#endif

float nolight = 1.0-(clamp((time-12000.0)/500.0,0.0,1.0)-clamp((time-13500.0)/500.0,0.0,1.0) + clamp((time-22500.0)/500.0,0.0,1.0)-clamp((time-23500.0)/500.0,0.0,1.0));

float luma(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

vec3 calcLightColor(vec3 morning, vec3 day, vec3 night, vec3 rain){
	vec3 c = mix(night,mix(morning,day,pow(tB,0.75)),sunVisibility);
	return mix(c,length(c)*rain,rainStrength);
}

float Blinn_Phong(vec3 ppos, vec3 lightDir, vec3 surfaceNormal, float gloss, float visibility)  {
	vec3 viewDirection = normalize(-ppos);
	vec3 halfAngle = normalize(lightDir + viewDirection);
	float blinnTerm = dot(surfaceNormal, halfAngle);
	float pi = 3.1415927;
	float n =  pow(2.0,gloss);
	return pow(blinnTerm, n )*gloss*visibility;
}

float waterH(vec3 pos) {
	float noise = 0;
	noise+= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5-pos.y*0.2)/1024.0* 1.1).r*1.0;
	noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.2)/1024.0* 1.5).r*0.8;
	noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.2)/1024.0* 2.5).r*0.6;
	noise+= texture2D(noisetex,(pos.xz-vec2(frametime)*0.5-pos.y*0.2)/1024.0* 5.0).r*0.4;
	noise-= texture2D(noisetex,(pos.xz+vec2(frametime)*0.5+pos.y*0.2)/1024.0* 8.0).r*0.2;

	noise /= pow(max(length(pos),4.0),0.35);
	return noise;
}

vec2 getRefract(vec2 coord, vec3 posxz){
	float deltaPos = 0.1;
	float h0 = waterH(posxz);
	float h1 = waterH(posxz + vec3(deltaPos,0.0,0.0));
	float h2 = waterH(posxz + vec3(-deltaPos,0.0,0.0));
	float h3 = waterH(posxz + vec3(0.0,0.0,deltaPos));
	float h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos));

	float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	float yDelta = ((h3-h0)+(h0-h4))/deltaPos;

	vec2 newcoord = coord + vec2(xDelta,yDelta)*0.01;
	float water = texture2D(colortex5, newcoord).g;
	water = float(water > 0.08 && water < 0.12);
	float limit = max(1.0-water,float(newcoord.x < 0.0 || newcoord.x > 1.0 || newcoord.y < 0.0 || newcoord.y > 1.0));

	return mix(newcoord,coord,limit);
}

float ld(float depth) {
   return (2.0 * near) / (far + near - depth * (far - near));
}

float dither4x4(vec2 pos)
{
	const int ditherPattern[16] = int[16](
		0, 8, 2, 10,
		12, 4, 14, 6,
		3, 11, 1, 9,
		15, 7, 13, 5);

    vec2 position = floor(mod(vec2(texcoord.s * viewWidth,texcoord.t * viewHeight), 4.0f));

	int dither = ditherPattern[int(position.x) + int(position.y) * 4];

	return float(dither) / 16.0f;
}

#if LightShaft == 1
vec2 getGRCoord(vec2 coord, vec2 dcoord, float str, float dither){
return coord - dcoord*dither*str;
}
#endif

#include "lib/fragPos.glsl"
#include "lib/shadowPos.glsl"
#ifdef RPSupport
#include "lib/shadows.glsl"
#endif
#include "lib/lightColors.glsl"
#include "lib/torchColor.glsl"
#include "lib/waterColor.glsl"
#include "lib/fogCalc.glsl"
#include "lib/ambientOcclusion.glsl"

#if LightShaft == 2
float distx(float dist){
	return (far * (dist - near)) / (dist * (far - near));
}

float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

vec4 getShadowSpace(float shadowdepth, vec2 texcoord){
	vec4 fragpos = getFragPos(texcoord.xy,shadowdepth);

	vec4 wpos = getWorldPos(fragpos);
	wpos = getShadowPos(wpos);
	
	float distb = sqrt(wpos.x * wpos.x + wpos.y * wpos.y);
	float distortFactor = 1.0 - SHADOW_MAP_BIAS + distb * SHADOW_MAP_BIAS;
	wpos = distortShadow(wpos,distortFactor);
	
	return wpos;
}

vec3 getVolumetricRays(float pixeldepth, vec3 color, float alpha, float water, float dither) {
	vec3 vl = vec3(0.0);
	float samples = 8.0;
	float slength = 2.0-1.0*eBS; //2.25-1.25 4.0-3.0 16.0-15.0
	vec3 watercol = water_c*cmult/water_a;

	float maxDist = 128.0;
	float minDist = 1.0;
	vec4 worldposition = vec4(0.0);
	
	float pixeldepthb = texture2D(depthtex0,texcoord.xy).r;
	float w = 0.0;
	
	for (minDist; minDist < maxDist; ) {
		minDist += dither*slength;
		if (getDepth(pixeldepth) < minDist || (getDepth(pixeldepthb) < minDist && alpha > 0.99)){
			break;
		}
		worldposition = getShadowSpace(distx(minDist),texcoord.st);
		if (length(worldposition.xy*2.0-1.0)<1.0){
		vec3 sample = vec3(shadow2D(shadowtex0, vec3(worldposition.rg, worldposition.b)).z);
		vec3 colsample = vec3(0.0);
		#ifdef ShadowColor
		float testsample = shadow2D(shadowtex1, vec3(worldposition.rg, worldposition.b)).z;
		if (testsample-sample.r > 0.9) colsample = shadow2D(shadowcolor, vec3(worldposition.rg, worldposition.b)).rgb;
		#endif
		sample = pow(max(sample,colsample),vec3(2.2));
		if (getDepth(pixeldepthb) < minDist) sample *= mix(mix(vec3(1.0),watercol,water*(1.0-isEyeInWater)),color,pow(alpha,1.0/2.2));
		else sample *= mix(vec3(1.0),watercol,isEyeInWater);
		vl += sample;
		}
		else{
		vl += 1.0;
		}
		minDist = minDist + slength*(1.0-dither);
		slength *= 1.4+0.6*eBS; //1.7+0.3 1.4+0.6 1.0+1.0
		w += 1.0;
	}
	vl = vl/(8.0+sqrt(w));
	
	return vec3(vl);
}
#endif

void main() {
	
	
	vec3 color = pow(texture2D(colortex0, texcoord.st).rgb,vec3(2.2))*MAX_COLOR_RANGE;
	vec3 colorb = vec3(0.0);
	vec3 aux = texture2D(colortex5, texcoord.st).rgb;
	float ao = 1.0;
	float spec = texture2D(colortex0, texcoord.st).a;
	float specemissive = 0.0;
	vec3 gr = vec3(0.0);
	
	float dither = dither4x4(texcoord.xy);
	
	vec3 light = calcLightColor(light_m, light_d, light_n, light_r);
	vec3 ambient = calcLightColor(sky_m, sky_d, sky_n, sky_r);
	
	float skymap = pow(aux.r,2.2);
	float matflag = aux.g;
	float torchmap = pow(aux.b,2.2)*0.2 + pow(max(aux.b-0.1,0.0)*1.11,16.0)*4.0;
	float alpha = texture2D(colortex1,texcoord.xy).a;
	
	float translucent = float(matflag > 0.05);
	float water = float(matflag > 0.08 && matflag < 0.12);
	float hand = float(matflag > 0.38 && matflag < 0.42);	
	
	float pixeldepth = texture2D(depthtex0,texcoord.xy).x;
	
	vec4 fragpos = getFragPos(texcoord.xy,pixeldepth);
	
	if (translucent > 0.9 && alpha > 0.0001) {
		colorb = pow(max(texture2D(colortex1, texcoord.st).rgb,vec3(1.0/255.0)),vec3(2.2))*MAX_COLOR_RANGE;
		vec3 normal = texture2D(colortex3, texcoord.st).rgb*2.0-1.0;
		
		vec4 worldpos = getWorldPos(fragpos);
		
		#ifdef WaterRefraction
		if (water > 0.9 && isEyeInWater < 0.9){
			vec2 newcoord = getRefract(texcoord.xy,worldpos.xyz+cameraPosition.xyz);
			color = pow(texture2D(colortex0, newcoord).rgb,vec3(2.2))*MAX_COLOR_RANGE;
			colorb = pow(max(texture2D(colortex1, newcoord.st).rgb,vec3(1.0/255.0)),vec3(2.2))*MAX_COLOR_RANGE;
		}
		#endif
		
		#ifndef WaterV
		if(water > 0.9) colorb *= cmult*cmult;
		#endif
		
		color *= mix(vec3(1.0),sqrt(colorb),alpha*alpha);
		
		float absorb = float((water > 0.9 && isEyeInWater < 0.9) || (water < 0.9 && isEyeInWater > 0.9));
		vec3 uw_tint = mix(vec3(1.0),pow(water_c,vec3((1.0-skymap)*2.0))*skymap,absorb*max(1.0-pow(aux.b,2.2),0.0));
		
		#ifdef AO
		#ifndef AOTranslucent
		if(alpha > 0.98){
		#endif
		ao = dbao(depthtex0, dither);
		#ifndef AOTranslucent
		}
		#endif
		#endif
		
		colorb *= ao*uw_tint;
		
		#ifdef WaterV
		if(water > 0.9){
			color*= (1.0+colorb*water_a*4.0);
			alpha*= sqrt(water_a);
		}
		#endif
		
		color = color*(1.0-alpha)+colorb;
		
		#ifdef Fog
		if (isEyeInWater < 0.9) color = calcFog(color, light, fragpos.xyz);
		#endif
		
		#ifdef RPSupport
		float NdotL = max(dot(normal, lightVector)*1.05-0.05,0.0);
		float shading = getShadows(shadowtex0, worldpos, NdotL, 0.0, dither);
		shading *= max(NdotL*nolight,0.0);
		
		float smoothness = texture2D(colortex6,texcoord.xy).r;
		if (water < 0.9){
			spec = Blinn_Phong(fragpos.xyz,lightVector,normal,1.0+(11.0+moonVisibility)*smoothness,shading);
			spec = spec/(1.0+spec);
			}
		#endif
	}
	
	#if LightShaft == 1
	{
		vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
		tpos.xy = tpos.xy/tpos.z;
		vec2 lightPos = tpos.xy*0.5+0.5;
		float truepos = sunPosition.z/abs(sunPosition.z);
		
		vec2 deltacoord = texcoord.xy-lightPos;
		vec2 grcoord = texcoord.xy + deltacoord*0.1;
		
		float grfade = pow(max(1.0-length(deltacoord*vec2(1.0,1.0/aspectRatio))*2.0,0.0),2.2);
		float centerdist = 0.25 + 0.75*max(1.0-length(tpos.xy*vec2(aspectRatio,1.0)*0.5),0.0);
		float grw = 0.0;
		
		if (grfade > 0.001 && (truepos < 0.0 && sunVisibility > 0.001 || truepos > 0.0 && moonVisibility > 0.001)){
			for (int i = 0; i < 3; i++) {
			float samplea = texture2D(colortex4,getGRCoord(grcoord,deltacoord,0.25,dither)).g;
			vec4 sampleb = texture2D(colortex1,getGRCoord(grcoord,deltacoord,0.25,dither));
			if(isEyeInWater > 0.9){
				float samplec = texture2D(colortex5,getGRCoord(grcoord,deltacoord,0.25,dither)).g;
				if (samplec < 0.12){
					sampleb.rgb = water_c;
					sampleb.a = water_a;
				}
			}
			sampleb.rgb = max(normalize(sampleb.rgb*MAX_COLOR_RANGE),vec3(0.0));
			gr += float(samplea < 0.02)*mix(vec3(1.0),vec3(sampleb.rgb),pow(sampleb.a,0.2))*(1.0-sampleb.a)*centerdist;
			grcoord -= deltacoord*0.25;
			}
		}
		
		gr /= 3.0;
	}
	#endif
	
	#if LightShaft == 2
	gr = getVolumetricRays(texture2D(depthtex1,texcoord.xy).x,sqrt(colorb),alpha,water,dither)*nolight;
	#endif
	
/* DRAWBUFFERS:01 */
	
	gl_FragData[0] = vec4(pow(color/MAX_COLOR_RANGE,vec3(1.0/2.2)),spec);
	gl_FragData[1] = vec4(gr,0.0);

}
