/*
 * Decompiled with CFR 0.152.
 */
package com.tom.web.message;

import com.tom.util.BaseUtil;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class MessageHelper {
    private static Properties prop = null;
    private static String lang = "zh_CN";

    static {
        MessageHelper.loadMessage(lang);
    }

    public static void setLang(String lan) {
        lang = lan;
        MessageHelper.loadMessage(lang);
    }

    public static String getLang() {
        return lang;
    }

    public static void loadMessage(String lang) {
        if (BaseUtil.isEmpty(lang)) {
            lang = "zh_CN";
        }
        prop = new Properties();
        try {
            prop.load(MessageHelper.class.getResourceAsStream("message_" + lang + ".properties"));
            prop.load(MessageHelper.class.getResourceAsStream("message_plus_" + lang + ".properties"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bfb\u53d6\u56fd\u9645\u5316\u6d88\u606f\u6587\u4ef6\u53d1\u751f\u9519\u8bef," + e.getMessage());
        }
    }

    public static String getMessage(String key) {
        String message = prop == null ? "" : (String)prop.get(key);
        return message;
    }

    public static String getMessages(String separator, String ... keys) {
        if (keys != null) {
            ArrayList<String> list = new ArrayList<String>();
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                list.add(MessageHelper.getMessage(key));
                ++n2;
            }
            return StringUtils.join((Object[])list.toArray(), (String)separator);
        }
        return null;
    }

    public static void main(String ... s) {
        System.out.println(MessageHelper.getMessage("system.version"));
    }
}

