/*
 * Decompiled with CFR 0.152.
 */
package com.tom.web.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.core.NamedThreadLocal;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ExecuteTimeInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = Logger.getLogger(ExecuteTimeInterceptor.class);
    private NamedThreadLocal<Long> startTimeThreadLocal = new NamedThreadLocal("StopWatch-StartTime");

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        long beginTime = System.currentTimeMillis();
        this.startTimeThreadLocal.set((Object)beginTime);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        long beginTime;
        long endTime = System.currentTimeMillis();
        long consumeTime = endTime - (beginTime = ((Long)this.startTimeThreadLocal.get()).longValue());
        if (consumeTime > 5000L) {
            logger.warn((Object)String.format("%s cost %d millis", request.getRequestURI(), consumeTime));
        }
    }
}

