/*
 * Decompiled with CFR 0.152.
 */
package com.tom.util;

import com.thoughtworks.xstream.XStream;
import com.tom.model.ModelHelper;
import com.tom.model.paper.Option;
import com.tom.model.paper.QBlank;
import com.tom.model.paper.Question;
import com.tom.model.paper.QuestionBlankFill;
import com.tom.model.paper.QuestionEssay;
import com.tom.model.paper.QuestionJudgment;
import com.tom.model.paper.QuestionMultipleChoice;
import com.tom.model.paper.QuestionSingleChoice;
import com.tom.util.BaseUtil;
import com.tom.util.TomException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class QuestionImportTxtHelper {
    private static Logger logger = Logger.getLogger(QuestionImportTxtHelper.class);

    public static List<Map<String, Object>> QuestionConverteFromTxt(List<String> lines) throws TomException {
        if (lines == null || lines.size() < 1) {
            throw new TomException(-1, "\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            int lineflag = 0;
            HashMap<String, Object> mapQuestion = new HashMap<String, Object>();
            for (String line : lines) {
                if (line.startsWith(ModelHelper.FLAG_CONTENT[0]) || line.startsWith(ModelHelper.FLAG_CONTENT[1])) {
                    mapQuestion.put("content", line.substring(line.indexOf("]") + 1));
                    lineflag = 1;
                } else if (line.startsWith(ModelHelper.FLAG_TYPE[0]) || line.startsWith(ModelHelper.FLAG_TYPE[1])) {
                    String _type = line.substring(line.lastIndexOf("]") + 1);
                    if (ModelHelper.FLAG_TYPE_SINGLECHOICE[0].equals(_type) || ModelHelper.FLAG_TYPE_SINGLECHOICE[1].equals(_type)) {
                        _type = "1";
                    } else if (ModelHelper.FLAG_TYPE_MULTIPLECHOICE[0].equals(_type) || ModelHelper.FLAG_TYPE_MULTIPLECHOICE[1].equals(_type)) {
                        _type = "2";
                    } else if (ModelHelper.FLAG_TYPE_JUDGMENT[0].equals(_type) || ModelHelper.FLAG_TYPE_JUDGMENT[1].equals(_type)) {
                        _type = "3";
                    } else if (ModelHelper.FLAG_TYPE_BLANKFILL[0].equals(_type) || ModelHelper.FLAG_TYPE_BLANKFILL[1].equals(_type)) {
                        _type = "4";
                    } else if (ModelHelper.FLAG_TYPE_ESSAY[0].equals(_type) || ModelHelper.FLAG_TYPE_ESSAY[1].equals(_type)) {
                        _type = "5";
                    }
                    mapQuestion.put("type", _type);
                } else if (line.startsWith(ModelHelper.FLAG_OPTIONS[0]) || line.startsWith(ModelHelper.FLAG_OPTIONS[1])) {
                    mapQuestion.put("options", line.substring(line.lastIndexOf("]") + 1));
                } else if (line.startsWith(ModelHelper.FLAG_KEY[0]) || line.startsWith(ModelHelper.FLAG_KEY[1])) {
                    mapQuestion.put("key", line.substring(line.lastIndexOf("]") + 1));
                } else if (line.startsWith(ModelHelper.FLAG_RESOLVE[0]) || line.startsWith(ModelHelper.FLAG_RESOLVE[1])) {
                    mapQuestion.put("resolve", line.substring(line.lastIndexOf("]") + 1));
                    lineflag = 2;
                }
                if (lineflag != 2) continue;
                lineflag = 0;
                list.add(QuestionImportTxtHelper.genarateQuestionRecord(mapQuestion));
            }
        }
        catch (Exception e) {
            throw new TomException(-9, "\u6587\u4ef6\u683c\u5f0f\u5316\u9519\u8bef");
        }
        return list;
    }

    private static Map<String, Object> genarateQuestionRecord(Map<String, Object> data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String type = String.valueOf(data.get("type"));
        String content = String.valueOf(data.get("content"));
        map.put("q_type", type);
        map.put("q_level", "3");
        map.put("q_from", "");
        map.put("q_status", "1");
        if ("4".equals(type)) {
            content = content.replace("[BLANK", "[BlankArea");
        }
        map.put("q_content", content);
        map.put("q_key", data.get("key"));
        map.put("q_resolve", data.get("resolve"));
        map.put("options", data.get("options"));
        return map;
    }

    public static String genarateQuestionObject(Map<String, Object> data) {
        Question question;
        String _type = String.valueOf(data.get("q_type"));
        String _content = String.valueOf(data.get("q_content"));
        String _id = String.valueOf(data.get("q_id"));
        String _key = String.valueOf(data.get("q_key"));
        String _resolve = String.valueOf(data.get("q_resolve"));
        String _options = String.valueOf(data.get("options"));
        Question object = null;
        if ("1".equals(_type)) {
            question = new QuestionSingleChoice();
            question.setId(_id);
            question.setContent(_content);
            question.setKey(_key);
            ((QuestionSingleChoice)question).setOptions(QuestionImportTxtHelper.formatOptions(_options));
            question.setExt(_resolve);
            object = question;
        } else if ("2".equals(_type)) {
            question = new QuestionMultipleChoice();
            question.setId(_id);
            question.setContent(_content);
            question.setKey(_key);
            ((QuestionMultipleChoice)question).setOptions(QuestionImportTxtHelper.formatOptions(_options));
            question.setExt(_resolve);
            object = question;
        } else if ("3".equals(_type)) {
            question = new QuestionJudgment();
            question.setId(_id);
            question.setContent(_content);
            String _ckey = "";
            _ckey = ModelHelper.FLAG_VAL_JUDGMENT_YES[0].equals(_key) || ModelHelper.FLAG_VAL_JUDGMENT_YES[1].equals(_key) ? "Y" : "N";
            question.setKey(_ckey);
            question.setExt(_resolve);
            object = question;
        } else if ("4".equals(_type)) {
            question = new QuestionBlankFill();
            question.setId(_id);
            question.setContent(_content.replace("[BLANK", "[BlankArea"));
            question.setKey("");
            ((QuestionBlankFill)question).setBlanks(QuestionImportTxtHelper.formatBlanks(_key));
            ((QuestionBlankFill)question).setComplex(false);
            question.setExt(_resolve);
            object = question;
        } else if ("5".equals(_type)) {
            question = new QuestionEssay();
            question.setId(_id);
            question.setContent(_content);
            question.setKey(_key);
            question.setExt(_resolve);
            object = question;
        }
        XStream xstream = new XStream();
        try {
            return xstream.toXML((Object)object);
        }
        catch (Exception e) {
            logger.error((Object)("\u6784\u5efa\u5bf9\u8c61q_data\u65f6\u53d1\u751f\u5f02\u5e38:" + e.getMessage()));
            return "";
        }
    }

    private static List<Option> formatOptions(String source) {
        if (BaseUtil.isEmpty(source)) {
            return null;
        }
        ArrayList<Option> list = new ArrayList<Option>();
        Pattern pattern = Pattern.compile("\\{[a-zA-Z].+?}");
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            String soption = matcher.group();
            try {
                String _opt = soption.substring(1, soption.length() - 1);
                String _alisa = _opt.substring(0, 1);
                String _text = _opt.substring(2);
                list.add(new Option(_alisa, _text));
            }
            catch (Exception e) {
                logger.error((Object)("\u6279\u91cf\u5bfc\u5165\uff0c\u683c\u5f0f\u5316\u9009\u62e9\u9879\u65f6\u53d1\u751f\u4e00\u4e2a\u5f02\u5e38\uff0c\u5373\u5c06\u5ffd\u7565\u672c\u884c\u6570\u636e\uff0c\u5f53\u524d\u8fd9\u6761\u6570\u636e\u4e0d\u5408\u6cd5\uff0c" + source));
            }
        }
        return list;
    }

    public static List<QBlank> formatBlanks(String source) {
        if (BaseUtil.isEmpty(source)) {
            return null;
        }
        ArrayList<QBlank> list = new ArrayList<QBlank>();
        Pattern pattern = Pattern.compile("\\{BLANK.+?}");
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            String sblank = matcher.group();
            try {
                String _blk = sblank.substring(1, sblank.length() - 1);
                String[] _arrblk = _blk.replace("\uff1a", ":").split(":");
                String _name = _arrblk[0];
                String _value = _arrblk[1];
                String _sbid = _name.replace("BLANK", "");
                QBlank blank = new QBlank(BaseUtil.getInt(_sbid), _name, _value);
                list.add(blank);
            }
            catch (Exception e) {
                logger.error((Object)("\u6279\u91cf\u5bfc\u5165\uff0c\u683c\u5f0f\u5316\u7a7a\u683c\u9879\u65f6\u53d1\u751f\u4e00\u4e2a\u5f02\u5e38\uff0c\u5373\u5c06\u5ffd\u7565\u672c\u884c\u6570\u636e\uff0c\u5f53\u524d\u8fd9\u6761\u6570\u636e\u4e0d\u5408\u6cd5\uff0c" + source));
            }
        }
        return list;
    }
}

