/*
 * Decompiled with CFR 0.152.
 */
package com.tom.util;

import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.rtf.RtfWriter2;
import com.lowagie.text.rtf.field.RtfPageNumber;
import com.lowagie.text.rtf.headerfooter.RtfHeaderFooter;
import com.tom.model.paper.Option;
import com.tom.model.paper.Paper;
import com.tom.model.paper.PaperSection;
import com.tom.model.paper.Question;
import com.tom.model.paper.QuestionMultipleChoice;
import com.tom.model.paper.QuestionSingleChoice;
import com.tom.util.BaseUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class OfficeToolWord {
    private static String TECH_INFO = "";
    private static String FOOT_INFO = "";

    private void makeWordDocument(String path, String WTITLE) throws DocumentException, IOException {
        Document document = new Document(PageSize.A4);
        RtfWriter2.getInstance((Document)document, (OutputStream)new FileOutputStream(path));
        document.open();
        BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
        Font titleFont = new Font(bfChinese, 14.0f, 1);
        Font subTitleFont = new Font(bfChinese, 11.0f, 1);
        Font contextFont = new Font(bfChinese, 10.0f, 0);
        Font headerFooterFont = new Font(bfChinese, 9.0f, 0);
        Table header = new Table(2);
        header.setBorder(0);
        header.setWidth(100.0f);
        Paragraph address = new Paragraph(TECH_INFO);
        address.setFont(headerFooterFont);
        Cell cell01 = new Cell((Element)address);
        cell01.setBorder(0);
        header.addCell(cell01);
        Paragraph date = new Paragraph("\u751f\u6210\u65e5\u671f: " + new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        date.setAlignment(2);
        date.setFont(headerFooterFont);
        cell01 = new Cell((Element)date);
        cell01.setBorder(0);
        header.addCell(cell01);
        document.setHeader((HeaderFooter)new RtfHeaderFooter((Element)header));
        Table footer = new Table(2);
        footer.setBorder(0);
        footer.setWidth(100.0f);
        Paragraph company = new Paragraph(FOOT_INFO);
        company.setFont(headerFooterFont);
        Cell cell02 = new Cell((Element)company);
        cell02.setBorder(0);
        footer.addCell(cell02);
        Paragraph pageNumber = new Paragraph("\u7b2c ");
        pageNumber.add((Object)new RtfPageNumber());
        pageNumber.add((Object)new Chunk(" \u9875"));
        pageNumber.setAlignment(2);
        pageNumber.setFont(headerFooterFont);
        cell02 = new Cell((Element)pageNumber);
        cell02.setBorder(0);
        footer.addCell(cell02);
        document.setFooter((HeaderFooter)new RtfHeaderFooter((Element)footer));
        Paragraph title = new Paragraph(WTITLE);
        title.setAlignment(1);
        title.setFont(titleFont);
        document.add((Element)title);
        int i = 0;
        while (i < 5) {
            Paragraph subTitle = new Paragraph(String.valueOf(i + 1) + "\u3001\u6807\u9898" + (i + 1));
            subTitle.setFont(subTitleFont);
            subTitle.setSpacingBefore(10.0f);
            subTitle.setFirstLineIndent(0.0f);
            document.add((Element)subTitle);
            int j = 0;
            while (j < 3) {
                String contextString = String.valueOf(j + 1) + "." + "iText\u662f\u4e00\u4e2a\u80fd\u591f\u5feb\u901f\u4ea7\u751fPDF\u6587\u4ef6\u7684java\u7c7b\u5e93\u3002iText\u7684java\u7c7b\u5bf9\u4e8e\u90a3\u4e9b\u8981\u4ea7\u751f\u5305\u542b\u6587\u672c\uff0c\u8868\u683c\uff0c\u56fe\u5f62\u7684\u53ea\u8bfb\u6587\u6863\u662f\u5f88\u6709\u7528\u7684\u3002";
                Paragraph context = new Paragraph(contextString);
                context.setAlignment(0);
                context.setFont(contextFont);
                context.setSpacingBefore(10.0f);
                context.setFirstLineIndent(0.0f);
                document.add((Element)context);
                int k = 0;
                while (k < 4) {
                    int enString = 65;
                    String answerString = String.valueOf((char)(enString + k)) + "." + "\u8868\u683c\uff0c\u56fe\u5f62\u7684\u53ea\u8bfb\u6587\u6863\u662f\u5f88\u6709\u7528\u7684\u3002";
                    Paragraph answer = new Paragraph(answerString);
                    answer.setAlignment(0);
                    answer.setFont(contextFont);
                    answer.setSpacingBefore(10.0f);
                    answer.setFirstLineIndent(20.0f);
                    document.add((Element)answer);
                    k = (short)(k + 1);
                }
                ++j;
            }
            ++i;
        }
        document.close();
    }

    public static void makePaperDoc(String path, Paper paper) throws Exception {
        if (path == null) {
            throw new Exception("\u76ee\u6807\u8def\u5f84\u4e3a\u7a7a");
        }
        if (paper == null) {
            throw new Exception("\u8bd5\u5377\u4e0d\u5b58\u5728");
        }
        Document document = new Document(PageSize.A4);
        RtfWriter2.getInstance((Document)document, (OutputStream)new FileOutputStream(path));
        document.open();
        BaseFont bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        Font titleFont = new Font(bfChinese, 14.0f, 1);
        Font subTitleFont = new Font(bfChinese, 11.0f, 1);
        Font contextFont = new Font(bfChinese, 10.0f, 0);
        Font headerFooterFont = new Font(bfChinese, 9.0f, 0);
        Table header = new Table(2);
        header.setBorder(0);
        header.setWidth(100.0f);
        Paragraph address = new Paragraph(TECH_INFO);
        address.setFont(headerFooterFont);
        Cell cell01 = new Cell((Element)address);
        cell01.setBorder(0);
        header.addCell(cell01);
        Paragraph date = new Paragraph("\u751f\u6210\u65e5\u671f: " + new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        date.setAlignment(2);
        date.setFont(headerFooterFont);
        cell01 = new Cell((Element)date);
        cell01.setBorder(0);
        header.addCell(cell01);
        document.setHeader((HeaderFooter)new RtfHeaderFooter((Element)header));
        Table footer = new Table(2);
        footer.setBorder(0);
        footer.setWidth(100.0f);
        Paragraph company = new Paragraph(FOOT_INFO);
        company.setFont(headerFooterFont);
        Cell cell02 = new Cell((Element)company);
        cell02.setBorder(0);
        footer.addCell(cell02);
        Paragraph pageNumber = new Paragraph("\u7b2c ");
        pageNumber.add((Object)new RtfPageNumber());
        pageNumber.add((Object)new Chunk(" \u9875"));
        pageNumber.setAlignment(2);
        pageNumber.setFont(headerFooterFont);
        cell02 = new Cell((Element)pageNumber);
        cell02.setBorder(0);
        footer.addCell(cell02);
        document.setFooter((HeaderFooter)new RtfHeaderFooter((Element)footer));
        Paragraph title = new Paragraph(paper.getName());
        title.setAlignment(1);
        title.setFont(titleFont);
        document.add((Element)title);
        List<PaperSection> LIST_SECTIONS = paper.getSections();
        int rownbr = 0;
        if (LIST_SECTIONS != null && LIST_SECTIONS.size() > 0) {
            for (PaperSection section : LIST_SECTIONS) {
                Paragraph subTitle = new Paragraph(String.valueOf(section.getName()) + "," + section.getRemark() + ",\u5171" + (section.getQuestions() == null ? 0 : section.getQuestions().size()) + "\u9898");
                subTitle.setFont(subTitleFont);
                subTitle.setSpacingBefore(10.0f);
                subTitle.setFirstLineIndent(0.0f);
                document.add((Element)subTitle);
                List<Question> LIST_QUESTIONS = section.getQuestions();
                if (LIST_QUESTIONS == null || LIST_QUESTIONS.size() <= 0) continue;
                if ("1".equals(paper.getOrdertype())) {
                    Collections.shuffle(LIST_QUESTIONS);
                }
                for (Question question : LIST_QUESTIONS) {
                    List<Option> LIST_OPTIONS;
                    Question _question;
                    String qtype = question.getType();
                    String question_content = "";
                    question_content = "4".equals(qtype) ? BaseUtil.FormatBlankQuestions(question.getContent(), "_______") : question.getContent();
                    question_content = BaseUtil.Html2TextFormat(question_content);
                    Paragraph context = new Paragraph("\u7b2c" + ++rownbr + "\u9898,\u5206\u503c:(" + question.getScore() + ")\n" + question_content);
                    context.setAlignment(0);
                    context.setFont(contextFont);
                    context.setSpacingBefore(10.0f);
                    context.setFirstLineIndent(0.0f);
                    document.add((Element)context);
                    StringBuffer OPTIONS = new StringBuffer("");
                    if ("1".equals(qtype)) {
                        _question = (QuestionSingleChoice)question;
                        LIST_OPTIONS = ((QuestionSingleChoice)_question).getOptions();
                        if (LIST_OPTIONS != null && LIST_OPTIONS.size() > 0) {
                            for (Option option : LIST_OPTIONS) {
                                OPTIONS.append(String.valueOf(option.getAlisa()) + " : " + option.getText() + "\n");
                            }
                        }
                    } else if ("2".equals(qtype)) {
                        _question = (QuestionMultipleChoice)question;
                        LIST_OPTIONS = ((QuestionMultipleChoice)_question).getOptions();
                        if (LIST_OPTIONS != null && LIST_OPTIONS.size() > 0) {
                            for (Option option : LIST_OPTIONS) {
                                OPTIONS.append(String.valueOf(option.getAlisa()) + " : " + option.getText() + "\n");
                            }
                        }
                    } else if ("3".equals(qtype)) {
                        OPTIONS.append("\u6b63\u786e       \u9519\u8bef");
                    } else if (!"4".equals(qtype) && "5".equals(qtype)) {
                        OPTIONS.append("\u8bf7\u7b54\u9898\uff1a\n\n\n");
                    }
                    Paragraph options = new Paragraph(OPTIONS.toString());
                    options.setAlignment(0);
                    options.setFont(contextFont);
                    options.setSpacingBefore(10.0f);
                    options.setFirstLineIndent(0.0f);
                    document.add((Element)options);
                }
            }
        }
        document.close();
    }
}

