/*
 * Decompiled with CFR 0.152.
 */
package com.tom.user.service.imp;

import com.tom.core.TomSystemQueue;
import com.tom.core.service.ICorePaperService;
import com.tom.model.paper.Paper;
import com.tom.model.system.Pagination;
import com.tom.user.dao.IUserPaperDao;
import com.tom.user.service.IUserPaperService;
import com.tom.util.BaseUtil;
import com.tom.util.CacheHelper;
import com.tom.util.Constants;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="UserPaperService")
public class UserPaperServiceImp
implements IUserPaperService {
    @Autowired
    private IUserPaperDao dao;
    @Autowired
    private ICorePaperService corePaperService;
    private static Logger logger = Logger.getLogger(UserPaperServiceImp.class);

    @Override
    public Pagination list(Map<String, Object> params, int pagesize, int currentPageNo) {
        try {
            return this.dao.query(params, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }

    @Override
    public Paper getPaper(String pid) {
        logger.info((Object)String.format("\u7528\u6237\u83b7\u53d6\u666e\u901a\u8bd5\u5377\uff0cpid=%s", pid));
        Paper paper = this.corePaperService.getPaper(pid);
        return paper;
    }

    @Override
    public Paper getPaper(String uid, String pid) {
        logger.info((Object)String.format("\u7528\u6237\u83b7\u53d6\u8bd5\u5377\uff0cuid=%s\uff0cpid=%s", uid, pid));
        Paper paper = this.corePaperService.getPaper(pid);
        if (paper == null) {
            return null;
        }
        if (paper.getPapertype() == 0) {
            return paper;
        }
        paper = this.corePaperService.getUserRandomPaper(uid, pid);
        if (paper == null) {
            paper = this.corePaperService.buildUserRandomPaper(uid, pid);
        }
        return paper;
    }

    @Override
    public int startExam(Map<String, Object> info) {
        logger.info((Object)String.format("\u7528\u6237\u6807\u8bb0\u8003\u8bd5\u5f00\u59cb\uff0cinfo=%s", info.toString()));
        info.put("e_id", BaseUtil.generateId());
        try {
            return this.dao.startExam(info);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return -1;
        }
    }

    @Override
    public int submitPaper(HttpServletRequest request) {
        logger.info((Object)"\u7528\u6237\u63d0\u4ea4\u8bd5\u5377...");
        HashMap<String, Object> examData = new HashMap<String, Object>();
        String randcode = BaseUtil.generateRandomString(10);
        try {
            Map mapx = request.getParameterMap();
            for (Map.Entry entry : mapx.entrySet()) {
                examData.put((String)entry.getKey(), StringUtils.join((Object[])((Object[])entry.getValue()), (String)Constants.TM_SPLITER));
            }
            logger.info((Object)("\u7528\u6237\u63d0\u4ea4\u8bd5\u5377,\u968f\u673a\u7801:" + randcode + ",\u8bd5\u5377\u6570\u636e:" + examData));
            TomSystemQueue.USER_PAPER_QUEUE.add(examData);
            int i = this.dao.userSubmitPaper(examData);
            logger.info((Object)("\u7528\u6237\u63d0\u4ea4\u8bd5\u5377,\u968f\u673a\u7801:" + randcode + ",\u63d0\u4ea4\u7ed3\u679c:" + i));
            return i;
        }
        catch (Exception e) {
            logger.info((Object)("\u7528\u6237\u63d0\u4ea4\u8bd5\u5377\u5931\u8d25,\u968f\u673a\u7801:" + randcode));
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public Pagination history(Map<String, Object> params, int pagesize, int currentPageNo) {
        try {
            return this.dao.history(params, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }

    @Override
    public Map<String, Object> getHistoryDetail(String uid, String eid) {
        try {
            return this.dao.getHistoryDetail(uid, eid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public int getUserPaperLeftTime(String pid, String uid) {
        try {
            Paper paper = (Paper)CacheHelper.getCache("PaperCache", "P" + pid);
            int totalSeconds = paper.getDuration() * 60;
            Map<String, Object> map = this.dao.getExamInfo(uid, pid);
            if (map == null) {
                return totalSeconds;
            }
            String status = String.valueOf(map.get("e_status"));
            if ("0".equals(status)) {
                Timestamp stm = (Timestamp)map.get("e_starttime");
                long joinTime = stm.getTime();
                long nowTime = new Date().getTime();
                long passedTime = nowTime - joinTime;
                int passedSeconds = new Long(passedTime / 1000L).intValue();
                int leftSeconds = totalSeconds - passedSeconds;
                return leftSeconds;
            }
            return -1;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return -9;
        }
    }
}

