/*
 * Decompiled with CFR 0.152.
 */
package com.tom.user.service.imp;

import com.tom.core.service.ICoreSystemService;
import com.tom.model.system.Pagination;
import com.tom.system.dao.IAdminRoleDao;
import com.tom.system.service.IConfigService;
import com.tom.user.dao.ICommonDao;
import com.tom.user.dao.IUserPaperDao;
import com.tom.user.service.ICommonService;
import com.tom.util.BaseUtil;
import com.tom.util.Constants;
import com.tom.util.Md5Util;
import com.tom.util.WebApplication;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="CommonService")
public class CommonServiceImp
implements ICommonService {
    @Autowired
    private ICommonDao dao;
    @Autowired
    private IUserPaperDao updao;
    @Autowired
    private ICoreSystemService core_service;
    @Autowired
    private IConfigService configService;
    @Autowired
    private IAdminRoleDao adminRoleDao;
    private static final Logger logger = Logger.getLogger(CommonServiceImp.class);

    @Override
    public Map<String, Object> doLogin(String usertype, String username, String userpass) {
        logger.info((Object)String.format("\u7528\u6237\u767b\u5f55\uff0cusername=%s\uff0cusertype=%s", username, usertype));
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (BaseUtil.isEmpty(usertype) || BaseUtil.isEmpty(username) || BaseUtil.isEmpty(userpass)) {
            ret.put("code", -4);
            ret.put("msgkey", "params_required");
            return ret;
        }
        try {
            String new_pass;
            Map<String, Object> user = this.dao.getUserByUserName(usertype, username);
            if (user == null) {
                ret.put("code", -3);
                ret.put("msgkey", "user_not_exsit");
                return ret;
            }
            String status = String.valueOf(user.get("user_status"));
            if ("-1".equals(status)) {
                ret.put("code", -2);
                ret.put("msgkey", "user_locked");
                return ret;
            }
            String salt = String.valueOf(user.get("user_salt"));
            String old_pass = String.valueOf(user.get("user_pass"));
            if (!old_pass.equals(new_pass = WebApplication.getInstance().getSingletonObject(Md5Util.class).getMD5ofStr(String.valueOf(Constants.SYS_IDENTIFICATION_CODE) + userpass + salt))) {
                ret.put("code", -1);
                ret.put("msgkey", "password_wrong");
                return ret;
            }
            String userid = String.valueOf(user.get("user_id"));
            this.dao.updateUserLastLogin(usertype, userid);
            ret.put("code", 1);
            ret.put("data", user);
            ret.put("msgkey", "success");
            return ret;
        }
        catch (Exception e) {
            logger.error((Object)e);
            ret.put("code", -9);
            ret.put("msgkey", "unknown_error");
            return ret;
        }
    }

    @Override
    public List<Map<String, Object>> getWelcomeNewsList(int rows) {
        try {
            Pagination pager = this.dao.queryNews(null, 5, 1);
            if (pager != null) {
                return pager.getDataList();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    @Override
    public Map<String, Object> getWelcomeStatisticsParams() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("user", this.dao.StatisticUsers());
        map.put("qdb", this.dao.StatisticQdbs());
        map.put("question", this.dao.StatisticQuestions());
        map.put("paper", this.dao.StatisticPapers());
        map.put("lession", this.dao.StatisticLessions());
        return map;
    }

    @Override
    public List<Map<String, Object>> getWelcomeExamList(String branchid, String uid, int rows) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("branchid", branchid);
            params.put("uid", uid);
            Pagination pager = this.updao.query(params, rows, 1);
            if (pager != null) {
                return pager.getDataList();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getWelcomeExamHistoryList(String branchid, String uid, int rows) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("e_uid", uid);
            Pagination pager = this.updao.history(params, rows, 1);
            if (pager != null) {
                return pager.getDataList();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    @Override
    public Map<String, Object> getNews(String id) {
        try {
            return this.dao.getNews(id);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public Pagination getNewsList(Map<String, Object> params, int pagesize, int currentPageNo) {
        try {
            return this.dao.queryNews(params, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }

    @Override
    public Map<String, Object> getNewsCategory(String id) {
        try {
            return this.dao.getNewsCategory(id);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> getAllNewsCategories() {
        try {
            return this.dao.getAllNewsCategories();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> getUserProfile(String uid) {
        try {
            return this.dao.getUserProfile(uid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> getAdminProfile(String aid) {
        try {
            return this.dao.getAdminProfile(aid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int updateUserProfile(Map<String, Object> user) {
        Map<String, Object> usr;
        String u_userpass;
        block4: {
            if (user == null) {
                return 0;
            }
            logger.info((Object)String.format("\u4fee\u6539\u7528\u6237\u4fe1\u606f\uff0cuser=%s", user.toString()));
            try {
                u_userpass = (String)user.get("u_userpass");
                String u_id = (String)user.get("u_id");
                if (!BaseUtil.isNotEmpty(u_userpass)) return this.dao.updateUserProfile(user);
                usr = this.dao.getUserProfile(u_id);
                if (usr != null) break block4;
                return -1;
            }
            catch (Exception e) {
                logger.error((Object)e);
                return 0;
            }
        }
        String salt = (String)usr.get("u_salt");
        String password = WebApplication.getInstance().getSingletonObject(Md5Util.class).getMD5ofStr(String.valueOf(Constants.SYS_IDENTIFICATION_CODE) + u_userpass + salt);
        user.put("u_userpass", password);
        return this.dao.updateUserProfile(user);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int updateAdminProfile(Map<String, Object> admin) {
        Map<String, Object> adm;
        String a_userpass;
        block4: {
            if (admin == null) {
                return 0;
            }
            logger.info((Object)String.format("\u4fee\u6539\u7ba1\u7406\u5458\u4fe1\u606f\uff0cadmin=%s", admin.toString()));
            try {
                a_userpass = (String)admin.get("a_userpass");
                String a_id = (String)admin.get("a_id");
                if (!BaseUtil.isNotEmpty(a_userpass)) return this.dao.updateAdminProfile(admin);
                adm = this.dao.getAdminProfile(a_id);
                if (adm != null) break block4;
                return -1;
            }
            catch (Exception e) {
                logger.error((Object)e);
                return 0;
            }
        }
        String salt = (String)adm.get("a_salt");
        String password = WebApplication.getInstance().getSingletonObject(Md5Util.class).getMD5ofStr(String.valueOf(Constants.SYS_IDENTIFICATION_CODE) + a_userpass + salt);
        admin.put("a_userpass", password);
        return this.dao.updateAdminProfile(admin);
    }

    @Override
    public String getAdminRolePrivilege(String roleid) {
        try {
            Map<String, Object> role = this.adminRoleDao.getAdminRole(roleid);
            return "," + String.valueOf(role.get("r_privilege"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<String, Object> getSystemBaseConfig() {
        return this.configService.getConfig("1");
    }

    @Override
    public int getTotalUsers() {
        return this.core_service.getTotalUsers();
    }
}

