/*
 * Decompiled with CFR 0.152.
 */
package com.tom.user.action;

import com.tom.model.system.Pagination;
import com.tom.user.service.IUserCollectionService;
import com.tom.util.BaseUtil;
import com.tom.util.Constants;
import com.tom.web.controller.BaseController;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/user/collection"})
public class UserCollectionController
extends BaseController {
    @Autowired
    private IUserCollectionService service;

    @RequestMapping(value={"/list.thtml"})
    public ModelAndView list(HttpServletRequest request, ModelMap modelMap) {
        HttpSession session = request.getSession();
        String uid = String.valueOf(session.getAttribute(Constants.SESSION_USERID));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("c_uid", uid);
        params.put("c_tid", request.getParameter("c_tid"));
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        String epagesize = BaseUtil.convertEmptyToSome(request.getParameter("epagesize"), "10");
        Pagination page = this.service.queryCollection(params, BaseUtil.getInt(epagesize), BaseUtil.getInt(epage));
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        modelMap.put((Object)"types", this.service.getAllCollectionType(uid));
        return new ModelAndView("user/collection/list", (Map)modelMap);
    }

    @RequestMapping(value={"/add.do"})
    public void doAddCollection(HttpServletRequest request, PrintWriter out) {
        int i = this.service.addCollection(this.getRequestData(request));
        JSONObject json = new JSONObject();
        String code = "";
        code = i == 1 ? "ok" : (i == 2 ? "has" : "err");
        json.put((Object)"code", (Object)code);
        out.print(json.toString());
    }

    @RequestMapping(value={"/delete.do"})
    public void doDeleteCollection(HttpServletRequest request, PrintWriter out) {
        HttpSession session = request.getSession();
        String uid = String.valueOf(session.getAttribute(Constants.SESSION_USERID));
        String id = request.getParameter("id");
        int i = this.service.deleteCollection(uid, id);
        JSONObject json = new JSONObject();
        json.put((Object)"code", (Object)(i == 1 ? "ok" : "err"));
        out.print(json.toString());
    }

    @RequestMapping(value={"/clear.do"})
    public void doClearCollection(HttpServletRequest request, PrintWriter out) {
        HttpSession session = request.getSession();
        String uid = String.valueOf(session.getAttribute(Constants.SESSION_USERID));
        int i = this.service.clearCollections(uid);
        JSONObject json = new JSONObject();
        json.put((Object)"code", (Object)(i >= 0 ? "ok" : "err"));
        out.print(json.toString());
    }

    @RequestMapping(value={"/types.thtml"})
    public ModelAndView doQueryCollectionTypes(HttpServletRequest request, ModelMap modelMap) {
        HttpSession session = request.getSession();
        String uid = String.valueOf(session.getAttribute(Constants.SESSION_USERID));
        List<Map<String, Object>> list = this.service.getAllCollectionType(uid);
        modelMap.put((Object)"types", list);
        return new ModelAndView("user/collection/types", (Map)modelMap);
    }

    @RequestMapping(value={"/addtype.do"})
    public void doAddCollectionType(HttpServletRequest request, PrintWriter out) {
        HttpSession session = request.getSession();
        String uid = String.valueOf(session.getAttribute(Constants.SESSION_USERID));
        Map<String, Object> params = this.getRequestData(request);
        params.put("t_uid", uid);
        params.put("t_id", BaseUtil.generateId());
        int i = this.service.addCollectionType(params);
        JSONObject json = new JSONObject();
        String msg = "err";
        if (i == 1) {
            msg = "ok";
        } else if (i == 2) {
            msg = "maxlimit";
        }
        json.put((Object)"code", (Object)msg);
        out.print(json.toString());
    }

    @RequestMapping(value={"/deletetype.do"})
    public void doDeleteCollectionType(HttpServletRequest request, PrintWriter out) {
        HttpSession session = request.getSession();
        String uid = String.valueOf(session.getAttribute(Constants.SESSION_USERID));
        String id = request.getParameter("id");
        int i = this.service.deleteCollectionType(uid, id);
        String msg = "err";
        if (i == 1) {
            msg = "ok";
        } else if (i == 2) {
            msg = "hasdata";
        }
        JSONObject json = new JSONObject();
        json.put((Object)"code", (Object)msg);
        out.print(json.toString());
    }

    @RequestMapping(value={"/updatetype.do"})
    public void doUpdateCollectionType(HttpServletRequest request, PrintWriter out) {
        HttpSession session = request.getSession();
        String uid = String.valueOf(session.getAttribute(Constants.SESSION_USERID));
        String id = request.getParameter("id");
        String t_name = request.getParameter("t_name");
        HashMap<String, Object> type = new HashMap<String, Object>();
        type.put("t_name", t_name);
        type.put("t_id", id);
        type.put("t_uid", uid);
        int i = this.service.updateCollectionType(type);
        String msg = "err";
        if (i == 1) {
            msg = "ok";
        }
        JSONObject json = new JSONObject();
        json.put((Object)"code", (Object)msg);
        out.print(json.toString());
    }
}

