/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.service.imp;

import com.tom.model.system.Pagination;
import com.tom.system.dao.IUserDao;
import com.tom.system.service.IUserService;
import com.tom.util.BaseUtil;
import com.tom.util.Constants;
import com.tom.util.Md5Util;
import com.tom.util.OfficeToolExcel;
import com.tom.util.WebApplication;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="UserService")
public class UserServiceImp
implements IUserService {
    private static final Logger logger = Logger.getLogger(UserServiceImp.class);
    @Autowired
    private IUserDao dao;

    @Override
    public int addUser(Map<String, Object> user) {
        block7: {
            try {
                int uis = this.dao.getuis();
                if (!WebApplication.getInstance().getSingletonObject(Md5Util.class).hpashed(uis)) {
                    return -99;
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            try {
                String u_username = (String)user.get("u_username");
                Map<String, Object> userchk = this.dao.getUserByUsername(u_username);
                if (userchk == null) break block7;
                return 3;
            }
            catch (Exception e) {
                logger.error((Object)e);
                return 0;
            }
        }
        String userpass = String.valueOf(user.get("u_userpass"));
        String salt = BaseUtil.generateRandomString(10);
        if (BaseUtil.isNotEmpty(userpass)) {
            String password = WebApplication.getInstance().getSingletonObject(Md5Util.class).getMD5ofStr(String.valueOf(Constants.SYS_IDENTIFICATION_CODE) + userpass + salt);
            user.put("u_userpass", password);
        }
        user.put("u_id", BaseUtil.generateId());
        user.put("u_salt", salt);
        return this.dao.addUser(user);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int importUsers(MultipartFile file, HttpServletRequest request) {
        block8: {
            if (file == null) {
                return -1;
            }
            tmpFile = File.createTempFile("TEMPFILE" + System.currentTimeMillis(), ".tmp");
            file.transferTo(tmpFile);
            list = OfficeToolExcel.readExcel(tmpFile, new String[]{"USERNO", "USERNAME", "USERPASS", "REALNAME", "EMAIL", "MOBI", "REMARK"});
            if (list != null && list.size() >= 1) break block8;
            return -1;
        }
        try {
            uis = this.dao.getuis() + list.size();
            if (!WebApplication.getInstance().getSingletonObject(Md5Util.class).hpashed(uis)) {
                return -99;
            }
            ** GOTO lbl18
        }
        catch (Exception ex) {
            try {
                UserServiceImp.logger.error((Object)ex);
lbl18:
                // 2 sources

                u_branchid = request.getParameter("u_branchid");
                u_positionid = request.getParameter("u_positionid");
                users = new ArrayList<List<Object>>();
                users_ex = new ArrayList<List<Object>>();
                row = 0;
                for (Map map : list) {
                    if (++row < 2) continue;
                    PWD = String.valueOf(map.get("USERPASS"));
                    salt = BaseUtil.generateRandomString(10);
                    password = WebApplication.getInstance().getSingletonObject(Md5Util.class).getMD5ofStr(String.valueOf(Constants.SYS_IDENTIFICATION_CODE) + PWD + salt);
                    uid = BaseUtil.generateId();
                    user_obj = new Object[]{uid, String.valueOf(map.get("USERNAME")), password, "", u_branchid, String.valueOf(map.get("REALNAME")), 0, String.valueOf(map.get("USERNO")), String.valueOf(map.get("MOBI")), String.valueOf(map.get("EMAIL")), "0", "", String.valueOf(map.get("REMARK")), salt};
                    userex_obj = new Object[]{uid, u_positionid};
                    user = Arrays.asList(user_obj);
                    userex = Arrays.asList(userex_obj);
                    users.add(user);
                    users_ex.add(userex);
                }
                tmpFile.delete();
                rows = this.dao.batchAddUsers(users, users_ex);
                return rows;
            }
            catch (Exception e) {
                UserServiceImp.logger.error((Object)e);
                return -9;
            }
        }
    }

    @Override
    public int deleteUser(String id) {
        try {
            return this.dao.deleteUser(id);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public int deleteUserLogic(String id) {
        try {
            return this.dao.updateUserStatus(id, -9);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public int recoveryUser(String id) {
        try {
            return this.dao.updateUserStatus(id, 1);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public boolean doCheckUsernameExist(String username) {
        try {
            Map<String, Object> map = this.dao.getUserByUsername(username);
            return map != null;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }

    @Override
    public int doLogin(String username, String userpass) {
        String u_id;
        block5: {
            Map<String, Object> user;
            block4: {
                try {
                    user = this.dao.getUserByUsername(username);
                    if (user != null) break block4;
                    return 10;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return 19;
                }
            }
            String salt = String.valueOf(user.get("u_salt"));
            String userpass_db = String.valueOf(user.get("u_userpass"));
            u_id = String.valueOf(user.get("u_id"));
            String userpass_xn = WebApplication.getInstance().getSingletonObject(Md5Util.class).getMD5ofStr(String.valueOf(Constants.SYS_IDENTIFICATION_CODE) + userpass + salt);
            if (userpass_db.equals(userpass_xn)) break block5;
            return 11;
        }
        this.dao.updateLoginInfo(u_id);
        return 1;
    }

    @Override
    public Map<String, Object> getUser(String id) {
        try {
            return this.dao.getUser(id);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public Pagination query(Map<String, Object> params, int pagesize, int currentPageNo) {
        try {
            return this.dao.query(params, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }

    @Override
    public int updateUser(Map<String, Object> user) {
        try {
            String u_userpass = (String)user.get("u_userpass");
            String u_id = (String)user.get("u_id");
            if (BaseUtil.isNotEmpty(u_userpass)) {
                Map<String, Object> usr = this.dao.getUser(u_id);
                String salt = "";
                if (usr != null) {
                    salt = (String)usr.get("u_salt");
                }
                String password = WebApplication.getInstance().getSingletonObject(Md5Util.class).getMD5ofStr(String.valueOf(Constants.SYS_IDENTIFICATION_CODE) + u_userpass + salt);
                user.put("u_userpass", password);
            }
            return this.dao.updateUser(user);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public int batchDelete(HttpServletRequest request) {
        ArrayList<List<Object>> users = new ArrayList<List<Object>>();
        String[] uids = request.getParameterValues("b_uids");
        if (uids == null || uids.length < 1) {
            return 0;
        }
        String[] stringArray = uids;
        int n = uids.length;
        int n2 = 0;
        while (n2 < n) {
            String uid = stringArray[n2];
            Object[] ouser = new Object[]{uid};
            List<Object> user = Arrays.asList(ouser);
            users.add(user);
            ++n2;
        }
        try {
            return this.dao.batchDeleteUsers(users);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return -1;
        }
    }

    @Override
    public int batchSetGid(HttpServletRequest request) {
        ArrayList<List<Object>> users = new ArrayList<List<Object>>();
        String[] uids = request.getParameterValues("b_uids");
        String b_branchid = request.getParameter("b_branchid");
        if (uids == null || uids.length < 1) {
            return 0;
        }
        String[] stringArray = uids;
        int n = uids.length;
        int n2 = 0;
        while (n2 < n) {
            String uid = stringArray[n2];
            Object[] ouser = new Object[]{b_branchid, uid};
            List<Object> user = Arrays.asList(ouser);
            users.add(user);
            ++n2;
        }
        try {
            return this.dao.batchUpdateUserBranch(users);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return -1;
        }
    }

    @Override
    public int batchSetStatus(HttpServletRequest request) {
        ArrayList<List<Object>> users = new ArrayList<List<Object>>();
        String[] uids = request.getParameterValues("b_uids");
        String b_status = request.getParameter("b_status");
        if (uids == null || uids.length < 1) {
            return 0;
        }
        String[] stringArray = uids;
        int n = uids.length;
        int n2 = 0;
        while (n2 < n) {
            String uid = stringArray[n2];
            Object[] ouser = new Object[]{b_status, uid};
            List<Object> user = Arrays.asList(ouser);
            users.add(user);
            ++n2;
        }
        try {
            return this.dao.batchUpdateUserStatus(users);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return -1;
        }
    }

    @Override
    public Pagination examlist(String uid, int pagesize, int currentPageNo) {
        try {
            return this.dao.examlist(uid, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }

    @Override
    public Pagination selfTestList(String uid, int pagesize, int currentPageNo) {
        try {
            return this.dao.selfTestList(uid, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }
}

