/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.service.imp;

import com.thoughtworks.xstream.XStream;
import com.tom.model.paper.Option;
import com.tom.model.paper.QuestionBlankFill;
import com.tom.model.paper.QuestionEssay;
import com.tom.model.paper.QuestionJudgment;
import com.tom.model.paper.QuestionMultipleChoice;
import com.tom.model.paper.QuestionSingleChoice;
import com.tom.model.system.Pagination;
import com.tom.system.dao.IQuestionDao;
import com.tom.system.service.IQuestionService;
import com.tom.util.BaseUtil;
import com.tom.util.CacheHelper;
import com.tom.util.OfficeToolExcel;
import com.tom.util.QuestionImportExcelHelper;
import com.tom.util.QuestionImportTxtHelper;
import com.tom.util.TomException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="QuestionService")
public class QuestionServiceImp
implements IQuestionService {
    private static final Logger logger = Logger.getLogger(QuestionServiceImp.class);
    @Autowired
    private IQuestionDao dao;

    @Override
    public int addQuestion(HttpServletRequest request) {
        HashMap<String, Object> question = new HashMap<String, Object>();
        String qtype = request.getParameter("q_type");
        String qid = BaseUtil.generateId();
        question.put("q_id", qid);
        question.put("q_dbid", request.getParameter("q_dbid"));
        question.put("q_type", qtype);
        question.put("q_level", request.getParameter("q_level"));
        question.put("q_from", request.getParameter("q_from"));
        question.put("q_status", request.getParameter("q_status"));
        question.put("q_content", request.getParameter("q_content"));
        String qkey = request.getParameter("q_key");
        if ("4".equals(qtype)) {
            qkey = StringUtils.join((Object[])request.getParameterValues("q_blanks"), (String)",");
        }
        question.put("q_key", qkey);
        question.put("q_resolve", request.getParameter("q_resolve"));
        question.put("q_poster", request.getParameter("q_poster"));
        question.put("q_modifyor", request.getParameter("q_modifyor"));
        question.put("q_data", this.buildQuestion(qid, request));
        try {
            return this.dao.addQuestion(question);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    private List<String> getFileContent(MultipartFile file) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            File tmpFile;
            block17: {
                tmpFile = File.createTempFile("TEMPFILE" + System.currentTimeMillis(), ".tmp");
                file.transferTo(tmpFile);
                BufferedReader reader = null;
                try {
                    try {
                        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(tmpFile), "UTF-8");
                        reader = new BufferedReader(isr);
                        String tempString = null;
                        while ((tempString = reader.readLine()) != null) {
                            lines.add(tempString);
                        }
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            tmpFile.delete();
        }
        catch (IOException e) {
            logger.error((Object)("\u83b7\u53d6\u4e0a\u4f20\u8bd5\u9898\u6a21\u677f\u6570\u636e\u5931\u8d25:" + e.getMessage()));
        }
        return lines;
    }

    @Override
    public int importQuestionsFromTxt(MultipartFile file, HttpServletRequest request) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String q_poster = request.getParameter("q_poster");
        String q_dbid = request.getParameter("q_dbid");
        try {
            List<Map<String, Object>> data = QuestionImportTxtHelper.QuestionConverteFromTxt(this.getFileContent(file));
            if (data != null && data.size() > 0) {
                for (Map<String, Object> map : data) {
                    map.put("q_id", BaseUtil.generateId());
                    map.put("q_dbid", q_dbid);
                    map.put("q_poster", q_poster);
                    map.put("q_modifyor", q_poster);
                    map.put("q_data", QuestionImportTxtHelper.genarateQuestionObject(map));
                    list.add(map);
                }
            }
        }
        catch (TomException e1) {
            logger.error((Object)e1.getMessage());
            return e1.getCode();
        }
        catch (Exception e2) {
            logger.error((Object)e2.getMessage());
            return -2;
        }
        try {
            return this.dao.importQuestions(list);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return -1;
        }
    }

    @Override
    public int importQuestionsFromExcel(MultipartFile file, HttpServletRequest request) {
        List<Map<String, Object>> questions;
        File tmpFile;
        block27: {
            List<Map> list;
            String q_dbid;
            String q_poster;
            block26: {
                q_poster = request.getParameter("q_poster");
                q_dbid = request.getParameter("q_dbid");
                tmpFile = null;
                tmpFile = File.createTempFile("TEMPFILE" + System.currentTimeMillis(), ".tmp");
                file.transferTo(tmpFile);
                list = OfficeToolExcel.readExcel(tmpFile, new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K"});
                if (list != null && list.size() >= 1) break block26;
                try {
                    tmpFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return 0;
            }
            questions = null;
            try {
                questions = QuestionImportExcelHelper.QuestionConverteFromExcel(list, q_poster, q_dbid);
            }
            catch (Exception e1) {
                logger.error((Object)e1);
                try {
                    tmpFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return -9;
            }
            if (questions != null && questions.size() >= 1) break block27;
            try {
                tmpFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }
        try {
            int n = this.dao.importQuestions(questions);
            return n;
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                logger.error((Object)e2);
                return -1;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                tmpFile.delete();
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    @Override
    public int deleteQuestion(String qid) {
        block4: {
            try {
                boolean hasUsed = this.dao.hasBeenUsed(qid);
                if (!hasUsed) break block4;
                return 9;
            }
            catch (Exception e) {
                logger.error((Object)e);
                return 0;
            }
        }
        int rows = this.dao.deleteQuestion(qid);
        if (rows > 0) {
            CacheHelper.removeCache("QuestionCache", "Q" + qid);
        }
        return rows;
    }

    @Override
    public int updateQuestion(HttpServletRequest request) {
        HashMap<String, Object> question = new HashMap<String, Object>();
        String qtype = request.getParameter("q_type");
        String qid = request.getParameter("q_id");
        question.put("q_id", qid);
        question.put("q_dbid", request.getParameter("q_dbid"));
        question.put("q_level", request.getParameter("q_level"));
        question.put("q_from", request.getParameter("q_from"));
        question.put("q_status", request.getParameter("q_status"));
        question.put("q_content", request.getParameter("q_content"));
        String qkey = request.getParameter("q_key");
        if ("4".equals(qtype)) {
            qkey = StringUtils.join((Object[])request.getParameterValues("q_blanks"), (String)",");
        }
        question.put("q_key", qkey);
        question.put("q_resolve", request.getParameter("q_resolve"));
        question.put("q_poster", request.getParameter("q_poster"));
        question.put("q_modifyor", request.getParameter("q_modifyor"));
        question.put("q_data", this.buildQuestion(qid, request));
        try {
            int rows = this.dao.updateQuestion(question);
            if (rows > 0) {
                CacheHelper.removeCache("QuestionCache", "Q" + qid);
            }
            return rows;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public Map<String, Object> getQuestion(String qid) {
        try {
            return this.dao.getQuestion(qid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public Pagination query(Map<String, Object> params, int pagesize, int currentPageNo) {
        try {
            return this.dao.query(params, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }

    private String buildQuestion(String qid, HttpServletRequest request) {
        String result = "";
        XStream xstream = new XStream();
        String type = request.getParameter("q_type");
        String content = request.getParameter("q_content");
        String key = request.getParameter("q_key");
        String resolve = request.getParameter("q_resolve");
        if ("1".equals(type)) {
            QuestionSingleChoice question = new QuestionSingleChoice();
            if (request.getParameterValues("q_options") != null) {
                char alisa = 'A';
                String[] stringArray = request.getParameterValues("q_options");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String option = stringArray[n2];
                    question.addOption(new Option(String.valueOf(alisa), option));
                    alisa = (char)(alisa + '\u0001');
                    ++n2;
                }
            }
            question.setId(qid);
            question.setContent(content);
            question.setKey(key);
            question.setExt(resolve);
            result = xstream.toXML((Object)question);
        } else if ("2".equals(type)) {
            QuestionMultipleChoice question = new QuestionMultipleChoice();
            if (request.getParameterValues("q_options") != null) {
                char alisa = 'A';
                String[] stringArray = request.getParameterValues("q_options");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String option = stringArray[n3];
                    question.addOption(new Option(String.valueOf(alisa), option));
                    alisa = (char)(alisa + '\u0001');
                    ++n3;
                }
            }
            question.setId(qid);
            question.setContent(content);
            key = StringUtils.join((Object[])request.getParameterValues("q_key"), (String)"");
            question.setKey(key);
            question.setExt(resolve);
            result = xstream.toXML((Object)question);
        } else if ("3".equals(type)) {
            QuestionJudgment question = new QuestionJudgment();
            question.setId(qid);
            question.setContent(content);
            question.setKey(key);
            question.setExt(resolve);
            result = xstream.toXML((Object)question);
        } else if ("4".equals(type)) {
            QuestionBlankFill question = new QuestionBlankFill();
            String[] qids = request.getParameterValues("q_blankids");
            String[] qblanks = request.getParameterValues("q_blanks");
            int i = 0;
            while (i < qids.length) {
                int iqid = BaseUtil.getInt(qids[i]);
                String sqblank = qblanks[i];
                question.addBlank(iqid, "BLANK" + iqid, sqblank);
                ++i;
            }
            question.setComplex("Y".equalsIgnoreCase(request.getParameter("q_iscomplex")));
            question.setId(qid);
            question.setContent(content);
            question.setKey(key);
            question.setExt(resolve);
            result = xstream.toXML((Object)question);
        } else if ("5".equals(type)) {
            QuestionEssay question = new QuestionEssay();
            question.setId(qid);
            question.setContent(content);
            question.setKey(key);
            question.setExt(resolve);
            result = xstream.toXML((Object)question);
        }
        return result;
    }
}

