/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.service.imp;

import com.tom.model.system.Pagination;
import com.tom.system.dao.IPaperHistoryDao;
import com.tom.system.service.IPaperHistoryService;
import com.tom.util.BaseUtil;
import com.tom.util.Constants;
import com.tom.util.OfficeToolExcel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PaperHistoryService")
public class PaperHistoryServiceImp
implements IPaperHistoryService {
    private static final Logger logger = Logger.getLogger(PaperHistoryServiceImp.class);
    @Autowired
    private IPaperHistoryDao dao;

    @Override
    public Pagination query(Map<String, Object> params, int pagesize, int currentPageNo) {
        try {
            return this.dao.query(params, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }

    @Override
    public Map<String, Object> getDetail(String eid) {
        try {
            return this.dao.getDetail(eid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public int deleteOneDetail(String eid, String pid, String uid) {
        try {
            return this.dao.deleteOneDetail(eid, pid, uid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public int deleteAllDetail(String pid) {
        try {
            int i = this.dao.deleteAllDetail(pid);
            return i;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return -1;
        }
    }

    @Override
    public int checkOneQuestion(String eid, String qid, int score) {
        Map<String, Object> map;
        block4: {
            map = this.getDetail(eid);
            if (map != null) break block4;
            return -1;
        }
        try {
            int total = 0;
            String e_check = String.valueOf(map.get("e_check"));
            JSONObject json = JSONObject.fromObject((Object)e_check);
            json.put((Object)qid, (Object)score);
            for (Object ky : json.keySet()) {
                String key = String.valueOf(ky);
                int val = json.getInt(key);
                total += val;
            }
            return this.dao.updateCheck(eid, json.toString(), total);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return -2;
        }
    }

    @Override
    public String exportHistory(String pid) {
        if (BaseUtil.isEmpty(pid)) {
            return null;
        }
        String filename = String.valueOf(BaseUtil.generateRandomString(15)) + ".xls";
        List<Map<String, Object>> list = null;
        Map<String, Object> paper = null;
        String paperName = "";
        try {
            list = this.dao.export(pid);
            paper = this.dao.getPaperInfo(pid);
            paperName = String.valueOf(paper.get("p_name"));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (list == null || list.isEmpty()) {
            return "-1";
        }
        ArrayList<Map<Object, Object>> ls = new ArrayList<Map<Object, Object>>();
        HashMap<String, Object> mmt = new HashMap<String, Object>();
        mmt.put("\u8003\u751f\u7528\u6237\u540d", null);
        mmt.put("\u6240\u5728\u90e8\u95e8", null);
        mmt.put("\u8003\u751f\u59d3\u540d", null);
        mmt.put("\u8003\u751f\u7f16\u53f7", null);
        mmt.put("\u5f00\u59cb\u65f6\u95f4", null);
        mmt.put("\u4ea4\u5377\u65f6\u95f4", null);
        mmt.put("\u8bd5\u5377\u5f97\u5206", null);
        mmt.put("\u8003\u8bd5\u8017\u65f6", null);
        mmt.put("\u6765\u6e90\u5730\u5740", null);
        ls.add(mmt);
        for (Map<String, Object> map : list) {
            HashMap<String, String> mm = new HashMap<String, String>();
            mm.put("\u8003\u751f\u7528\u6237\u540d", String.valueOf(map.get("u_username")));
            mm.put("\u6240\u5728\u90e8\u95e8", String.valueOf(map.get("b_name")));
            mm.put("\u8003\u751f\u59d3\u540d", String.valueOf(map.get("u_realname")));
            mm.put("\u8003\u751f\u7f16\u53f7", String.valueOf(map.get("u_no")));
            mm.put("\u5f00\u59cb\u65f6\u95f4", String.valueOf(map.get("e_starttime")));
            mm.put("\u4ea4\u5377\u65f6\u95f4", String.valueOf(map.get("e_endtime")));
            mm.put("\u8bd5\u5377\u5f97\u5206", String.valueOf(map.get("e_score")));
            mm.put("\u8003\u8bd5\u8017\u65f6", String.valueOf(map.get("e_timecost")));
            mm.put("\u6765\u6e90\u5730\u5740", String.valueOf(map.get("e_ip")));
            ls.add(mm);
        }
        String separator = System.getProperty("file.separator");
        String filepath = String.valueOf(Constants.getPhysicalPath()) + separator + "files" + separator + "export" + separator + filename;
        try {
            OfficeToolExcel.makeExcel(filepath, paperName, ls, new int[]{20, 20, 20, 20, 20, 20, 20, 20, 20});
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return filename;
    }

    @Override
    public Map<String, Object> getPaperCheckProgress(String pid) {
        try {
            return this.dao.getPaperCheckProgress(pid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }
}

