/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.service.imp;

import com.tom.model.system.Pagination;
import com.tom.system.dao.IPaperCategoryDao;
import com.tom.system.service.IPaperCategoryService;
import com.tom.util.BaseUtil;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PaperCategoryService")
public class PaperCategoryServiceImp
implements IPaperCategoryService {
    private static final Logger logger = Logger.getLogger(PaperCategoryServiceImp.class);
    @Autowired
    private IPaperCategoryDao dao;

    @Override
    public int addPaperCategory(Map<String, Object> category) {
        try {
            category.put("c_id", BaseUtil.generateId());
            return this.dao.addPaperCategory(category);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public int deletePaperCategory(String cid) {
        block3: {
            try {
                int papers = this.dao.getNumbers(cid);
                if (papers <= 0) break block3;
                return 2;
            }
            catch (Exception e) {
                logger.error((Object)e);
                return 0;
            }
        }
        return this.dao.deletePaperCategory(cid);
    }

    @Override
    public int updatePaperCategory(Map<String, Object> category) {
        try {
            return this.dao.updatePaperCategory(category);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public Map<String, Object> getPaperCategory(String cid) {
        try {
            return this.dao.getPaperCategory(cid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> getAllPaperCategorys() {
        try {
            return this.dao.getAllPaperCategorys();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public Pagination query(Map<String, Object> params, int pagesize, int currentPageNo) {
        try {
            return this.dao.query(params, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }
}

