/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.service.imp;

import com.tom.model.system.Pagination;
import com.tom.system.dao.INewsDao;
import com.tom.system.service.INewsService;
import com.tom.util.BaseUtil;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="NewsService")
public class NewsServiceImp
implements INewsService {
    private static final Logger logger = Logger.getLogger(NewsServiceImp.class);
    @Autowired
    private INewsDao dao;

    @Override
    public int addNewsCategory(Map<String, Object> category) {
        try {
            category.put("c_id", BaseUtil.generateId());
            return this.dao.addNewsCategory(category);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public int deleteNewsCategory(String categoryid) {
        block3: {
            try {
                int newss = this.dao.getNewsNumbers(categoryid);
                if (newss <= 0) break block3;
                return 2;
            }
            catch (Exception e) {
                logger.error((Object)e);
                return 0;
            }
        }
        return this.dao.deleteNewsCategory(categoryid);
    }

    @Override
    public int updateNewsCategory(Map<String, Object> category) {
        try {
            return this.dao.updateNewsCategory(category);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public Map<String, Object> getNewsCategory(String categoryid) {
        try {
            return this.dao.getNewsCategory(categoryid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> getAllNewsCategories() {
        try {
            return this.dao.getAllNewsCategories();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public Pagination queryNewsCategories(Map<String, Object> params, int pagesize, int currentPageNo) {
        try {
            return this.dao.queryNewsCategories(params, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }

    @Override
    public int addNews(Map<String, Object> news) {
        try {
            news.put("n_id", BaseUtil.generateId());
            return this.dao.addNews(news);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public int deleteNews(String newsid) {
        try {
            return this.dao.deleteNews(newsid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public int updateNews(Map<String, Object> news) {
        try {
            return this.dao.updateNews(news);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public Map<String, Object> getNews(String newsid) {
        try {
            return this.dao.getNews(newsid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> getNews4Read(String newsid) {
        try {
            return this.dao.getNews4Read(newsid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public Pagination queryNews(Map<String, Object> params, int pagesize, int currentPageNo) {
        try {
            return this.dao.queryNews(params, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }
}

