/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.service.imp;

import com.tom.model.ModelHelper;
import com.tom.model.course.Chapter;
import com.tom.model.course.Course;
import com.tom.model.course.Lesson;
import com.tom.model.system.Pagination;
import com.tom.system.dao.ICourseDao;
import com.tom.system.service.ICourseService;
import com.tom.util.BaseUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="CourseService")
public class CourseServiceImp
implements ICourseService {
    private static final Logger logger = Logger.getLogger(CourseServiceImp.class);
    @Autowired
    private ICourseDao dao;

    @Override
    public int addCourse(HttpServletRequest request) {
        try {
            String courseid = BaseUtil.generateId();
            Map<String, Object> course = this.getRequestCourse(request);
            course.put("c_id", courseid);
            course.put("c_data", this.buildCourse(request, courseid));
            return this.dao.addCourse(course);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public int deleteCourse(String courseid) {
        block3: {
            try {
                int users = this.dao.getUsers(courseid);
                if (users <= 0) break block3;
                return 2;
            }
            catch (Exception e) {
                logger.error((Object)e);
                return 0;
            }
        }
        return this.dao.deleteCourse(courseid);
    }

    @Override
    public Map<String, Object> getCourse(String courseid) {
        try {
            return this.dao.getCourse(courseid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public Pagination queryCourse(Map<String, Object> params, int pagesize, int currentPageNo) {
        try {
            return this.dao.queryCourse(params, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }

    @Override
    public int updateCourse(HttpServletRequest request) {
        try {
            String courseid = request.getParameter("c_id");
            Map<String, Object> course = this.getRequestCourse(request);
            course.put("c_id", courseid);
            course.put("c_data", this.buildCourse(request, courseid));
            return this.dao.updateCourse(course);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    private Map<String, Object> getRequestCourse(HttpServletRequest request) {
        HashMap<String, Object> course = new HashMap<String, Object>();
        course.put("c_name", request.getParameter("c_name"));
        course.put("c_logo", request.getParameter("c_logo"));
        course.put("c_tid", request.getParameter("c_tid"));
        course.put("c_caid", request.getParameter("c_caid"));
        course.put("c_score", request.getParameter("c_score"));
        course.put("c_type", request.getParameter("c_type"));
        course.put("c_introduce", request.getParameter("c_introduce"));
        course.put("c_status", request.getParameter("c_status"));
        course.put("c_stars", request.getParameter("c_stars"));
        course.put("c_poster", request.getParameter("c_poster"));
        course.put("c_modifier", request.getParameter("c_modifier"));
        return course;
    }

    private String buildCourse(HttpServletRequest request, String courseid) {
        Course course = new Course();
        try {
            course.setId(courseid);
            course.setName(request.getParameter("c_name"));
            course.setLogo(request.getParameter("c_logo"));
            course.setScore(BaseUtil.getInt(request.getParameter("c_score")));
            course.setType(BaseUtil.getInt(request.getParameter("c_type")));
            course.setIntroduce(request.getParameter("c_introduce"));
            course.setPostdate(new Date());
            course.setStatus(BaseUtil.getInt(request.getParameter("c_status")));
            course.setStars(BaseUtil.getInt(request.getParameter("c_stars")));
            String[] c_chapter_ids = request.getParameterValues("c_chapter_ids");
            String[] c_chapter_names = request.getParameterValues("c_chapter_names");
            String[] c_chapter_remarks = request.getParameterValues("c_chapter_remarks");
            if (c_chapter_ids != null && c_chapter_ids.length > 0) {
                int i = 0;
                while (i < c_chapter_ids.length) {
                    String chapter_id = c_chapter_ids[i];
                    String chapter_name = c_chapter_names[i];
                    String chapter_remark = c_chapter_remarks[i];
                    Chapter chapter = new Chapter(chapter_id, chapter_name, chapter_remark);
                    String[] c_lesson_ids = request.getParameterValues("c_lesson_id");
                    String[] c_lesson_names = request.getParameterValues("c_lesson_name");
                    String[] c_lesson_remarks = request.getParameterValues("c_lesson_remark");
                    String[] c_lesson_filetype = request.getParameterValues("c_lesson_filetype");
                    String[] c_lesson_filepath = request.getParameterValues("c_lesson_filepath");
                    String[] c_lesson_minutes = request.getParameterValues("c_lesson_minutes");
                    if (c_lesson_names != null && c_lesson_names.length > 0) {
                        int j = 0;
                        while (j < c_lesson_names.length) {
                            String lesson_id = c_lesson_ids[j];
                            String lesson_name = c_lesson_names[j];
                            String lesson_remark = c_lesson_remarks[j];
                            String lesson_filetype = c_lesson_filetype[j];
                            String lesson_filepath = c_lesson_filepath[j];
                            int lesson_minute = BaseUtil.getInt(c_lesson_minutes[j]);
                            if (BaseUtil.isNotEmpty(lesson_filepath)) {
                                lesson_filepath = lesson_filepath.replace("\"", "'");
                            }
                            Lesson lesson = new Lesson(lesson_id, lesson_name, lesson_remark, lesson_filetype, lesson_filepath, lesson_minute);
                            chapter.addLesson(lesson);
                            ++j;
                        }
                    }
                    course.addChapter(chapter);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        String ret = ModelHelper.formatObject(course);
        return ret;
    }

    @Override
    public Pagination queryCourseLearnRecord(Map<String, Object> params, int pagesize, int currentPageNo) {
        try {
            return this.dao.queryCourseLearnRecord(params, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }

    @Override
    public int clearLearnRecord(String cid) {
        try {
            return this.dao.clearLearnRecord(cid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return -1;
        }
    }
}

