/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.service.imp;

import com.tom.model.system.Pagination;
import com.tom.system.dao.IAnalysisDao;
import com.tom.system.service.IAnalysisService;
import com.tom.util.BaseUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="AnalysisService")
public class AnalysisServiceImp
implements IAnalysisService {
    private static final Logger logger = Logger.getLogger(AnalysisServiceImp.class);
    @Autowired
    private IAnalysisDao dao;

    @Override
    public Pagination queryPaper(Map<String, Object> params, int pagesize, int currentPageNo) {
        try {
            return this.dao.queryPaper(params, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }

    @Override
    public Pagination AnalyzePaperList(Map<String, Object> params, int pagesize, int currentPageNo) {
        try {
            return this.dao.AnalyzePaper(params, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }

    @Override
    public Map<String, Object> AnalyzePaperDetail(String pid) {
        try {
            List<Map<String, Object>> list = this.dao.getExamHistoryList(pid);
            if (list == null) {
                return new HashMap<String, Object>();
            }
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            float totalrows = 1.0f * (float)list.size();
            for (Map<String, Object> map : list) {
                String check = String.valueOf(map.get("e_check"));
                if (BaseUtil.isEmpty(check)) continue;
                JSONObject json = JSONObject.fromObject((Object)check);
                for (Object key : json.keySet()) {
                    String skey = String.valueOf(key);
                    int score = json.getInt(skey);
                    if (score <= 0) continue;
                    if (data.containsKey(skey)) {
                        String _value = String.valueOf(data.get(skey));
                        data.put(skey, BaseUtil.getInt(_value) + 1);
                        continue;
                    }
                    data.put(skey, 1);
                }
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Object key : data.keySet()) {
                String _key = String.valueOf(key);
                String _val = String.valueOf(data.get(_key));
                float rate = 100.0f * (float)BaseUtil.getInt(_val) / totalrows;
                result.put(_key, Float.valueOf(rate));
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new HashMap<String, Object>();
        }
    }

    @Override
    public Map<String, Object> AnalyzeExam(String pid) {
        try {
            return this.dao.AnalyzeExam(pid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> AnalyzeScore(String[] from, String[] to, String pid) {
        if (from == null || to == null) {
            return null;
        }
        if (from.length != to.length || from.length < 1) {
            return null;
        }
        pid = StringEscapeUtils.escapeSql((String)pid);
        try {
            return this.dao.AnalyzeScore(from, to, pid);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }
}

