/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.service.imp;

import com.tom.model.system.Pagination;
import com.tom.system.dao.IAdminDao;
import com.tom.system.service.IAdminService;
import com.tom.util.BaseUtil;
import com.tom.util.Constants;
import com.tom.util.Md5Util;
import com.tom.util.WebApplication;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="AdminService")
public class AdminServiceImp
implements IAdminService {
    private static final Logger logger = Logger.getLogger(AdminServiceImp.class);
    @Autowired
    private IAdminDao dao;

    @Override
    public int addAdmin(Map<String, Object> admin) {
        block4: {
            try {
                String a_username = (String)admin.get("a_username");
                Map<String, Object> adminchk = this.dao.getAdminByUsername(a_username);
                if (adminchk == null) break block4;
                return 3;
            }
            catch (Exception e) {
                logger.error((Object)e);
                return 0;
            }
        }
        String userpass = String.valueOf(admin.get("a_userpass"));
        String salt = BaseUtil.generateRandomString(10);
        if (BaseUtil.isNotEmpty(userpass)) {
            String password = WebApplication.getInstance().getSingletonObject(Md5Util.class).getMD5ofStr(String.valueOf(Constants.SYS_IDENTIFICATION_CODE) + userpass + salt);
            admin.put("a_userpass", password);
        }
        admin.put("a_id", BaseUtil.generateId());
        admin.put("a_salt", salt);
        return this.dao.addAdmin(admin);
    }

    @Override
    public int deleteAdmin(String id) {
        try {
            return this.dao.deleteAdmin(id);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public int deleteAdminLogic(String id) {
        try {
            return this.dao.updateAdminStatus(id, -9);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public int recoveryAdmin(String id) {
        try {
            return this.dao.updateAdminStatus(id, 1);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public int updateAdmin(Map<String, Object> admin) {
        try {
            String a_userpass = (String)admin.get("a_userpass");
            String a_id = (String)admin.get("a_id");
            if (BaseUtil.isNotEmpty(a_userpass)) {
                Map<String, Object> adm = this.dao.getAdmin(a_id);
                String salt = "";
                if (adm != null) {
                    salt = (String)adm.get("a_salt");
                }
                String password = WebApplication.getInstance().getSingletonObject(Md5Util.class).getMD5ofStr(String.valueOf(Constants.SYS_IDENTIFICATION_CODE) + a_userpass + salt);
                admin.put("a_userpass", password);
            }
            return this.dao.updateAdmin(admin);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public Map<String, Object> getAdmin(String id) {
        try {
            return this.dao.getAdmin(id);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public Pagination query(Map<String, Object> params, int pagesize, int currentPageNo) {
        try {
            return this.dao.query(params, pagesize, currentPageNo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new Pagination();
        }
    }

    @Override
    public boolean doCheckUsernameExist(String username) {
        try {
            Map<String, Object> map = this.dao.getAdminByUsername(username);
            return map != null;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }

    @Override
    public int doLogin(String username, String userpass) {
        String a_id;
        block5: {
            Map<String, Object> user;
            block4: {
                try {
                    user = this.dao.getAdminByUsername(username);
                    if (user != null) break block4;
                    return 10;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return 19;
                }
            }
            String salt = String.valueOf(user.get("a_salt"));
            String userpass_db = String.valueOf(user.get("a_userpass"));
            a_id = String.valueOf(user.get("a_id"));
            String userpass_xn = WebApplication.getInstance().getSingletonObject(Md5Util.class).getMD5ofStr(String.valueOf(Constants.SYS_IDENTIFICATION_CODE) + userpass + salt);
            if (userpass_db.equals(userpass_xn)) break block5;
            return 11;
        }
        HashMap<String, Object> addtion = new HashMap<String, Object>();
        addtion.put("a_id", a_id);
        this.dao.updateAdminAddtion(addtion);
        return 1;
    }
}

