/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.action;

import com.tom.model.system.BaseMessage;
import com.tom.model.system.BaseUrl;
import com.tom.model.system.Pagination;
import com.tom.system.service.IUserPositionService;
import com.tom.util.BaseUtil;
import com.tom.web.controller.BaseController;
import com.tom.web.message.MessageHelper;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/system/userposition"})
public class UserPositionController
extends BaseController {
    @Autowired
    private IUserPositionService service;

    @RequestMapping(value={"/add.thtml"})
    public ModelAndView add(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-UPOSITION-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        return new ModelAndView("system/userposition/add", (Map)modelMap);
    }

    @RequestMapping(value={"/list.thtml"})
    public ModelAndView list(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "F-UPOSITION")) {
            return this.RedirectToNoPrivelegePage();
        }
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        String epagesize = BaseUtil.convertEmptyToSome(request.getParameter("epagesize"), "10");
        Pagination page = this.service.query(null, BaseUtil.getInt(epagesize), BaseUtil.getInt(epage));
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        return new ModelAndView("system/userposition/list", (Map)modelMap);
    }

    @RequestMapping(value={"/load.thtml"})
    public ModelAndView load(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-UPOSITION-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        Map<String, Object> position = this.service.getUserPosition(id);
        if (position == null) {
            BaseMessage message = new BaseMessage(false, MessageHelper.getMessage("message.sys.nodata"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.userposition.add"), "system/userposition/add.thtml"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.userposition.list"), "system/userposition/list.thtml"));
            modelMap.put((Object)"message", (Object)message);
            return new ModelAndView("common/message", (Map)modelMap);
        }
        modelMap.put((Object)"userposition", position);
        return new ModelAndView("system/userposition/load", (Map)modelMap);
    }

    @RequestMapping(value={"/save.do"})
    public ModelAndView save(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-UPOSITION-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.service.addUserPosition(this.getRequestData(request));
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.userposition.add", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.userposition.add", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.userposition.add"), "system/userposition/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.userposition.list"), "system/userposition/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/delete.do"})
    public ModelAndView delete(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-UPOSITION-DELETE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        int i = this.service.deleteUserPosition(id);
        BaseMessage message = null;
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.userposition.delete", "message.sys.success")) : (i == 2 ? new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.userposition.hasMembers")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.userposition.delete", "message.sys.failed")));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.userposition.add"), "system/userposition/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.userposition.list"), "system/userposition/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/update.do"})
    public ModelAndView update(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-UPOSITION-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.service.updateUserPosition(this.getRequestData(request));
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.userposition.update", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.userposition.update", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.userposition.add"), "system/userposition/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.userposition.list"), "system/userposition/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }
}

