/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.action;

import com.tom.model.system.BaseMessage;
import com.tom.model.system.BaseUrl;
import com.tom.model.system.Pagination;
import com.tom.system.service.IBranchService;
import com.tom.system.service.IUserPositionService;
import com.tom.system.service.IUserService;
import com.tom.util.BaseUtil;
import com.tom.web.controller.BaseController;
import com.tom.web.message.MessageHelper;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/system/user"})
public class UserController
extends BaseController {
    @Autowired
    private IUserService user_service;
    @Autowired
    private IBranchService branch_service;
    @Autowired
    private IUserPositionService position_service;

    @RequestMapping(value={"/add.thtml"})
    public ModelAndView add(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-USER-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        modelMap.put((Object)"branches", this.branch_service.getAllBranchs());
        modelMap.put((Object)"postions", this.position_service.getAllPositions());
        return new ModelAndView("system/user/add", (Map)modelMap);
    }

    @RequestMapping(value={"/import.thtml"})
    public ModelAndView importx(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-USER-IMPORT")) {
            return this.RedirectToNoPrivelegePage();
        }
        modelMap.put((Object)"branches", this.branch_service.getAllBranchs());
        modelMap.put((Object)"postions", this.position_service.getAllPositions());
        return new ModelAndView("system/user/import", (Map)modelMap);
    }

    @RequestMapping(value={"/list.thtml"})
    public ModelAndView list(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "F-USERS")) {
            return this.RedirectToNoPrivelegePage();
        }
        modelMap.put((Object)"branches", this.branch_service.getAllBranchs());
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        String epagesize = BaseUtil.convertEmptyToSome(request.getParameter("epagesize"), "10");
        Map<String, Object> params = this.getRequestData(request);
        if (params != null && BaseUtil.isNotEmpty(request.getParameter("u_realname"))) {
            params.put("u_realname", BaseUtil.getChinese(request.getParameter("u_realname")));
        }
        Pagination page = this.user_service.query(params, BaseUtil.getInt(epagesize), BaseUtil.getInt(epage));
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        return new ModelAndView("system/user/list", (Map)modelMap);
    }

    @RequestMapping(value={"/list-query.thtml"})
    public ModelAndView listQuery(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "F-USERS")) {
            return this.RedirectToNoPrivelegePage();
        }
        modelMap.put((Object)"branches", this.branch_service.getAllBranchs());
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        String epagesize = BaseUtil.convertEmptyToSome(request.getParameter("epagesize"), "10");
        Map<String, Object> params = this.getRequestData(request);
        if (params != null && BaseUtil.isNotEmpty(request.getParameter("u_realname"))) {
            params.put("u_realname", BaseUtil.getChinese(request.getParameter("u_realname")));
        }
        Pagination page = this.user_service.query(params, BaseUtil.getInt(epagesize), BaseUtil.getInt(epage));
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        return new ModelAndView("system/user/list-query", (Map)modelMap);
    }

    @RequestMapping(value={"/load.thtml"})
    public ModelAndView load(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-USER-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        Map<String, Object> user = this.user_service.getUser(id);
        if (user == null) {
            BaseMessage message = new BaseMessage(false, MessageHelper.getMessage("message.sys.nodata"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.user.add"), "system/user/add.thtml"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.user.list"), "system/user/list.thtml"));
            modelMap.put((Object)"message", (Object)message);
            return new ModelAndView("common/message", (Map)modelMap);
        }
        modelMap.put((Object)"branches", this.branch_service.getAllBranchs());
        modelMap.put((Object)"postions", this.position_service.getAllPositions());
        modelMap.put((Object)"user", user);
        return new ModelAndView("system/user/load", (Map)modelMap);
    }

    @RequestMapping(value={"/save.do"})
    public ModelAndView save(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-USER-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.user_service.addUser(this.getRequestData(request));
        message = i == 2 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.user.add", "message.sys.success")) : (i == 3 ? new BaseMessage(false, MessageHelper.getMessage("message.sys.user.userexist")) : (i == -99 ? new BaseMessage(false, MessageHelper.getMessage("message.sys.user.exceeded")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.user.add", "message.sys.failed"))));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.user.add"), "system/user/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.user.list"), "system/user/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/batchImport.do"})
    public ModelAndView batchImport(HttpServletRequest request, @RequestParam(value="u_file", required=false) MultipartFile file, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-USER-IMPORT")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int rows = this.user_service.importUsers(file, request);
        if (rows >= 0) {
            StringBuffer msg = new StringBuffer();
            msg.append(MessageHelper.getMessage("message.sys.user.import"));
            msg.append(MessageHelper.getMessage("message.sys.success"));
            msg.append("," + MessageHelper.getMessage("txt.other.units.total") + ":");
            msg.append(rows);
            message = new BaseMessage(true, msg.toString());
        } else {
            message = rows == -1 ? new BaseMessage(false, MessageHelper.getMessage("message.sys.user.emptyfie")) : (rows == -9 ? new BaseMessage(false, MessageHelper.getMessage("message.sys.user.formaterror")) : (rows == -99 ? new BaseMessage(false, MessageHelper.getMessage("message.sys.user.exceeded")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.user.import", "message.sys.failed"))));
        }
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.user.add"), "system/user/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.user.list"), "system/user/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/delete.do"})
    public ModelAndView delete(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-USER-DELETE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        int i = this.user_service.deleteUser(id);
        BaseMessage message = null;
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.user.delete", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.user.delete", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.user.add"), "system/user/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.user.list"), "system/user/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/update.do"})
    public ModelAndView update(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-USER-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.user_service.updateUser(this.getRequestData(request));
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.user.update", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.user.update", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.user.add"), "system/user/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.user.list"), "system/user/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/batchop.do"})
    public ModelAndView batchOperation(HttpServletRequest request, ModelMap modelMap) {
        String op = request.getParameter("b_op");
        BaseMessage message = null;
        if ("batch_delete".equals(op)) {
            if (!this.HasPrivelege(request, "P-USER-DELETE")) {
                return this.RedirectToNoPrivelegePage();
            }
            int rows = this.user_service.batchDelete(request);
            if (rows >= 0) {
                StringBuffer msg = new StringBuffer();
                msg.append(MessageHelper.getMessage("message.sys.user.batch.delete"));
                msg.append(MessageHelper.getMessage("message.sys.success"));
                msg.append("," + MessageHelper.getMessage("txt.other.units.total") + ":");
                msg.append(rows);
                message = new BaseMessage(true, msg.toString());
            } else {
                message = new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.user.batch.delete", "message.sys.failed"));
            }
        } else if ("batch_status".equals(op)) {
            if (!this.HasPrivelege(request, "P-USER-UPDATE")) {
                return this.RedirectToNoPrivelegePage();
            }
            int rows = this.user_service.batchSetStatus(request);
            if (rows >= 0) {
                StringBuffer msg = new StringBuffer();
                msg.append(MessageHelper.getMessage("message.sys.user.batch.update"));
                msg.append(MessageHelper.getMessage("message.sys.success"));
                msg.append("," + MessageHelper.getMessage("txt.other.units.total") + ":");
                msg.append(rows);
                message = new BaseMessage(true, msg.toString());
            } else {
                message = new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.user.batch.update", "message.sys.failed"));
            }
        } else if ("batch_branch".equals(op)) {
            if (!this.HasPrivelege(request, "P-USER-UPDATE")) {
                return this.RedirectToNoPrivelegePage();
            }
            int rows = this.user_service.batchSetGid(request);
            if (rows >= 0) {
                StringBuffer msg = new StringBuffer();
                msg.append(MessageHelper.getMessage("message.sys.user.batch.update"));
                msg.append(MessageHelper.getMessage("message.sys.success"));
                msg.append("," + MessageHelper.getMessage("txt.other.units.total") + ":");
                msg.append(rows);
                message = new BaseMessage(true, msg.toString());
            } else {
                message = new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.user.batch.update", "message.sys.failed"));
            }
        }
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.user.add"), "system/user/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.user.list"), "system/user/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/examlist.thtml"})
    public ModelAndView examlist(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-USER-EXAMVIEW")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        Pagination page = this.user_service.examlist(id, 10, BaseUtil.getInt(epage));
        page.setChangesize(false);
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        modelMap.put((Object)"user", this.user_service.getUser(id));
        return new ModelAndView("system/user/examlist", (Map)modelMap);
    }

    @RequestMapping(value={"/selftestlist.thtml"})
    public ModelAndView selfTestList(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-USER-EXAMVIEW")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        Pagination page = this.user_service.selfTestList(id, 10, BaseUtil.getInt(epage));
        page.setChangesize(false);
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        modelMap.put((Object)"user", this.user_service.getUser(id));
        return new ModelAndView("system/user/selftestlist", (Map)modelMap);
    }
}

