/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.action;

import com.tom.model.system.BaseMessage;
import com.tom.model.system.BaseUrl;
import com.tom.model.system.Pagination;
import com.tom.system.service.IQuestionDBService;
import com.tom.util.BaseUtil;
import com.tom.web.controller.BaseController;
import com.tom.web.message.MessageHelper;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/system/qdb"})
public class QuestionDBController
extends BaseController {
    @Autowired
    private IQuestionDBService service;

    @RequestMapping(value={"/add.thtml"})
    public ModelAndView add(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-QDB-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        return new ModelAndView("system/qdb/add", (Map)modelMap);
    }

    @RequestMapping(value={"/list.thtml"})
    public ModelAndView list(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "F-QDB")) {
            return this.RedirectToNoPrivelegePage();
        }
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        String epagesize = BaseUtil.convertEmptyToSome(request.getParameter("epagesize"), "10");
        Pagination page = this.service.query(this.getRequestData(request), BaseUtil.getInt(epagesize), BaseUtil.getInt(epage));
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        return new ModelAndView("system/qdb/list", (Map)modelMap);
    }

    @RequestMapping(value={"/load.thtml"})
    public ModelAndView load(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-QDB-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        Map<String, Object> qdb = this.service.getQuestionDB(id);
        if (qdb == null) {
            BaseMessage message = new BaseMessage(false, MessageHelper.getMessage("message.sys.nodata"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.qdb.add"), "system/qdb/add.thtml"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.qdb.list"), "system/qdb/list.thtml"));
            modelMap.put((Object)"message", (Object)message);
            return new ModelAndView("common/message", (Map)modelMap);
        }
        modelMap.put((Object)"qdb", qdb);
        return new ModelAndView("system/qdb/load", (Map)modelMap);
    }

    @RequestMapping(value={"/save.do"})
    public ModelAndView save(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-QDB-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.service.addQuestionDB(this.getRequestData(request));
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages("", "message.sys.qdb.add", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages("", "message.sys.qdb.add", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.qdb.add"), "system/qdb/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.qdb.list"), "system/qdb/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/delete.do"})
    public ModelAndView delete(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-QDB-DELETE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        int i = this.service.deleteQuestionDB(id);
        BaseMessage message = null;
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages("", "message.sys.qdb.delete", "message.sys.success")) : (i == 2 ? new BaseMessage(false, MessageHelper.getMessages("", "message.sys.qdb.hasQuestions")) : new BaseMessage(false, MessageHelper.getMessages("", "message.sys.qdb.delete", "message.sys.failed")));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.qdb.add"), "system/qdb/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.qdb.list"), "system/qdb/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/update.do"})
    public ModelAndView update(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-QDB-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.service.updateQuestionDB(this.getRequestData(request));
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages("", "message.sys.qdb.update", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages("", "message.sys.qdb.update", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.qdb.add"), "system/qdb/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.qdb.list"), "system/qdb/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/analyse.thtml"})
    public ModelAndView analyse(HttpServletRequest request, ModelMap modelMap) {
        String id = request.getParameter("id");
        Map<String, Object> qdb = this.service.getQuestionDB(id);
        if (qdb != null) {
            Map<String, Object> map = this.service.AnalyseQuestionDB(id);
            if (map != null) {
                Object ls = map.get("info_question");
                try {
                    JSONArray array = JSONArray.fromObject((Object)ls);
                    modelMap.put((Object)"info_question", (Object)(array.size() < 1 ? null : array.toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            modelMap.put((Object)"qdb", qdb);
        }
        return new ModelAndView("system/qdb/analyse", (Map)modelMap);
    }
}

