/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.action;

import com.tom.model.ModelHelper;
import com.tom.model.system.BaseMessage;
import com.tom.model.system.BaseUrl;
import com.tom.model.system.Pagination;
import com.tom.system.service.IQuestionDBService;
import com.tom.system.service.IQuestionService;
import com.tom.util.BaseUtil;
import com.tom.web.controller.BaseController;
import com.tom.web.message.MessageHelper;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/system/question"})
public class QuestionController
extends BaseController {
    @Autowired
    private IQuestionService service;
    @Autowired
    private IQuestionDBService dbservice;

    @RequestMapping(value={"/add.thtml"})
    public ModelAndView add(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-QES-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        modelMap.put((Object)"qdbs", this.dbservice.getAllDBS());
        return new ModelAndView("system/question/add", (Map)modelMap);
    }

    @RequestMapping(value={"/import.thtml"})
    public ModelAndView importx(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-QES-IMPORT")) {
            return this.RedirectToNoPrivelegePage();
        }
        modelMap.put((Object)"qdbs", this.dbservice.getAllDBS());
        return new ModelAndView("system/question/import", (Map)modelMap);
    }

    @RequestMapping(value={"/list.thtml"})
    public ModelAndView list(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "F-QES")) {
            return this.RedirectToNoPrivelegePage();
        }
        Map<String, Object> params = this.getRequestData(request);
        if (params != null && BaseUtil.isNotEmpty(request.getParameter("q_content"))) {
            params.put("q_content", BaseUtil.getChinese(request.getParameter("q_content")));
        }
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        String epagesize = BaseUtil.convertEmptyToSome(request.getParameter("epagesize"), "10");
        Pagination page = this.service.query(params, BaseUtil.getInt(epagesize), BaseUtil.getInt(epage));
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        modelMap.put((Object)"qdbs", this.dbservice.getAllDBS());
        return new ModelAndView("system/question/list", (Map)modelMap);
    }

    @RequestMapping(value={"/query.thtml"})
    public void listx(HttpServletRequest request, PrintWriter out) {
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        String epagesize = BaseUtil.convertEmptyToSome(request.getParameter("epagesize"), "10");
        Map<String, Object> params = this.getRequestData(request);
        if (params != null && BaseUtil.isNotEmpty(request.getParameter("q_content"))) {
            params.put("q_content", BaseUtil.getChinese(request.getParameter("q_content")));
        }
        Pagination page = this.service.query(params, BaseUtil.getInt(epagesize), BaseUtil.getInt(epage));
        JSONObject json = new JSONObject();
        json.put((Object)"code", (Object)(page == null ? "err" : "ok"));
        json.put((Object)"data", page == null ? "" : page);
        out.print(json.toString());
    }

    @RequestMapping(value={"/load.thtml"})
    public ModelAndView load(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-QES-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String qid = request.getParameter("qid");
        Map<String, Object> question = this.service.getQuestion(qid);
        if (question == null) {
            BaseMessage message = new BaseMessage(false, MessageHelper.getMessage("message.sys.nodata"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.question.add"), "system/question/add.thtml"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.question.list"), "system/question/list.thtml"));
            modelMap.put((Object)"message", (Object)message);
            return new ModelAndView("common/message", (Map)modelMap);
        }
        modelMap.put((Object)"question", question);
        Object ques = ModelHelper.convertObject(String.valueOf(question.get("q_data")));
        JSONObject json = JSONObject.fromObject(ques);
        modelMap.put((Object)"json", (Object)json);
        modelMap.put((Object)"qdbs", this.dbservice.getAllDBS());
        return new ModelAndView("system/question/load", (Map)modelMap);
    }

    @RequestMapping(value={"/save.do"})
    public ModelAndView save(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-QES-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.service.addQuestion(request);
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.question.add", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.question.add", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.question.add"), "system/question/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.question.list"), "system/question/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/batchImportTxt.do"})
    public ModelAndView batchImportTxt(HttpServletRequest request, @RequestParam(value="q_file", required=false) MultipartFile file, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-QES-IMPORT")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int rows = this.service.importQuestionsFromTxt(file, request);
        message = rows > 0 ? new BaseMessage(true, String.valueOf(MessageHelper.getMessages(" ", "message.sys.question.import", "message.sys.success")) + " : " + rows) : (rows == -1 ? new BaseMessage(false, MessageHelper.getMessage("message.sys.question.emptyfie")) : (rows == -9 ? new BaseMessage(false, MessageHelper.getMessage("message.sys.question.formaterror")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.question.import", "message.sys.failed"))));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.question.add"), "system/question/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.question.list"), "system/question/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/batchImportExcel.do"})
    public ModelAndView batchImportExcel(HttpServletRequest request, @RequestParam(value="q_file", required=false) MultipartFile file, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-QES-IMPORT")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int rows = this.service.importQuestionsFromExcel(file, request);
        message = rows > 0 ? new BaseMessage(true, String.valueOf(MessageHelper.getMessages(" ", "message.sys.question.import", "message.sys.success")) + " : " + rows) : (rows == 0 ? new BaseMessage(false, MessageHelper.getMessage("message.sys.question.emptyfie")) : (rows == -9 ? new BaseMessage(false, MessageHelper.getMessage("message.sys.question.formaterror")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.question.import", "message.sys.failed"))));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.question.add"), "system/question/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.question.list"), "system/question/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/delete.do"})
    public ModelAndView delete(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-QES-DELETE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String qid = request.getParameter("qid");
        int i = this.service.deleteQuestion(qid);
        BaseMessage message = null;
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.question.delete", "message.sys.success")) : (i == 9 ? new BaseMessage(false, MessageHelper.getMessage("message.sys.question.hasused")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.question.delete", "message.sys.failed")));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.question.add"), "system/question/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.question.list"), "system/question/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/update.do"})
    public ModelAndView update(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-QES-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.service.updateQuestion(request);
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.question.update", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.question.update", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.question.add"), "system/question/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.question.list"), "system/question/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }
}

