/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.action;

import com.tom.model.ModelHelper;
import com.tom.model.paper.Paper;
import com.tom.model.system.BaseMessage;
import com.tom.model.system.BaseUrl;
import com.tom.model.system.Pagination;
import com.tom.system.service.IBranchService;
import com.tom.system.service.IPaperCategoryService;
import com.tom.system.service.IPaperService;
import com.tom.system.service.IQuestionDBService;
import com.tom.util.BaseUtil;
import com.tom.web.controller.BaseController;
import com.tom.web.message.MessageHelper;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/system/paper"})
public class PaperController
extends BaseController {
    @Autowired
    private IPaperService service;
    @Autowired
    private IQuestionDBService dbservice;
    @Autowired
    private IBranchService branchservice;
    @Autowired
    private IPaperCategoryService categoryservice;

    @RequestMapping(value={"/add.thtml"})
    public ModelAndView add(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-PAPER-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        modelMap.put((Object)"branches", this.branchservice.getAllBranchs());
        modelMap.put((Object)"categorys", this.categoryservice.getAllPaperCategorys());
        return new ModelAndView("system/paper/add", (Map)modelMap);
    }

    @RequestMapping(value={"/fastadd.thtml"})
    public ModelAndView fastadd(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-PAPER-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        modelMap.put((Object)"branches", this.branchservice.getAllBranchs());
        modelMap.put((Object)"categorys", this.categoryservice.getAllPaperCategorys());
        modelMap.put((Object)"qdbs", this.dbservice.getAllDBS());
        return new ModelAndView("system/paper/fastadd", (Map)modelMap);
    }

    @RequestMapping(value={"/list.thtml"})
    public ModelAndView list(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "F-PAPER")) {
            return this.RedirectToNoPrivelegePage();
        }
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        String epagesize = BaseUtil.convertEmptyToSome(request.getParameter("epagesize"), "10");
        Map<String, Object> params = this.getRequestData(request);
        params.put("p_name", BaseUtil.getChinese(request.getParameter("p_name")));
        Pagination page = this.service.query(params, BaseUtil.getInt(epagesize), BaseUtil.getInt(epage));
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        modelMap.put((Object)"categorys", this.categoryservice.getAllPaperCategorys());
        return new ModelAndView("system/paper/list", (Map)modelMap);
    }

    @RequestMapping(value={"/load.thtml"})
    public ModelAndView load(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-PAPER-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String pid = request.getParameter("pid");
        Map<String, Object> paper = this.service.getPaper(pid);
        if (paper == null) {
            BaseMessage message = new BaseMessage(false, MessageHelper.getMessage("message.sys.nodata"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.paper.add"), "system/paper/add.thtml"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.paper.list"), "system/paper/list.thtml"));
            modelMap.put((Object)"message", (Object)message);
            return new ModelAndView("common/message", (Map)modelMap);
        }
        modelMap.put((Object)"paper", paper);
        modelMap.put((Object)"branches", this.branchservice.getAllBranchs());
        modelMap.put((Object)"categorys", this.categoryservice.getAllPaperCategorys());
        modelMap.put((Object)"links", this.service.getPaperLink(pid));
        return new ModelAndView("system/paper/load", (Map)modelMap);
    }

    @RequestMapping(value={"/detail.thtml"})
    public ModelAndView loadDetail(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-PAPER-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String pid = request.getParameter("pid");
        Map<String, Object> paper = this.service.getPaper(pid);
        if (paper == null) {
            BaseMessage message = new BaseMessage(false, MessageHelper.getMessage("message.sys.nodata"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.paper.add"), "system/paper/add.thtml"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.paper.list"), "system/paper/list.thtml"));
            modelMap.put((Object)"message", (Object)message);
            return new ModelAndView("common/message", (Map)modelMap);
        }
        modelMap.put((Object)"paper", paper);
        Paper paperx = (Paper)ModelHelper.convertObject(String.valueOf(paper.get("p_data")));
        modelMap.put((Object)"paperx", (Object)paperx);
        modelMap.put((Object)"qdbs", this.dbservice.getAllDBS());
        modelMap.put((Object)"links", this.service.getPaperLink(pid));
        String pType = String.valueOf(paper.get("p_papertype"));
        if ("0".equals(pType)) {
            return new ModelAndView("system/paper/detail_normal", (Map)modelMap);
        }
        return new ModelAndView("system/paper/detail_random", (Map)modelMap);
    }

    @RequestMapping(value={"/save.do"})
    public ModelAndView save(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-PAPER-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.service.addPaper(this.getRequestData(request));
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.paper.add", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.paper.add", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.paper.add"), "system/paper/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.paper.list"), "system/paper/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/fastsave.do"})
    public ModelAndView fastsave(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-PAPER-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.service.fastAddPaper(request);
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.paper.fastadd", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.paper.fastadd", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.paper.fastadd"), "system/paper/fastadd.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.paper.list"), "system/paper/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/delete.do"})
    public ModelAndView delete(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-PAPER-DELETE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String pid = request.getParameter("pid");
        int i = this.service.deletePaper(pid);
        BaseMessage message = null;
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.paper.delete", "message.sys.success")) : (i == 2 ? new BaseMessage(false, MessageHelper.getMessage("message.sys.paper.hasUsers")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.paper.delete", "message.sys.failed")));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.paper.add"), "system/paper/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.paper.list"), "system/paper/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/update.do"})
    public ModelAndView update(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-PAPER-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.service.updatePaper(this.getRequestData(request));
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.paper.update", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.paper.update", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.paper.add"), "system/paper/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.paper.list"), "system/paper/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/updateDetail.do"})
    public ModelAndView updateDetail(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-PAPER-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.service.updatePaperDetail(request);
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.paper.update", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.paper.update", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.paper.add"), "system/paper/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.paper.list"), "system/paper/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/export-word.do"})
    public void exportWord(HttpServletRequest request, PrintWriter out) {
        if (!this.HasPrivelege(request, "P-PAPER-EXPORTWORD")) {
            JSONObject ret = new JSONObject();
            ret.put((Object)"code", (Object)"no_right");
            ret.put((Object)"data", (Object)MessageHelper.getMessage("message.other.no_right"));
            out.write(ret.toString());
            return;
        }
        String pid = BaseUtil.convertEmptyToSome(request.getParameter("pid"), "1");
        String filename = this.service.doExportPaperAsWord(pid);
        JSONObject json = new JSONObject();
        if (BaseUtil.isEmpty(filename)) {
            json.put((Object)"code", (Object)"err");
            json.put((Object)"data", (Object)"");
        } else {
            json.put((Object)"code", (Object)"ok");
            json.put((Object)"data", (Object)filename);
        }
        out.write(json.toString());
    }

    @RequestMapping(value={"/clone-paper.do"})
    public void clonePaper(HttpServletRequest request, PrintWriter out) {
        if (!this.HasPrivelege(request, "P-PAPER-CLONE")) {
            JSONObject ret = new JSONObject();
            ret.put((Object)"code", (Object)"no_right");
            ret.put((Object)"data", (Object)MessageHelper.getMessage("message.other.no_right"));
            out.write(ret.toString());
            return;
        }
        String pid = request.getParameter("pid");
        String pname = request.getParameter("pname");
        int code = 0;
        code = BaseUtil.isEmpty(pid) ? -1 : (BaseUtil.isEmpty(pname) ? -2 : this.service.doCopyPaper(pid, pname));
        JSONObject json = new JSONObject();
        if (code == 1) {
            json.put((Object)"code", (Object)"ok");
            json.put((Object)"data", (Object)MessageHelper.getMessage("message.other.op_ok"));
        } else if (code == -1) {
            json.put((Object)"code", (Object)"err");
            json.put((Object)"data", (Object)MessageHelper.getMessage("message.sys.paper.copy.noid"));
        } else if (code == -2) {
            json.put((Object)"code", (Object)"err");
            json.put((Object)"data", (Object)MessageHelper.getMessage("message.sys.paper.copy.noname"));
        } else {
            json.put((Object)"code", (Object)"err");
            json.put((Object)"data", (Object)MessageHelper.getMessage("message.other.op_failed"));
        }
        out.write(json.toString());
    }
}

