/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.action;

import com.tom.model.system.BaseMessage;
import com.tom.model.system.BaseUrl;
import com.tom.model.system.Pagination;
import com.tom.system.service.INewsService;
import com.tom.util.BaseUtil;
import com.tom.web.controller.BaseController;
import com.tom.web.message.MessageHelper;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/system/news"})
public class NewsController
extends BaseController {
    @Autowired
    private INewsService service;

    @RequestMapping(value={"/category/add.thtml"})
    public ModelAndView addCategory(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-NEWSCATE-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        return new ModelAndView("system/news/category/add", (Map)modelMap);
    }

    @RequestMapping(value={"/category/list.thtml"})
    public ModelAndView listCategory(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "F-NEWSCATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        String epagesize = BaseUtil.convertEmptyToSome(request.getParameter("epagesize"), "10");
        Pagination page = this.service.queryNewsCategories(null, BaseUtil.getInt(epagesize), BaseUtil.getInt(epage));
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        return new ModelAndView("system/news/category/list", (Map)modelMap);
    }

    @RequestMapping(value={"/category/load.thtml"})
    public ModelAndView loadCategory(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-NEWSCATE-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String categoryid = request.getParameter("cid");
        Map<String, Object> category = this.service.getNewsCategory(categoryid);
        if (category == null) {
            BaseMessage message = new BaseMessage(false, MessageHelper.getMessage("message.sys.nodata"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.category.add"), "system/news/category/add.thtml"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.category.list"), "system/news/category/list.thtml"));
            modelMap.put((Object)"message", (Object)message);
            return new ModelAndView("common/message", (Map)modelMap);
        }
        modelMap.put((Object)"category", category);
        return new ModelAndView("system/news/category/load", (Map)modelMap);
    }

    @RequestMapping(value={"/category/save.do"})
    public ModelAndView saveCategory(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-NEWSCATE-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.service.addNewsCategory(this.getRequestData(request));
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.news.category.add", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.news.category.add", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.category.add"), "system/news/category/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.category.list"), "system/news/category/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/category/delete.do"})
    public ModelAndView deleteCategory(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-NEWSCATE-DELETE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String cid = request.getParameter("cid");
        int i = this.service.deleteNewsCategory(cid);
        BaseMessage message = null;
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.news.category.delete", "message.sys.success")) : (i == 2 ? new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.news.category.hasNews")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.news.category.delete", "message.sys.failed")));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.category.add"), "system/news/category/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.category.list"), "system/news/category/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/category/update.do"})
    public ModelAndView updateCategory(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-NEWSCATE-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.service.updateNewsCategory(this.getRequestData(request));
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.news.category.update", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.news.category.update", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.category.add"), "system/news/category/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.category.list"), "system/news/category/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/add.thtml"})
    public ModelAndView add(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-NEWS-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        modelMap.put((Object)"categories", this.service.getAllNewsCategories());
        return new ModelAndView("system/news/add", (Map)modelMap);
    }

    @RequestMapping(value={"/list.thtml"})
    public ModelAndView list(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "F-NEWS")) {
            return this.RedirectToNoPrivelegePage();
        }
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        String epagesize = BaseUtil.convertEmptyToSome(request.getParameter("epagesize"), "10");
        Map<String, Object> params = this.getRequestData(request);
        params.put("n_title", BaseUtil.getChinese(request.getParameter("n_title")));
        Pagination page = this.service.queryNews(params, BaseUtil.getInt(epagesize), BaseUtil.getInt(epage));
        modelMap.put((Object)"categories", this.service.getAllNewsCategories());
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        return new ModelAndView("system/news/list", (Map)modelMap);
    }

    @RequestMapping(value={"/load.thtml"})
    public ModelAndView load(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-NEWS-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        Map<String, Object> news = this.service.getNews(id);
        if (news == null) {
            BaseMessage message = new BaseMessage(false, MessageHelper.getMessage("message.sys.nodata"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.add"), "system/news/add.thtml"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.list"), "system/news/list.thtml"));
            modelMap.put((Object)"message", (Object)message);
            return new ModelAndView("common/message", (Map)modelMap);
        }
        modelMap.put((Object)"categories", this.service.getAllNewsCategories());
        modelMap.put((Object)"news", news);
        return new ModelAndView("system/news/load", (Map)modelMap);
    }

    @RequestMapping(value={"/save.do"})
    public ModelAndView save(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-NEWS-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        Map<String, Object> news = this.getRequestData(request);
        news.put("n_content", request.getParameter("n_content"));
        int i = this.service.addNews(news);
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.news.add", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.news.add", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.add"), "system/news/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.list"), "system/news/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/delete.do"})
    public ModelAndView delete(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-NEWS-DELETE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        int i = this.service.deleteNews(id);
        BaseMessage message = null;
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.news.delete", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.news.delete", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.add"), "system/news/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.list"), "system/news/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/update.do"})
    public ModelAndView update(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-NEWS-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        Map<String, Object> news = this.getRequestData(request);
        news.put("n_content", request.getParameter("n_content"));
        int i = this.service.updateNews(news);
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.news.update", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.news.update", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.add"), "system/news/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.news.list"), "system/news/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }
}

