/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.action;

import com.tom.model.ModelHelper;
import com.tom.model.course.Course;
import com.tom.model.system.BaseMessage;
import com.tom.model.system.BaseUrl;
import com.tom.model.system.Pagination;
import com.tom.system.service.ICourseCategoryService;
import com.tom.system.service.ICourseService;
import com.tom.system.service.ICourseTeacherService;
import com.tom.util.BaseUtil;
import com.tom.web.controller.BaseController;
import com.tom.web.message.MessageHelper;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/system/course"})
public class CourseController
extends BaseController {
    @Autowired
    private ICourseService service;
    @Autowired
    private ICourseCategoryService category_service;
    @Autowired
    private ICourseTeacherService teacher_service;

    @RequestMapping(value={"/add.thtml"})
    public ModelAndView add(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-COURSE-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        modelMap.put((Object)"categories", this.category_service.getAllCategories());
        modelMap.put((Object)"teachers", this.teacher_service.getAllTeachers());
        return new ModelAndView("system/course/add", (Map)modelMap);
    }

    @RequestMapping(value={"/list.thtml"})
    public ModelAndView list(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "F-COURSE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        String epagesize = BaseUtil.convertEmptyToSome(request.getParameter("epagesize"), "10");
        Pagination page = this.service.queryCourse(this.getRequestData(request), BaseUtil.getInt(epagesize), BaseUtil.getInt(epage));
        modelMap.put((Object)"categories", this.category_service.getAllCategories());
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        return new ModelAndView("system/course/list", (Map)modelMap);
    }

    @RequestMapping(value={"/load.thtml"})
    public ModelAndView load(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-COURSE-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        Map<String, Object> course = this.service.getCourse(id);
        if (course == null) {
            BaseMessage message = new BaseMessage(false, MessageHelper.getMessage("message.sys.nodata"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.course.add"), "system/course/add.thtml"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.course.list"), "system/course/list.thtml"));
            modelMap.put((Object)"message", (Object)message);
            return new ModelAndView("common/message", (Map)modelMap);
        }
        try {
            Course coursex = (Course)ModelHelper.convertObject(String.valueOf(course.get("c_data")));
            modelMap.put((Object)"coursex", (Object)coursex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        modelMap.put((Object)"categories", this.category_service.getAllCategories());
        modelMap.put((Object)"course", course);
        modelMap.put((Object)"teachers", this.teacher_service.getAllTeachers());
        return new ModelAndView("system/course/load", (Map)modelMap);
    }

    @RequestMapping(value={"/save.do"})
    public ModelAndView save(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-COURSE-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.service.addCourse(request);
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.course.add", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.course.add", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.course.add"), "system/course/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.course.list"), "system/course/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/delete.do"})
    public ModelAndView delete(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-COURSE-DELETE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        int i = this.service.deleteCourse(id);
        BaseMessage message = null;
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.course.delete", "message.sys.success")) : (i == 2 ? new BaseMessage(false, MessageHelper.getMessage("message.sys.course.delete.hasusers")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.course.delete", "message.sys.failed")));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.course.add"), "system/course/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.course.list"), "system/course/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/update.do"})
    public ModelAndView update(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-COURSE-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.service.updateCourse(request);
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.course.update", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.course.update", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.course.add"), "system/course/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.course.list"), "system/course/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/learnrecord.thtml"})
    public ModelAndView learnRecord(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "F-COURSE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("p_cid", id);
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        Pagination page = this.service.queryCourseLearnRecord(params, 10, BaseUtil.getInt(epage));
        page.setChangesize(false);
        Map<String, Object> course = this.service.getCourse(id);
        modelMap.put((Object)"course", course);
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        return new ModelAndView("system/course/learnrecord", (Map)modelMap);
    }

    @RequestMapping(value={"/clear_learnrecord.do"})
    public void clearLearnRecord(HttpServletRequest request, PrintWriter out) {
        if (!this.HasPrivelege(request, "P-COURSE-DELETE")) {
            JSONObject ret = new JSONObject();
            ret.put((Object)"code", (Object)"no_right");
            ret.put((Object)"msg", (Object)MessageHelper.getMessage("message.other.no_right"));
            out.write(ret.toString());
            return;
        }
        String cid = request.getParameter("cid");
        JSONObject json = new JSONObject();
        if (BaseUtil.isEmpty(cid)) {
            json.put((Object)"code", (Object)"err");
            json.put((Object)"msg", (Object)MessageHelper.getMessage("message.system.param_lost"));
            out.write(json.toString());
            return;
        }
        int rows = this.service.clearLearnRecord(cid);
        if (rows >= 0) {
            json.put((Object)"code", (Object)"ok");
            json.put((Object)"msg", (Object)MessageHelper.getMessage("message.other.op_ok"));
        } else {
            json.put((Object)"code", (Object)"err");
            json.put((Object)"msg", (Object)MessageHelper.getMessage("message.other.op_failed"));
        }
        out.write(json.toString());
    }
}

