/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.action;

import com.tom.core.service.ICorePaperService;
import com.tom.model.system.Pagination;
import com.tom.system.service.IAnalysisService;
import com.tom.system.service.IPaperCategoryService;
import com.tom.util.BaseUtil;
import com.tom.web.controller.BaseController;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/system/analysis"})
public class AnalysisController
extends BaseController {
    @Autowired
    private IAnalysisService service;
    @Autowired
    private ICorePaperService paperservice;
    @Autowired
    private IPaperCategoryService categoryservice;

    @RequestMapping(value={"/paperlist.thtml"})
    public ModelAndView paperlist(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "F-ANALYSIS")) {
            return this.RedirectToNoPrivelegePage();
        }
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        Pagination page = this.service.queryPaper(this.getRequestData(request), 10, BaseUtil.getInt(epage));
        page.setChangesize(false);
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        modelMap.put((Object)"categorys", this.categoryservice.getAllPaperCategorys());
        return new ModelAndView("system/analysis/paperlist", (Map)modelMap);
    }

    @RequestMapping(value={"/paper/index.thtml"})
    public ModelAndView paper(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-ANA-PAPER")) {
            return this.RedirectToNoPrivelegePage();
        }
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        String epagesize = BaseUtil.convertEmptyToSome(request.getParameter("epagesize"), "10");
        Map<String, Object> params = this.getRequestData(request);
        params.put("p_name", BaseUtil.getChinese(request.getParameter("p_name")));
        Pagination page = this.service.AnalyzePaperList(params, BaseUtil.getInt(epagesize), BaseUtil.getInt(epage));
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        modelMap.put((Object)"categorys", this.categoryservice.getAllPaperCategorys());
        return new ModelAndView("system/analysis/paper/index", (Map)modelMap);
    }

    @RequestMapping(value={"/paper/detail.thtml"})
    public ModelAndView paperDetail(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-ANA-PAPER")) {
            return this.RedirectToNoPrivelegePage();
        }
        String pid = request.getParameter("pid");
        modelMap.put((Object)"paper", (Object)this.paperservice.getPaper(pid));
        modelMap.put((Object)"detail", this.service.AnalyzePaperDetail(pid));
        return new ModelAndView("system/analysis/paper/detail", (Map)modelMap);
    }

    @RequestMapping(value={"/exam/index.thtml"})
    public ModelAndView exam(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-ANA-EXAM")) {
            return this.RedirectToNoPrivelegePage();
        }
        return new ModelAndView("system/analysis/exam/index", (Map)modelMap);
    }

    @RequestMapping(value={"/exam/analyse.do"})
    public void examAnalyse(HttpServletRequest request, PrintWriter out) {
        if (!this.HasPrivelege(request, "P-ANA-EXAM")) {
            JSONObject json = new JSONObject();
            json.put((Object)"code", (Object)"err");
            json.put((Object)"message", (Object)"");
            return;
        }
        String pid = request.getParameter("pid");
        JSONObject json = new JSONObject();
        Map<String, Object> map = this.service.AnalyzeExam(pid);
        if (map == null) {
            json.put((Object)"code", (Object)"err");
            json.put((Object)"message", (Object)"");
        } else {
            json.put((Object)"code", (Object)"ok");
            json.put((Object)"message", (Object)"");
            json.put((Object)"data", map);
        }
        out.write(json.toString());
    }

    @RequestMapping(value={"/score/index.thtml"})
    public ModelAndView score(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-ANA-SCORE")) {
            return this.RedirectToNoPrivelegePage();
        }
        return new ModelAndView("system/analysis/score/index", (Map)modelMap);
    }

    @RequestMapping(value={"/score/analyse.do"})
    public void scoreAnalyse(HttpServletRequest request, PrintWriter out) {
        if (!this.HasPrivelege(request, "P-ANA-SCORE")) {
            JSONObject json = new JSONObject();
            json.put((Object)"code", (Object)"err");
            json.put((Object)"message", (Object)"");
            return;
        }
        String pid = request.getParameter("pid");
        String[] from = request.getParameterValues("s_from");
        String[] to = request.getParameterValues("s_to");
        JSONObject json = new JSONObject();
        List<Map<String, Object>> list = this.service.AnalyzeScore(from, to, pid);
        if (list == null) {
            json.put((Object)"code", (Object)"err");
            json.put((Object)"message", (Object)"");
        } else {
            json.put((Object)"code", (Object)"ok");
            json.put((Object)"message", (Object)"");
            json.put((Object)"data", list);
        }
        out.write(json.toString());
    }
}

