/*
 * Decompiled with CFR 0.152.
 */
package com.tom.system.action;

import com.tom.model.system.BaseMessage;
import com.tom.model.system.BaseUrl;
import com.tom.model.system.ModuleParser;
import com.tom.model.system.Pagination;
import com.tom.system.service.IAdminRoleService;
import com.tom.util.BaseUtil;
import com.tom.web.controller.BaseController;
import com.tom.web.message.MessageHelper;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/system/role"})
public class AdminRoleController
extends BaseController {
    @Autowired
    private IAdminRoleService roleservice;

    @RequestMapping(value={"/add.thtml"})
    public ModelAndView add(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-ROLE-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        modelMap.put((Object)"modules", ModuleParser.getModules());
        return new ModelAndView("system/role/add", (Map)modelMap);
    }

    @RequestMapping(value={"/list.thtml"})
    public ModelAndView list(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "F-ROLE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String epage = BaseUtil.convertEmptyToSome(request.getParameter("epage"), "1");
        String epagesize = BaseUtil.convertEmptyToSome(request.getParameter("epagesize"), "10");
        Pagination page = this.roleservice.query(null, BaseUtil.getInt(epagesize), BaseUtil.getInt(epage));
        modelMap.put((Object)"page", (Object)page);
        modelMap.put((Object)"foot", (Object)page.getNavFoot(request));
        return new ModelAndView("system/role/list", (Map)modelMap);
    }

    @RequestMapping(value={"/load.thtml"})
    public ModelAndView load(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-ROLE-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        Map<String, Object> role = this.roleservice.getAdminRole(id);
        if (role == null) {
            BaseMessage message = new BaseMessage(false, MessageHelper.getMessage("message.sys.nodata"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.role.add"), "system/role/add.thtml"));
            message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.role.list"), "system/role/list.thtml"));
            modelMap.put((Object)"message", (Object)message);
            return new ModelAndView("common/message", (Map)modelMap);
        }
        modelMap.put((Object)"modules", ModuleParser.getModules());
        modelMap.put((Object)"role", role);
        return new ModelAndView("system/role/load", (Map)modelMap);
    }

    @RequestMapping(value={"/save.do"})
    public ModelAndView save(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-ROLE-ADD")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.roleservice.addAdminRole(this.getRequestData(request));
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.role.add", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.role.add", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.role.add"), "system/role/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.role.list"), "system/role/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/delete.do"})
    public ModelAndView delete(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-ROLE-DELETE")) {
            return this.RedirectToNoPrivelegePage();
        }
        String id = request.getParameter("id");
        int i = this.roleservice.deleteAdminRole(id);
        BaseMessage message = null;
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.role.delete", "message.sys.success")) : (i == 2 ? new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.role.hasMembers")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.role.delete", "message.sys.failed")));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.role.add"), "system/role/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.role.list"), "system/role/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }

    @RequestMapping(value={"/update.do"})
    public ModelAndView update(HttpServletRequest request, ModelMap modelMap) {
        if (!this.HasPrivelege(request, "P-ROLE-UPDATE")) {
            return this.RedirectToNoPrivelegePage();
        }
        BaseMessage message = null;
        int i = this.roleservice.updateAdminRole(this.getRequestData(request));
        message = i == 1 ? new BaseMessage(true, MessageHelper.getMessages(" ", "message.sys.role.update", "message.sys.success")) : new BaseMessage(false, MessageHelper.getMessages(" ", "message.sys.role.update", "message.sys.failed"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.role.add"), "system/role/add.thtml"));
        message.addUrl(new BaseUrl(MessageHelper.getMessage("txt.sys.role.list"), "system/role/list.thtml"));
        modelMap.put((Object)"message", (Object)message);
        return new ModelAndView("common/message", (Map)modelMap);
    }
}

