/*
 * Decompiled with CFR 0.152.
 */
package com.tom.core.task;

import com.tom.core.service.ICoreSystemService;
import com.tom.core.util.SystemConnector;
import com.tom.util.Constants;
import com.tom.web.message.MessageHelper;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class SystemTask {
    private static final Logger logger = Logger.getLogger(SystemTask.class);
    @Autowired
    private ICoreSystemService service;
    private boolean loaded = false;

    @Scheduled(fixedRate=3600000L)
    public void doSystemHeartBeat() {
        int users = this.service.getTotalUsers();
        if (users < 0) {
            logger.error((Object)("\u5b9a\u65f6\u4efb\u52a1:\u7528\u6237\u6570\u5f02\u5e38,users=" + users));
        }
    }

    @Scheduled(fixedRate=86400000L)
    public void doSystemSettings() {
        if (!this.loaded) {
            logger.info((Object)"\u7cfb\u7edf\u8bbe\u7f6e:\u8bbe\u5b9a\u7cfb\u7edf\u53c2\u6570...");
            String lang = this.service.getConfigValue("sys_lang");
            MessageHelper.setLang(lang);
            logger.info((Object)"\u7cfb\u7edf\u8bbe\u7f6e:\u52a0\u8f7d\u7cfb\u7edf\u6743\u9650...");
            this.service.loadAllAdminPrivilege();
            this.loaded = true;
        }
    }

    @Scheduled(fixedRate=5000L)
    public void doSystemLogCheck() {
        int rows = this.service.doCheckSystemLogQueue();
        if (rows > 0) {
            logger.info((Object)("\u5b9a\u65f6\u4efb\u52a1:\u6210\u529f\u5165\u5e93" + rows + "\u6761\u7cfb\u7edf\u65e5\u5fd7."));
        }
    }

    @Scheduled(fixedRate=86400000L)
    public void doSystemConnect() {
        int users = this.service.getTotalUsers();
        String d = "F-MID-" + Constants.getSystemId() + "--U-" + users;
        try {
            SystemConnector.doConnect(d);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

